/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.world.gen.feature;

import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.RandomizableContainer;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SpawnerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.MonsterRoomFeature;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.neoforged.neoforge.common.MonsterRoomHooks;
import org.cyclops.evilcraft.RegistryEntries;

public class WorldFeatureEvilDungeon
extends MonsterRoomFeature {
    private static final int RADIUS_X = 3;
    private static final int RADIUS_X_RAND = 4;
    private static final int RADIUS_Z = 3;
    private static final int RADIUS_Z_RAND = 4;
    private static final int CHESTS = 2;
    private static final int CHESTS_RAND = 2;

    public WorldFeatureEvilDungeon(Codec<NoneFeatureConfiguration> config) {
        super(config);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        BlockPos loopPos;
        int zr;
        int yr;
        int xr;
        WorldGenLevel world = context.level();
        BlockPos blockPos = context.origin();
        RandomSource random = context.random();
        int height = 3;
        int radiusX = random.nextInt(4) + 3;
        int radiusZ = random.nextInt(4) + 3;
        int chests = random.nextInt(2) + 2;
        int openingCounter = 0;
        int x = blockPos.getX();
        int y = blockPos.getY();
        int z = blockPos.getZ();
        for (xr = x - radiusX - 1; xr <= x + radiusX + 1; ++xr) {
            for (yr = y - 1; yr <= y + height + 1; ++yr) {
                for (zr = z - radiusZ - 1; zr <= z + radiusZ + 1; ++zr) {
                    loopPos = new BlockPos(xr, yr, zr);
                    if (!world.getChunkSource().hasChunk(xr / 16, yr / 16)) {
                        return false;
                    }
                    BlockState blockState = world.getBlockState(loopPos);
                    if (yr == y - 1 && !blockState.isSolid()) {
                        return false;
                    }
                    if (yr == y + height + 1 && !blockState.isSolid()) {
                        return false;
                    }
                    if (xr != x - radiusX - 1 && xr != x + radiusX + 1 && zr != z - radiusZ - 1 && zr != z + radiusZ + 1 || yr != y || !world.isEmptyBlock(loopPos) || !world.isEmptyBlock(loopPos.offset(0, 1, 0))) continue;
                    ++openingCounter;
                }
            }
        }
        if (openingCounter >= 1 && openingCounter <= 15) {
            BlockPos loopPos2;
            for (xr = x - radiusX - 1; xr <= x + radiusX + 1; ++xr) {
                for (yr = y + height; yr >= y - 1; --yr) {
                    for (zr = z - radiusZ - 1; zr <= z + radiusZ + 1; ++zr) {
                        loopPos = new BlockPos(xr, yr, zr);
                        if (xr != x - radiusX - 1 && yr != y - 1 && zr != z - radiusZ - 1 && xr != x + radiusX + 1 && yr != y + height + 1 && zr != z + radiusZ + 1) {
                            world.removeBlock(loopPos, false);
                            continue;
                        }
                        if (yr >= 0 && !world.getBlockState(loopPos.offset(0, -1, 0)).isSolid()) {
                            world.removeBlock(loopPos, false);
                            continue;
                        }
                        if (!world.getBlockState(loopPos).isSolid()) continue;
                        if (yr == y - 1 && random.nextInt(4) != 0) {
                            world.setBlock(loopPos, ((Block)RegistryEntries.BLOCK_BLOODY_COBBLESTONE.get()).defaultBlockState(), 2);
                            continue;
                        }
                        world.setBlock(loopPos, Blocks.COBBLESTONE.defaultBlockState(), 2);
                    }
                }
            }
            int attempts = 100;
            for (int xr2 = 0; xr2 < attempts && chests > 0; ++xr2) {
                int zrr;
                int xrr = x + random.nextInt(radiusX * 2 + 1) - radiusX;
                loopPos2 = new BlockPos(xrr, y, zrr = z + random.nextInt(radiusZ * 2 + 1) - radiusZ);
                if (!world.isEmptyBlock(loopPos2)) continue;
                int wallCounter = 0;
                if (world.getBlockState(loopPos2.offset(-1, 0, 0)).isSolid()) {
                    ++wallCounter;
                }
                if (world.getBlockState(loopPos2.offset(1, 0, 0)).isSolid()) {
                    ++wallCounter;
                }
                if (world.getBlockState(loopPos2.offset(0, 0, -1)).isSolid()) {
                    ++wallCounter;
                }
                if (world.getBlockState(loopPos2.offset(0, 0, 1)).isSolid()) {
                    ++wallCounter;
                }
                if (wallCounter != 1) continue;
                world.setBlock(loopPos2, Blocks.CHEST.defaultBlockState(), 2);
                RandomizableContainer.setBlockEntityLootTable((BlockGetter)world, (RandomSource)random, (BlockPos)loopPos2, (ResourceKey)BuiltInLootTables.SIMPLE_DUNGEON);
                --chests;
            }
            for (int xs = x - 1; xs <= x + 1; xs += 2) {
                for (int zs = z - 1; zs <= z + 1; zs += 2) {
                    loopPos2 = new BlockPos(xs, y, zs);
                    world.setBlock(loopPos2, Blocks.SPAWNER.defaultBlockState(), 2);
                    BlockEntity tile = world.getBlockEntity(loopPos2);
                    if (tile instanceof SpawnerBlockEntity) {
                        ((SpawnerBlockEntity)tile).getSpawner().setEntityId(MonsterRoomHooks.getRandomMonsterRoomMob((RandomSource)random), null, random, loopPos2);
                        continue;
                    }
                    System.err.println("Failed to fetch mob spawner entity at (" + xs + ", " + y + ", " + zs + ")");
                }
            }
            return true;
        }
        return false;
    }
}

