/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraftcompat.modcompat.capabilities;

import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.neoforge.capabilities.BaseCapability;
import net.neoforged.neoforge.capabilities.ICapabilityProvider;
import org.cyclops.commoncapabilities.api.capability.Capabilities;
import org.cyclops.commoncapabilities.api.capability.work.IWorker;
import org.cyclops.cyclopscore.modcompat.capabilities.ICapabilityConstructor;
import org.cyclops.evilcraft.core.blockentity.BlockEntityTankInventory;
import org.cyclops.evilcraft.core.blockentity.BlockEntityTickingTankInventory;
import org.cyclops.evilcraft.core.blockentity.tickaction.ITickAction;
import org.cyclops.evilcraft.core.blockentity.tickaction.TickComponent;

public class WorkerWorkingBlockEntityCompat<T extends BlockEntityTickingTankInventory<?>>
implements ICapabilityConstructor<T, Direction, IWorker, BlockEntityType<T>> {
    public BaseCapability<IWorker, Direction> getCapability() {
        return Capabilities.Worker.BLOCK;
    }

    @Nullable
    public ICapabilityProvider<T, Direction, IWorker> createProvider(BlockEntityType<T> host) {
        return (blockEntity, side) -> new Worker<BlockEntityTickingTankInventory>((BlockEntityTickingTankInventory)((Object)blockEntity));
    }

    public static class Worker<T extends BlockEntityTickingTankInventory<?>>
    implements IWorker {
        private final T provider;

        public Worker(T provider) {
            this.provider = provider;
        }

        public boolean hasWork() {
            for (TickComponent ticker : ((BlockEntityTickingTankInventory)((Object)this.provider)).getTickers()) {
                ItemStack itemStack = ((BlockEntityTankInventory)((Object)this.provider)).getInventory().getItem(ticker.getSlot());
                if (itemStack.isEmpty()) continue;
                int actionOffset = 0;
                ITickAction<T> tickAction = ticker.getTickAction(itemStack.getItem(), actionOffset++);
                if (tickAction == null || !tickAction.canTick(this.provider, itemStack, ticker.getSlot(), ticker.getTick())) continue;
                return true;
            }
            return false;
        }

        public boolean canWork() {
            return !this.provider.getLevel().hasNeighborSignal(this.provider.getBlockPos());
        }
    }
}

