/*
 * Decompiled with CFR 0.152.
 */
package com.thevortex.potionsmaster.render.util.xray;

import com.thevortex.potionsmaster.PotionsMaster;
import com.thevortex.potionsmaster.render.util.xray.Controller;
import com.thevortex.potionsmaster.render.util.xray.Render;
import com.thevortex.potionsmaster.render.util.xray.RenderEnqueue;
import java.util.Collection;
import net.minecraft.world.effect.MobEffectInstance;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.event.level.ChunkEvent;
import net.neoforged.neoforge.event.server.ServerStoppingEvent;

@EventBusSubscriber(modid="potionsmaster", value={Dist.CLIENT})
public class Events {
    protected static int counter;

    @SubscribeEvent
    public static void onExit(ServerStoppingEvent event) {
        if (Controller.drawOres()) {
            Controller.toggleDrawOres();
        }
        Controller.shutdownExecutor();
    }

    @SubscribeEvent
    public static void pickupItem(BlockEvent.BreakEvent event) {
        RenderEnqueue.checkBlock(event.getPos(), event.getState(), false);
    }

    @SubscribeEvent
    public static void placeItem(BlockEvent.EntityPlaceEvent event) {
        RenderEnqueue.checkBlock(event.getPos(), event.getState(), true);
    }

    @SubscribeEvent
    public static void chunkLoad(ChunkEvent.Load event) {
        Controller.requestBlockFinder(true);
    }

    @SubscribeEvent
    public static void tickEnd(ClientTickEvent.Post event) {
        if (++counter > 40 && Controller.drawOres()) {
            counter = 0;
            Controller.requestBlockFinder(false);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void onWorldRenderLast(RenderLevelStageEvent event) {
        if (Controller.drawOres() && PotionsMaster.proxy.getMinecraft().player != null && event.getStage() == RenderLevelStageEvent.Stage.AFTER_PARTICLES && PotionsMaster.proxy.getMinecraft().player.getActiveEffects().stream().iterator().hasNext()) {
            boolean pmPot = false;
            Collection effects = PotionsMaster.proxy.getMinecraft().player.getActiveEffects();
            for (MobEffectInstance effect : effects) {
                if (!effect.getEffect().getRegisteredName().contains("potionsmaster")) continue;
                pmPot = true;
            }
            if (!pmPot) {
                Controller.toggleDrawOres();
                return;
            }
            try {
                Render.INSTANCE.drawOres(event);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

