/*
 * Decompiled with CFR 0.152.
 */
package com.anthonyhilyard.iceberg.component;

import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;

public interface IExtendedText {
    public void setAlignment(TextAlignment var1);

    public TextAlignment getAlignment();

    default public void setPadding(int padding) {
        this.setPadding(padding, padding, padding, padding);
    }

    default public void setPadding(int left, int right) {
        this.setPadding(left, right, 0, 0);
    }

    public void setPadding(int var1, int var2, int var3, int var4);

    public int getLeftPadding();

    public int getRightPadding();

    public int getTopPadding();

    public int getBottomPadding();

    public static class ExtendedTextDataStore {
        private static final Map<Object, TextAlignment> alignmentMap = Collections.synchronizedMap(new WeakHashMap());
        private static final Map<Object, Integer> leftPaddingMap = Collections.synchronizedMap(new WeakHashMap());
        private static final Map<Object, Integer> rightPaddingMap = Collections.synchronizedMap(new WeakHashMap());

        public static void setAlignment(Object key, TextAlignment alignment) {
            alignmentMap.put(key, alignment);
        }

        public static TextAlignment get(Object key) {
            return alignmentMap.getOrDefault(key, TextAlignment.LEFT);
        }

        public static void setPadding(Object key, int left, int right) {
            leftPaddingMap.put(key, left);
            rightPaddingMap.put(key, right);
        }

        public static int getLeftPadding(Object key) {
            return leftPaddingMap.getOrDefault(key, 0);
        }

        public static int getRightPadding(Object key) {
            return rightPaddingMap.getOrDefault(key, 0);
        }
    }

    public static enum TextAlignment {
        LEFT,
        CENTER,
        RIGHT;

    }
}

