/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.action.actions.file;

import de.keksuccino.fancymenu.customization.action.Action;
import de.keksuccino.fancymenu.customization.action.ActionInstance;
import de.keksuccino.fancymenu.customization.listener.listeners.Listeners;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.fancymenu.util.file.DotMinecraftUtils;
import de.keksuccino.fancymenu.util.file.GameDirectoryUtils;
import de.keksuccino.fancymenu.util.rendering.ui.screen.DualTextInputScreen;
import de.keksuccino.fancymenu.util.threading.MainThreadTaskExecutor;
import java.io.File;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DownloadFileAction
extends Action {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final int BUFFER_SIZE = 8192;

    public DownloadFileAction() {
        super("download_file_to_game_dir");
    }

    @Override
    public boolean hasValue() {
        return true;
    }

    @Override
    public void execute(@Nullable String value) {
        if (value != null && value.contains("||")) {
            String[] valueArray = value.split("\\|\\|", 2);
            String fileUrl = valueArray[0];
            String targetDirectoryPath = valueArray[1];
            CompletableFuture.runAsync(() -> {
                String resolvedDirectoryPath = null;
                try {
                    resolvedDirectoryPath = this.resolveActionDirectoryPath(targetDirectoryPath);
                    String finalTargetPath = this.downloadFile(fileUrl, resolvedDirectoryPath);
                    MainThreadTaskExecutor.executeInMainThread(() -> Listeners.ON_FILE_DOWNLOADED.onFileDownloaded(fileUrl, finalTargetPath, true), MainThreadTaskExecutor.ExecuteTiming.POST_CLIENT_TICK);
                }
                catch (Exception ex) {
                    String failurePath;
                    LOGGER.error("[FANCYMENU] Failed to download file via DownloadFileAction: " + value, (Throwable)ex);
                    String finalFailurePath = failurePath = resolvedDirectoryPath != null ? resolvedDirectoryPath : targetDirectoryPath;
                    MainThreadTaskExecutor.executeInMainThread(() -> Listeners.ON_FILE_DOWNLOADED.onFileDownloaded(fileUrl, finalFailurePath, false), MainThreadTaskExecutor.ExecuteTiming.POST_CLIENT_TICK);
                }
            });
        }
    }

    /*
     * Exception decompiling
     */
    @NotNull
    private String downloadFile(@NotNull String fileUrl, @NotNull String resolvedTargetDirectory) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @NotNull
    private String resolveActionDirectoryPath(@NotNull String path) throws IOException {
        File directory;
        String resolvedPath = DotMinecraftUtils.resolveMinecraftPath(path);
        if (!DotMinecraftUtils.isInsideMinecraftDirectory(resolvedPath)) {
            resolvedPath = GameDirectoryUtils.getAbsoluteGameDirectoryPath(resolvedPath);
        }
        if ((directory = new File(resolvedPath)).exists()) {
            if (!directory.isDirectory()) {
                throw new IllegalArgumentException("Target path must be a directory: " + resolvedPath);
            }
        } else {
            Files.createDirectories(directory.toPath(), new FileAttribute[0]);
        }
        return directory.getAbsolutePath();
    }

    @NotNull
    private File buildTargetFile(@NotNull String directoryPath, @NotNull String fileName) throws IOException {
        File directory = new File(directoryPath);
        File targetFile = new File(directory, fileName);
        Path canonicalDirectory = directory.getCanonicalFile().toPath();
        Path canonicalFile = targetFile.getCanonicalFile().toPath();
        if (!canonicalFile.startsWith(canonicalDirectory)) {
            throw new SecurityException("Resolved file path escapes target directory: " + String.valueOf(canonicalFile));
        }
        return targetFile;
    }

    @NotNull
    private String resolveFileName(@NotNull HttpURLConnection connection, @NotNull URL url) {
        Object fileName = this.extractFileNameFromContentDisposition(connection.getHeaderField("Content-Disposition"));
        if (fileName == null || ((String)fileName).isEmpty()) {
            fileName = this.extractFileNameFromUrl(url);
        }
        if (((String)(fileName = this.sanitizeFileName((String)fileName))).isEmpty()) {
            fileName = "download_" + System.currentTimeMillis();
        }
        return fileName;
    }

    @Nullable
    private String extractFileNameFromContentDisposition(@Nullable String contentDisposition) {
        String[] segments;
        if (contentDisposition == null || contentDisposition.isEmpty()) {
            return null;
        }
        for (String segment : segments = contentDisposition.split(";")) {
            String trimmed = segment.trim();
            if (trimmed.toLowerCase(Locale.ROOT).startsWith("filename*=")) {
                String value = trimmed.substring("filename*=".length());
                int charsetSeparator = value.indexOf("''");
                if (charsetSeparator >= 0) {
                    value = value.substring(charsetSeparator + 2);
                }
                return this.decodeFileName(value);
            }
            if (!trimmed.toLowerCase(Locale.ROOT).startsWith("filename=")) continue;
            String value = trimmed.substring("filename=".length());
            return this.decodeFileName(value);
        }
        return null;
    }

    @Nullable
    private String extractFileNameFromUrl(@NotNull URL url) {
        String path = url.getPath();
        if (path == null || path.isEmpty() || path.endsWith("/")) {
            return null;
        }
        try {
            Path urlPath = Paths.get(path, new String[0]);
            Path fileName = urlPath.getFileName();
            if (fileName != null) {
                return fileName.toString();
            }
        }
        catch (InvalidPathException urlPath) {
            // empty catch block
        }
        int lastSlash = path.lastIndexOf(47) + 1;
        if (lastSlash >= 0 && lastSlash < path.length()) {
            return path.substring(lastSlash);
        }
        return null;
    }

    @NotNull
    private String sanitizeFileName(@Nullable String fileName) {
        int lastSlash;
        if (fileName == null) {
            return "";
        }
        String sanitized = fileName.trim();
        if (sanitized.startsWith("\"") && sanitized.endsWith("\"") && sanitized.length() >= 2) {
            sanitized = sanitized.substring(1, sanitized.length() - 1);
        }
        if ((lastSlash = (sanitized = sanitized.replace("\\", "/")).lastIndexOf(47) + 1) >= 0 && lastSlash < sanitized.length()) {
            sanitized = sanitized.substring(lastSlash);
        }
        sanitized = sanitized.replaceAll("[\\r\\n]", "");
        sanitized = sanitized.replaceAll("[<>:\\|?*]", "_");
        if ((sanitized = sanitized.trim()).isEmpty()) {
            return "";
        }
        try {
            return Paths.get(sanitized, new String[0]).getFileName().toString();
        }
        catch (InvalidPathException ignored) {
            return sanitized;
        }
    }

    @NotNull
    private String decodeFileName(@NotNull String value) {
        String trimmed = value.trim();
        if (trimmed.startsWith("\"") && trimmed.endsWith("\"")) {
            trimmed = trimmed.substring(1, trimmed.length() - 1);
        }
        try {
            return URLDecoder.decode(trimmed, StandardCharsets.UTF_8);
        }
        catch (IllegalArgumentException ignored) {
            return trimmed;
        }
    }

    @Override
    @NotNull
    public Component getActionDisplayName() {
        return Component.translatable((String)"fancymenu.actions.download_file");
    }

    @Override
    @NotNull
    public Component[] getActionDescription() {
        return LocalizationUtils.splitLocalizedLines("fancymenu.actions.download_file.desc", new String[0]);
    }

    @Override
    public Component getValueDisplayName() {
        return Component.empty();
    }

    @Override
    public String getValueExample() {
        return "https://example.com/file.txt||/config/downloads";
    }

    @Override
    public void editValue(@NotNull Screen parentScreen, @NotNull ActionInstance instance) {
        DualTextInputScreen s = DualTextInputScreen.build(this.getActionDisplayName(), (Component)Component.translatable((String)"fancymenu.actions.download_file.value.url"), (Component)Component.translatable((String)"fancymenu.actions.download_file.value.target_path"), null, callback -> {
            if (callback != null) {
                instance.value = (String)callback.getKey() + "||" + (String)callback.getValue();
            }
            Minecraft.getInstance().setScreen(parentScreen);
        });
        String val = instance.value;
        if (val != null && val.contains("||")) {
            String[] array = val.split("\\|\\|", 2);
            s.setFirstText(array[0]);
            s.setSecondText(array[1]);
        }
        Minecraft.getInstance().setScreen((Screen)s);
    }
}

