/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.listener.listeners;

import de.keksuccino.fancymenu.customization.listener.AbstractListener;
import de.keksuccino.fancymenu.events.screen.ScreenMouseMoveEvent;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.fancymenu.util.event.acara.EventHandler;
import de.keksuccino.fancymenu.util.event.acara.EventListener;
import java.util.List;
import net.minecraft.network.chat.Component;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OnMouseMovedListener
extends AbstractListener {
    private static final Logger LOGGER = LogManager.getLogger();
    @Nullable
    private Double lastMouseX;
    @Nullable
    private Double lastMouseY;
    @Nullable
    private Double lastDeltaX;
    @Nullable
    private Double lastDeltaY;

    public OnMouseMovedListener() {
        super("mouse_moved");
        EventHandler.INSTANCE.registerListenersOf(this);
    }

    @EventListener
    public void onMouseMoved(@NotNull ScreenMouseMoveEvent event) {
        this.lastMouseX = event.getMouseX();
        this.lastMouseY = event.getMouseY();
        this.lastDeltaX = event.getDeltaX();
        this.lastDeltaY = event.getDeltaY();
        this.notifyAllInstances();
    }

    @Override
    protected void buildCustomVariablesAndAddToList(List<AbstractListener.CustomVariable> list) {
        list.add(new AbstractListener.CustomVariable("mouse_pos_x", () -> this.formatValue(this.lastMouseX)));
        list.add(new AbstractListener.CustomVariable("mouse_pos_y", () -> this.formatValue(this.lastMouseY)));
        list.add(new AbstractListener.CustomVariable("mouse_move_delta_x", () -> this.formatValue(this.lastDeltaX)));
        list.add(new AbstractListener.CustomVariable("mouse_move_delta_y", () -> this.formatValue(this.lastDeltaY)));
    }

    private String formatValue(@Nullable Double value) {
        if (value == null) {
            return "ERROR";
        }
        return Double.toString(value);
    }

    @Override
    @NotNull
    public Component getDisplayName() {
        return Component.translatable((String)"fancymenu.listeners.on_mouse_moved");
    }

    @Override
    @NotNull
    public List<Component> getDescription() {
        return List.of(LocalizationUtils.splitLocalizedLines("fancymenu.listeners.on_mouse_moved.desc", new String[0]));
    }
}

