/*
 * Decompiled with CFR 0.152.
 */
package mc.euphoria_patches.euphoria_patcher.util;

import java.io.File;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import mc.euphoria_patches.euphoria_patcher.EuphoriaPatcher;
import mc.euphoria_patches.euphoria_patcher.util.EuphoriaLogger;

public class ShaderLoader {
    public static final String IRIS = "iris";
    public static final String OCULUS = "oculus";
    public static final String OPTIFINE = "optifine";
    public static final String ANGELICA = "angelica";
    public static final String UNKNOWN = "unknown";
    private static final Pattern VERSION_PATTERN = Pattern.compile("1\\.(\\d+)\\.(\\d+)");
    private static File cachedShaderFile = null;
    private static boolean shaderFileSearched = false;
    private static String cachedShaderLoader = null;
    private static String cachedMCVersion = null;
    private static Integer cachedShaderLoaderVersion = null;

    private static void debugLog(String message) {
        EuphoriaLogger.debugLog("[ShaderLoader] " + message);
    }

    private static File findShaderLoaderFile() {
        if (shaderFileSearched) {
            ShaderLoader.debugLog("Using cached shader file result: " + (cachedShaderFile != null ? cachedShaderFile.getName() : "null"));
            return cachedShaderFile;
        }
        ShaderLoader.debugLog("Searching for shader loader file in mods directory");
        try {
            File modsFolder = new File(String.valueOf(EuphoriaPatcher.modDirectory));
            File[] modFiles = modsFolder.listFiles((dir, name) -> name.toLowerCase(Locale.ROOT).endsWith(".jar"));
            if (modFiles != null) {
                ShaderLoader.debugLog("Found " + modFiles.length + " JAR files in mods directory");
                for (File modFile : modFiles) {
                    String fileName = modFile.getName().toLowerCase(Locale.ROOT);
                    ShaderLoader.debugLog("Checking file: " + fileName);
                    if (fileName.contains("compat") || fileName.contains("addon") || fileName.contains("compatibility") || fileName.contains("flywheel")) {
                        ShaderLoader.debugLog("Skipping compatibility/addon mod: " + fileName);
                        continue;
                    }
                    if ((!fileName.startsWith(IRIS) || !fileName.contains("fabric") && !fileName.contains("neoforge") && !fileName.contains("+mc")) && !fileName.startsWith("oculus-mc") && !fileName.startsWith("mekalus-mc") && !fileName.startsWith("optifine_") && !fileName.startsWith(ANGELICA)) continue;
                    cachedShaderFile = modFile;
                    shaderFileSearched = true;
                    ShaderLoader.debugLog("Found shader loader file: " + modFile.getName());
                    return cachedShaderFile;
                }
            }
            ShaderLoader.debugLog("No shader loader file found");
            shaderFileSearched = true;
            return null;
        }
        catch (Exception e) {
            EuphoriaPatcher.log(2, 0, "Error finding shader loader: " + e.getMessage());
            ShaderLoader.debugLog("Exception while searching for shader loader: " + e.getMessage());
            shaderFileSearched = true;
            return null;
        }
    }

    public static String getShaderLoader() {
        if (cachedShaderLoader != null) {
            ShaderLoader.debugLog("Using cached shader loader type: " + cachedShaderLoader);
            return cachedShaderLoader;
        }
        ShaderLoader.debugLog("Determining shader loader type");
        File shaderFile = ShaderLoader.findShaderLoaderFile();
        if (shaderFile == null) {
            ShaderLoader.debugLog("No shader file found, returning UNKNOWN");
            EuphoriaPatcher.log(2, 0, "No shader loader mod was found");
            cachedShaderLoader = UNKNOWN;
            return cachedShaderLoader;
        }
        String fileName = shaderFile.getName().toLowerCase(Locale.ROOT);
        ShaderLoader.debugLog("Analyzing file name: " + fileName);
        if (fileName.startsWith(IRIS)) {
            ShaderLoader.debugLog("Detected IRIS shader loader");
            cachedShaderLoader = IRIS;
        } else if (fileName.startsWith(OCULUS) || fileName.startsWith("mekalus")) {
            ShaderLoader.debugLog("Detected OCULUS shader loader" + (fileName.startsWith("mekalus") ? " (Mekalus fork)" : ""));
            cachedShaderLoader = OCULUS;
        } else if (fileName.startsWith(OPTIFINE)) {
            ShaderLoader.debugLog("Detected OPTIFINE shader loader");
            cachedShaderLoader = OPTIFINE;
        } else if (fileName.startsWith(ANGELICA)) {
            ShaderLoader.debugLog("Detected ANGELICA shader loader");
            cachedShaderLoader = ANGELICA;
        } else {
            ShaderLoader.debugLog("Could not determine shader loader type, returning UNKNOWN");
            cachedShaderLoader = UNKNOWN;
        }
        return cachedShaderLoader;
    }

    public static String getShaderLoaderMCVersion() {
        if (cachedMCVersion != null) {
            ShaderLoader.debugLog("Using cached MC version: " + cachedMCVersion);
            return cachedMCVersion;
        }
        ShaderLoader.debugLog("Extracting Minecraft version from shader loader filename");
        try {
            File shaderFile = ShaderLoader.findShaderLoaderFile();
            if (shaderFile == null) {
                ShaderLoader.debugLog("No shader file found, returning UNKNOWN version");
                cachedMCVersion = UNKNOWN;
                return cachedMCVersion;
            }
            String fileName = shaderFile.getName();
            String lowerFileName = fileName.toLowerCase(Locale.ROOT);
            String extractedVersion = null;
            ShaderLoader.debugLog("Parsing version from filename: " + fileName);
            if (lowerFileName.startsWith(ANGELICA)) {
                ShaderLoader.debugLog("Detected Angelica format - always for Minecraft 1.7.10");
                extractedVersion = "1.7.10";
                ShaderLoader.debugLog("Set version to 1.7.10 for Angelica");
            } else if (lowerFileName.startsWith("optifine_")) {
                ShaderLoader.debugLog("Detected OptiFine format");
                String[] parts = fileName.split("_");
                if (parts.length >= 2) {
                    extractedVersion = parts[1];
                    ShaderLoader.debugLog("Extracted version: " + extractedVersion);
                }
            } else if (lowerFileName.startsWith(IRIS)) {
                String versionPart;
                int endIndex;
                ShaderLoader.debugLog("Detected Iris format");
                int mcIndex = lowerFileName.indexOf("+mc");
                if (mcIndex != -1 && (endIndex = (versionPart = lowerFileName.substring(mcIndex + 3)).indexOf(".jar")) != -1) {
                    extractedVersion = versionPart.substring(0, endIndex);
                    ShaderLoader.debugLog("Extracted version: " + extractedVersion);
                }
            } else if (lowerFileName.startsWith(OCULUS) || lowerFileName.startsWith("mekalus")) {
                String afterMc;
                int dashIndex;
                ShaderLoader.debugLog("Detected " + (lowerFileName.startsWith("mekalus") ? "Mekalus" : "Oculus") + " format");
                int mcIndex = lowerFileName.indexOf("-mc");
                if (mcIndex != -1 && (dashIndex = (afterMc = lowerFileName.substring(mcIndex + 3)).indexOf("-")) != -1) {
                    extractedVersion = afterMc.substring(0, dashIndex);
                    ShaderLoader.debugLog("Extracted version: " + extractedVersion);
                }
            }
            if (extractedVersion != null) {
                Matcher matcher = VERSION_PATTERN.matcher(extractedVersion);
                if (matcher.matches()) {
                    ShaderLoader.debugLog("Valid version format: " + extractedVersion);
                    cachedMCVersion = extractedVersion;
                    return cachedMCVersion;
                }
                ShaderLoader.debugLog("Invalid version format: " + extractedVersion);
                EuphoriaPatcher.log(1, 0, "Invalid version format detected: " + extractedVersion);
            } else {
                ShaderLoader.debugLog("Could not extract version from filename");
            }
            ShaderLoader.debugLog("Setting version to UNKNOWN");
            cachedMCVersion = UNKNOWN;
            return cachedMCVersion;
        }
        catch (Exception e) {
            EuphoriaPatcher.log(2, 0, "Error extracting Minecraft version: " + e.getMessage());
            ShaderLoader.debugLog("Exception extracting Minecraft version: " + e.getMessage());
            cachedMCVersion = UNKNOWN;
            return cachedMCVersion;
        }
    }

    public static boolean isVersionGreaterOrEqual(String version, String minVersion) {
        if (version == null || minVersion == null || UNKNOWN.equals(version) || UNKNOWN.equals(minVersion)) {
            return false;
        }
        try {
            int versionInt = ShaderLoader.convertVersionToInt(version);
            int minVersionInt = ShaderLoader.convertVersionToInt(minVersion);
            return versionInt >= minVersionInt;
        }
        catch (Exception e) {
            EuphoriaPatcher.log(1, 0, "Error comparing versions: " + e.getMessage());
            return false;
        }
    }

    private static int convertVersionToInt(String versionString) {
        Matcher matcher = VERSION_PATTERN.matcher(versionString);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Invalid version format: " + versionString);
        }
        int minor = Integer.parseInt(matcher.group(1));
        int release = Integer.parseInt(matcher.group(2));
        return 10000 + minor * 100 + release;
    }

    public static boolean isMinecraftVersionAtLeast(String minVersion) {
        String currentVersion = ShaderLoader.getShaderLoaderMCVersion();
        return ShaderLoader.isVersionGreaterOrEqual(currentVersion, minVersion);
    }

    public static int getShaderLoaderVersion() {
        if (cachedShaderLoaderVersion != null) {
            ShaderLoader.debugLog("Using cached shader loader version: " + cachedShaderLoaderVersion);
            return cachedShaderLoaderVersion;
        }
        ShaderLoader.debugLog("Extracting shader loader version from filename");
        try {
            File shaderFile = ShaderLoader.findShaderLoaderFile();
            if (shaderFile == null) {
                ShaderLoader.debugLog("No shader file found, returning 0");
                cachedShaderLoaderVersion = 0;
                return cachedShaderLoaderVersion;
            }
            String fileName = shaderFile.getName();
            String lowerFileName = fileName.toLowerCase(Locale.ROOT);
            Object extractedVersion = null;
            ShaderLoader.debugLog("Parsing shader loader version from filename: " + fileName);
            if (lowerFileName.startsWith(IRIS)) {
                ShaderLoader.debugLog("Detected Iris format");
                int fabricIndex = lowerFileName.indexOf("-fabric-");
                int mcIndex = lowerFileName.indexOf("+mc");
                if (fabricIndex != -1 && mcIndex != -1 && mcIndex > fabricIndex) {
                    extractedVersion = fileName.substring(fabricIndex + 8, mcIndex);
                    ShaderLoader.debugLog("Extracted Iris version: " + (String)extractedVersion);
                }
            } else if (lowerFileName.startsWith(OCULUS) || lowerFileName.startsWith("mekalus")) {
                ShaderLoader.debugLog("Detected " + (lowerFileName.startsWith("mekalus") ? "Mekalus" : "Oculus") + " format");
                int lastDashIndex = fileName.lastIndexOf(45);
                int jarIndex = lowerFileName.indexOf(".jar");
                if (lastDashIndex != -1 && jarIndex != -1 && jarIndex > lastDashIndex) {
                    String fullVersion = fileName.substring(lastDashIndex + 1, jarIndex);
                    if (lowerFileName.startsWith("mekalus") && fullVersion.matches("\\d+\\.\\d+\\.\\d+\\.\\d+")) {
                        String[] parts = fullVersion.split("\\.");
                        if (parts.length >= 3) {
                            extractedVersion = parts[0] + "." + parts[1] + "." + parts[2];
                            ShaderLoader.debugLog("Simplified Mekalus version from " + fullVersion + " to " + (String)extractedVersion);
                        }
                    } else {
                        extractedVersion = fullVersion;
                    }
                    ShaderLoader.debugLog("Extracted version: " + (String)extractedVersion);
                }
            } else if (lowerFileName.startsWith(ANGELICA)) {
                ShaderLoader.debugLog("Detected Angelica format");
                int angelicaIndex = lowerFileName.indexOf("angelica-");
                int betaIndex = lowerFileName.indexOf("-beta");
                if (angelicaIndex != -1 && betaIndex != -1 && betaIndex > angelicaIndex) {
                    extractedVersion = fileName.substring(angelicaIndex + 9, betaIndex);
                    ShaderLoader.debugLog("Extracted Angelica version: " + (String)extractedVersion);
                }
            } else if (lowerFileName.startsWith(OPTIFINE)) {
                ShaderLoader.debugLog("Detected OptiFine - returning 0 as requested");
                cachedShaderLoaderVersion = 0;
                return cachedShaderLoaderVersion;
            }
            if (extractedVersion != null) {
                int versionInt = ShaderLoader.convertVersionToInt(extractedVersion);
                ShaderLoader.debugLog("Converted shader loader version to integer: " + versionInt);
                cachedShaderLoaderVersion = versionInt;
                return cachedShaderLoaderVersion;
            }
            ShaderLoader.debugLog("Could not extract shader loader version from filename");
            ShaderLoader.debugLog("Setting shader loader version to 0");
            cachedShaderLoaderVersion = 0;
            return cachedShaderLoaderVersion;
        }
        catch (Exception e) {
            EuphoriaPatcher.log(2, 0, "Error extracting shader loader version: " + e.getMessage());
            ShaderLoader.debugLog("Exception extracting shader loader version: " + e.getMessage());
            cachedShaderLoaderVersion = 0;
            return cachedShaderLoaderVersion;
        }
    }

    public static String getShaderLoaderVersionString() {
        int version = ShaderLoader.getShaderLoaderVersion();
        String shaderLoader = ShaderLoader.getShaderLoader();
        Object returnString = "// Shader Loader Version Placeholder";
        switch (shaderLoader) {
            case "iris": {
                returnString = "#define EUPHORIA_PATCHES_IRIS_VERSION " + version;
                break;
            }
            case "oculus": {
                returnString = "#define EUPHORIA_PATCHES_OCULUS_VERSION " + version;
                break;
            }
            case "angelica": {
                returnString = "#define EUPHORIA_PATCHES_ANGELICA_VERSION " + version;
            }
        }
        return returnString;
    }
}

