/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.openloader.common.impl.packs;

import java.io.File;
import java.nio.file.InvalidPathException;
import java.nio.file.Paths;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import net.darkhax.openloader.common.impl.OpenLoader;
import net.darkhax.openloader.common.impl.Platform;
import net.darkhax.openloader.common.impl.packs.PackContentType;
import net.darkhax.openloader.common.impl.packs.PackFileType;
import net.minecraft.network.chat.Component;
import net.minecraft.server.packs.PackLocationInfo;
import net.minecraft.server.packs.PackSelectionConfig;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.server.packs.repository.RepositorySource;
import org.jetbrains.annotations.NotNull;

public class OpenLoaderRepositorySource
implements RepositorySource {
    private static final PackSource SOURCE = PackSource.create(packText -> packText, (boolean)true);
    private final PackType type;
    private final List<File> scanLocations = new LinkedList<File>();

    public OpenLoaderRepositorySource(PackType type) {
        this.type = type;
        if (OpenLoader.CONFIG.get().canLoad(type)) {
            File datapacksDir;
            File packFolder = new File(Platform.PLATFORM.getConfigDirectory(), "openloader/packs");
            if (packFolder.mkdirs()) {
                OpenLoader.LOG.info("Created packs folder a '{}'", (Object)packFolder.getAbsolutePath());
            }
            if ((datapacksDir = new File(Platform.PLATFORM.getGameDirectory(), "datapacks")).exists() && OpenLoader.CONFIG.get().load_datapacks_dir) {
                this.scanLocations.add(datapacksDir);
            }
            this.scanLocations.add(packFolder);
            for (String location : OpenLoader.CONFIG.get().additional_locations) {
                if (OpenLoaderRepositorySource.isValidPath(location)) {
                    File file = new File(location);
                    if (file.exists()) {
                        this.scanLocations.add(file);
                        continue;
                    }
                    OpenLoader.LOG.warn("The configured path does not currently exist! '{}'", (Object)location);
                    continue;
                }
                OpenLoader.LOG.error("Invalid path specified in config folder! '{}'", (Object)location);
            }
        }
    }

    public void loadPacks(@NotNull Consumer<Pack> consumer) {
        if (!this.scanLocations.isEmpty()) {
            OpenLoader.LOG.info("Scan started for {}.", (Object)this.type.name());
            long startTime = System.nanoTime();
            int validPackCount = 0;
            for (File location : this.scanLocations) {
                validPackCount += this.loadFrom(location, consumer);
            }
            long endTime = System.nanoTime();
            OpenLoader.LOG.info("Located {} packs. Took {}ms.", (Object)validPackCount, (Object)OpenLoader.DECIMAL_2.format((double)(endTime - startTime) / 1000000.0));
        }
    }

    private int loadFrom(File location, @NotNull Consumer<Pack> consumer) {
        PackFileType type = PackFileType.from(location);
        if (!type.isLoadable()) {
            if (location.isDirectory() && location.exists()) {
                int validPackCount = 0;
                for (File subLocation : Objects.requireNonNull(location.listFiles())) {
                    if (OpenLoader.INVALID_FOLDERS.contains(subLocation.getName())) continue;
                    validPackCount += this.loadFrom(subLocation, consumer);
                }
                return validPackCount;
            }
            return 0;
        }
        PackContentType contentType = PackContentType.from(location.toPath());
        if (contentType.isFor(this.type)) {
            PackLocationInfo locationInfo = new PackLocationInfo("openloader/" + location.getAbsolutePath(), (Component)Component.literal((String)location.getName()), SOURCE, Optional.empty());
            PackSelectionConfig selectionConfig = new PackSelectionConfig(true, Pack.Position.TOP, false);
            consumer.accept(Pack.readMetaAndCreate((PackLocationInfo)locationInfo, (Pack.ResourcesSupplier)type.createPackSupplier(location), (PackType)this.type, (PackSelectionConfig)selectionConfig));
            return 1;
        }
        return 0;
    }

    private static boolean isValidPath(String path) {
        try {
            Paths.get(path, new String[0]);
        }
        catch (NullPointerException | InvalidPathException ex) {
            return false;
        }
        return true;
    }
}

