/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.openloader.common.impl.packs;

import java.io.File;
import java.util.Locale;
import java.util.function.Function;
import net.minecraft.server.packs.FilePackResources;
import net.minecraft.server.packs.PathPackResources;
import net.minecraft.server.packs.repository.Pack;

public enum PackFileType {
    ARCHIVE(true, FilePackResources.FileResourcesSupplier::new),
    FOLDER(true, file -> new PathPackResources.PathResourcesSupplier(file.toPath())),
    INVALID(false, file -> null);

    private final boolean loadable;
    private final Function<File, Pack.ResourcesSupplier> packSupplier;

    private PackFileType(boolean loadable, Function<File, Pack.ResourcesSupplier> packSupplier) {
        this.loadable = loadable;
        this.packSupplier = packSupplier;
    }

    public boolean isLoadable() {
        return this.loadable;
    }

    public String typeName() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    public Pack.ResourcesSupplier createPackSupplier(File packFile) {
        return this.packSupplier.apply(packFile);
    }

    public static PackFileType from(File candidate) {
        if (candidate.isFile() && (PackFileType.endsWithIgnoreCase(candidate.getName(), ".zip") || PackFileType.endsWithIgnoreCase(candidate.getName(), ".jar"))) {
            return ARCHIVE;
        }
        if (candidate.isDirectory() && new File(candidate, "pack.mcmeta").isFile()) {
            return FOLDER;
        }
        return INVALID;
    }

    private static boolean endsWithIgnoreCase(String str, String suffix) {
        int suffixLength = suffix.length();
        return str.regionMatches(true, str.length() - suffixLength, suffix, 0, suffixLength);
    }
}

