/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.features;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Codec;
import com.telepathicgrunt.repurposedstructures.world.features.configs.StructureTargetAndRangeConfig;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;

public class StructureFlowers
extends Feature<StructureTargetAndRangeConfig> {
    private static final List<BlockState> FLOWERS = ImmutableList.of((Object)Blocks.LILY_OF_THE_VALLEY.defaultBlockState(), (Object)Blocks.POPPY.defaultBlockState(), (Object)Blocks.DANDELION.defaultBlockState(), (Object)Blocks.CORNFLOWER.defaultBlockState(), (Object)Blocks.ORANGE_TULIP.defaultBlockState(), (Object)Blocks.PINK_TULIP.defaultBlockState(), (Object)Blocks.RED_TULIP.defaultBlockState(), (Object)Blocks.WHITE_TULIP.defaultBlockState(), (Object)Blocks.ROSE_BUSH.defaultBlockState(), (Object)Blocks.LILAC.defaultBlockState(), (Object)Blocks.PEONY.defaultBlockState());

    public StructureFlowers(Codec<StructureTargetAndRangeConfig> config) {
        super(config);
    }

    public boolean place(FeaturePlaceContext<StructureTargetAndRangeConfig> context) {
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        for (int i = 0; i < ((StructureTargetAndRangeConfig)context.config()).attempts; ++i) {
            BlockState chosenFlower;
            mutable.set((Vec3i)context.origin()).move(context.random().nextInt(((StructureTargetAndRangeConfig)context.config()).range * 2 + 1) - ((StructureTargetAndRangeConfig)context.config()).range, context.random().nextInt(3) - 1, context.random().nextInt(((StructureTargetAndRangeConfig)context.config()).range * 2 + 1) - ((StructureTargetAndRangeConfig)context.config()).range);
            if (!context.level().getBlockState((BlockPos)mutable).isAir() || !(chosenFlower = FLOWERS.get(context.random().nextInt(FLOWERS.size()))).canSurvive((LevelReader)context.level(), (BlockPos)mutable)) continue;
            if (chosenFlower.getBlock() instanceof DoublePlantBlock && context.level().getBlockState(mutable.above()).isAir()) {
                context.level().setBlock((BlockPos)mutable, (BlockState)chosenFlower.setValue((Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.LOWER), 3);
                context.level().setBlock((BlockPos)mutable.move(Direction.UP), (BlockState)chosenFlower.setValue((Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.UPPER), 3);
                continue;
            }
            context.level().setBlock((BlockPos)mutable, chosenFlower, 3);
        }
        return true;
    }
}

