/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.features;

import com.google.common.primitives.Doubles;
import com.mojang.serialization.Codec;
import com.telepathicgrunt.repurposedstructures.utils.OpenSimplex2F;
import com.telepathicgrunt.repurposedstructures.world.features.configs.StructureRangeConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;

public class StructurePowderSnow
extends Feature<StructureRangeConfig> {
    protected long seed;
    private OpenSimplex2F noiseGenerator = null;

    public StructurePowderSnow(Codec<StructureRangeConfig> config) {
        super(config);
    }

    public void setSeed(long seed) {
        if (this.seed != seed || this.noiseGenerator == null) {
            this.noiseGenerator = new OpenSimplex2F(seed);
            this.seed = seed;
        }
    }

    public boolean place(FeaturePlaceContext<StructureRangeConfig> context) {
        this.setSeed(context.level().getSeed());
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        int range = ((StructureRangeConfig)context.config()).range;
        double thresholds = (double)range / 9.0;
        for (int x = -range; x <= range; ++x) {
            for (int z = -range; z <= range; ++z) {
                BlockState belowState;
                BlockState currentState;
                boolean isSnowLayer;
                mutable.set((Vec3i)context.origin()).move(x, -1, z);
                double noiseManip = this.noiseGenerator.noise3_Classic((double)mutable.getX() / 8.0, 0.0, (double)mutable.getZ() / 8.0);
                double distance = Math.sqrt(x * x + z * z) + noiseManip;
                if (!(distance < (double)range - 0.1)) continue;
                for (int i = 0; i < 2; ++i) {
                    mutable.move(Direction.DOWN);
                    BlockState belowState2 = context.level().getBlockState((BlockPos)mutable);
                    if (!belowState2.canOcclude() || belowState2.is(Blocks.SNOW)) continue;
                    mutable.move(Direction.UP);
                    break;
                }
                if (!(isSnowLayer = (currentState = context.level().getBlockState((BlockPos)mutable)).is(Blocks.SNOW)) && !currentState.isAir() && !currentState.is(Blocks.SNOW_BLOCK)) continue;
                int stage = (int)Doubles.constrainToRange((double)(9.0 - distance / thresholds), (double)0.0, (double)9.0);
                if (isSnowLayer) {
                    int originalSnowLayer = (Integer)currentState.getValue((Property)SnowLayerBlock.LAYERS);
                    stage = Math.max(stage, originalSnowLayer);
                } else if (currentState.is(Blocks.SNOW_BLOCK)) {
                    stage = 9;
                } else if (currentState.is(Blocks.POWDER_SNOW)) {
                    stage = 9;
                }
                BlockState chosenBlock = stage == 9 ? Blocks.POWDER_SNOW.defaultBlockState() : (stage == 8 ? Blocks.SNOW_BLOCK.defaultBlockState() : (BlockState)Blocks.SNOW.defaultBlockState().setValue((Property)SnowLayerBlock.LAYERS, (Comparable)Integer.valueOf((int)Doubles.constrainToRange((double)stage, (double)1.0, (double)8.0))));
                if (currentState.is(Blocks.SNOW) && !chosenBlock.canSurvive((LevelReader)context.level(), (BlockPos)mutable)) {
                    mutable.move(Direction.DOWN);
                    belowState = context.level().getBlockState((BlockPos)mutable);
                    if (belowState.is(Blocks.DIRT_PATH) || belowState.is(BlockTags.DIRT) || belowState.is(BlockTags.ICE) || belowState.is(Blocks.POWDER_SNOW)) {
                        context.level().setBlock((BlockPos)mutable, Blocks.SNOW_BLOCK.defaultBlockState(), 3);
                    }
                    mutable.move(Direction.UP);
                }
                if (Blocks.SNOW.defaultBlockState().canSurvive((LevelReader)context.level(), (BlockPos)mutable)) {
                    context.level().setBlock((BlockPos)mutable, chosenBlock, 3);
                }
                if (!currentState.is(Blocks.SNOW_BLOCK) && !currentState.is(Blocks.POWDER_SNOW)) continue;
                mutable.move(Direction.DOWN);
                belowState = context.level().getBlockState((BlockPos)mutable);
                if (!belowState.is(Blocks.DIRT_PATH) && !belowState.is(BlockTags.DIRT) && !belowState.is(BlockTags.ICE)) continue;
                context.level().setBlock((BlockPos)mutable, Blocks.POWDER_SNOW.defaultBlockState(), 3);
            }
        }
        return true;
    }
}

