/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.processors;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.telepathicgrunt.repurposedstructures.modinit.RSProcessors;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class CappedStructureSurfaceProcessor
extends StructureProcessor {
    public static final MapCodec<CappedStructureSurfaceProcessor> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)StructureProcessorType.SINGLE_CODEC.fieldOf("delegate").forGetter(cappedProcessor -> cappedProcessor.delegate), (App)Codec.BOOL.fieldOf("allow_void_sides").orElse((Object)false).forGetter(cappedProcessor -> cappedProcessor.allowVoidSides)).apply((Applicative)instance, CappedStructureSurfaceProcessor::new));
    private static final Pair<StructureTemplate.StructureBlockInfo, Integer> DEFAULT_AIR_BLOCK = Pair.of((Object)new StructureTemplate.StructureBlockInfo(BlockPos.ZERO, Blocks.AIR.defaultBlockState(), null), (Object)0);
    private static final Pair<StructureTemplate.StructureBlockInfo, Integer> DEFAULT_SOLID_BLOCK = Pair.of((Object)new StructureTemplate.StructureBlockInfo(BlockPos.ZERO, Blocks.STONE.defaultBlockState(), null), (Object)0);
    private final StructureProcessor delegate;
    private final boolean allowVoidSides;

    public CappedStructureSurfaceProcessor(StructureProcessor structureProcessor, boolean allowVoidSides) {
        this.delegate = structureProcessor;
        this.allowVoidSides = allowVoidSides;
    }

    public final List<StructureTemplate.StructureBlockInfo> finalizeProcessing(ServerLevelAccessor serverLevelAccessor, BlockPos nbtOriginPos, BlockPos chunkCenter, List<StructureTemplate.StructureBlockInfo> nbtOriginBlockInfo, List<StructureTemplate.StructureBlockInfo> worldOriginBlockInfo, StructurePlaceSettings structurePlaceSettings) {
        if (!worldOriginBlockInfo.isEmpty()) {
            if (nbtOriginBlockInfo.size() != worldOriginBlockInfo.size()) {
                int listSize = nbtOriginBlockInfo.size();
                Util.logAndPauseIfInIde((String)("Original block info list not in sync with processed list, skipping processing. Original size: " + listSize + ", Processed size: " + worldOriginBlockInfo.size()));
            } else {
                BoundingBox boundingBox = structurePlaceSettings.getBoundingBox() == null ? BoundingBox.infinite() : structurePlaceSettings.getBoundingBox();
                Object2ObjectArrayMap nbtPosToData = new Object2ObjectArrayMap();
                for (int index = 0; index < worldOriginBlockInfo.size(); ++index) {
                    StructureTemplate.StructureBlockInfo info = worldOriginBlockInfo.get(index);
                    if (!boundingBox.isInside((Vec3i)info.pos())) continue;
                    nbtPosToData.put(info.pos(), Pair.of((Object)info, (Object)index));
                }
                ArrayList shuffledPositionList = new ArrayList(nbtPosToData.keySet());
                Collections.shuffle(shuffledPositionList);
                for (BlockPos currentPosition : shuffledPositionList) {
                    StructureTemplate.StructureBlockInfo structureBlockInfo3;
                    Pair currentInfo = (Pair)nbtPosToData.get(currentPosition);
                    StructureTemplate.StructureBlockInfo structureBlockInfoOriginalNbtOrigin = nbtOriginBlockInfo.get((Integer)currentInfo.getSecond());
                    StructureTemplate.StructureBlockInfo structureBlockInfoWorld = worldOriginBlockInfo.get((Integer)currentInfo.getSecond());
                    if (structureBlockInfoWorld == null || structureBlockInfoWorld.state().isAir() || !structureBlockInfoWorld.state().getFluidState().isEmpty()) continue;
                    BlockPos belowPos = structureBlockInfoWorld.pos().below();
                    BlockPos abovePos = structureBlockInfoWorld.pos().above();
                    if (!this.allowVoidSides && belowPos.getY() < 0 || !this.allowVoidSides && (!nbtPosToData.containsKey(belowPos) || !nbtPosToData.containsKey(abovePos))) continue;
                    BlockState belowState = ((StructureTemplate.StructureBlockInfo)nbtPosToData.getOrDefault(belowPos, DEFAULT_SOLID_BLOCK).getFirst()).state();
                    BlockState aboveState = ((StructureTemplate.StructureBlockInfo)nbtPosToData.getOrDefault(abovePos, DEFAULT_AIR_BLOCK).getFirst()).state();
                    if (!belowState.canOcclude() || belowState.is(Blocks.JIGSAW) || aboveState.canOcclude() && !aboveState.is(Blocks.JIGSAW) || (structureBlockInfo3 = this.delegate.processBlock((LevelReader)serverLevelAccessor, structureBlockInfoOriginalNbtOrigin.pos(), structureBlockInfoWorld.pos(), structureBlockInfoOriginalNbtOrigin, structureBlockInfoWorld, structurePlaceSettings)) == null || structureBlockInfoWorld.equals((Object)structureBlockInfo3)) continue;
                    worldOriginBlockInfo.set((Integer)currentInfo.getSecond(), structureBlockInfo3);
                }
            }
        }
        return worldOriginBlockInfo;
    }

    protected StructureProcessorType<?> getType() {
        return RSProcessors.STRUCTURE_SURFACE_PROCESSOR.get();
    }
}

