/*
 * Decompiled with CFR 0.152.
 */
package wile.redstonepen.blocks;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.LeverBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import wile.redstonepen.libmc.Auxiliaries;

public class BasicButton {

    public static class BasicButtonBlock
    extends ButtonBlock {
        public final Config config;

        public BasicButtonBlock(Config conf, BlockBehaviour.Properties properties) {
            super(BlockSetType.SPRUCE, conf.active_time(), properties);
            this.config = conf;
        }

        @OnlyIn(value=Dist.CLIENT)
        public void appendHoverText(ItemStack stack, Item.TooltipContext ctx, List<Component> tooltip, TooltipFlag flag) {
            Auxiliaries.Tooltip.addInformation(stack, ctx, tooltip, flag, true);
        }

        public InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult brh) {
            if (((Boolean)state.getValue((Property)POWERED)).booleanValue()) {
                return InteractionResult.CONSUME;
            }
            world.setBlock(pos, (BlockState)state.setValue((Property)POWERED, (Comparable)Boolean.valueOf(true)), 3);
            this.press(state, world, pos, player);
            if (world.isClientSide) {
                BasicButtonBlock.makeParticle(state, (LevelAccessor)world, pos, 1.0f);
            }
            return InteractionResult.sidedSuccess((boolean)world.isClientSide);
        }

        protected void playSound(@Nullable Player player, LevelAccessor world, BlockPos pos, boolean on) {
            world.playSound(null, pos, SoundEvents.LEVER_CLICK, SoundSource.BLOCKS, 0.3f, on ? this.config.sound_pitch_powered() : this.config.sound_pitch_unpowered());
        }

        private static void makeParticle(BlockState state, LevelAccessor world, BlockPos pos, float f) {
            for (int i = 0; i < 3; ++i) {
                Vec3 vpos = Vec3.atCenterOf((Vec3i)pos).add(Vec3.atBottomCenterOf((Vec3i)((Direction)state.getValue((Property)FACING)).getOpposite().getNormal()).scale(0.1)).add(Vec3.atLowerCornerOf((Vec3i)LeverBlock.getConnectedDirection((BlockState)state).getOpposite().getNormal()).scale(0.4));
                world.addParticle((ParticleOptions)new DustParticleOptions(DustParticleOptions.REDSTONE_PARTICLE_COLOR, f), vpos.x(), vpos.y(), vpos.z(), 0.0, 0.0, 0.0);
            }
        }

        public record Config(float sound_pitch_unpowered, float sound_pitch_powered, int active_time) {
        }
    }
}

