/*
 * Decompiled with CFR 0.152.
 */
package alexthw.not_enough_glyphs.api.spell_style;

import alexthw.not_enough_glyphs.init.ArsNouveauRegistry;
import com.hollingsworth.arsnouveau.api.particle.PropertyParticleOptions;
import com.hollingsworth.arsnouveau.api.particle.configurations.IParticleMotionType;
import com.hollingsworth.arsnouveau.api.particle.configurations.ParticleMotion;
import com.hollingsworth.arsnouveau.api.particle.configurations.properties.BaseProperty;
import com.hollingsworth.arsnouveau.api.particle.configurations.properties.ParticleDensityProperty;
import com.hollingsworth.arsnouveau.api.particle.configurations.properties.ParticleTypeProperty;
import com.hollingsworth.arsnouveau.api.particle.configurations.properties.PropMap;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.mojang.serialization.MapCodec;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class RayMotion
extends ParticleMotion {
    public static MapCodec<RayMotion> CODEC = RayMotion.buildPropCodec(RayMotion::new);
    public static StreamCodec<RegistryFriendlyByteBuf, RayMotion> STREAM = RayMotion.buildStreamCodec(RayMotion::new);

    public RayMotion() {
        this(new PropMap());
    }

    public RayMotion(PropMap propertyMap) {
        super(propertyMap);
    }

    public IParticleMotionType<?> getType() {
        return (IParticleMotionType)ArsNouveauRegistry.RAY_MOTION.get();
    }

    public void tick(PropertyParticleOptions particleOptions, Level level, double x, double y, double z, double prevX, double prevY, double prevZ) {
        ParticleDensityProperty density = this.getDensity(particleOptions, 5, 0.1f);
        Vec3 adjustedVec = this.getMotionScaled(new Vec3(x, y, z), density.radius(), density.spawnType().orElse(ParticleMotion.SpawnType.SPHERE));
        for (int i = 0; i < density.density(); ++i) {
            level.addAlwaysVisibleParticle((ParticleOptions)particleOptions, true, adjustedVec.x, adjustedVec.y, adjustedVec.z, ParticleUtil.inRange((double)-0.025, (double)0.025), ParticleUtil.inRange((double)-0.015, (double)0.015), ParticleUtil.inRange((double)-0.025, (double)0.025));
        }
    }

    public List<BaseProperty<?>> getProperties(PropMap propMap) {
        return List.of(propMap.createIfMissing((BaseProperty)new ParticleTypeProperty()), propMap.createIfMissing((BaseProperty)new ParticleDensityProperty(5, (double)0.1f, ParticleMotion.SpawnType.SPHERE).minDensity(1).densityStepSize(5).maxDensity(20).supportsShapes(true)));
    }
}

