/*
 * Decompiled with CFR 0.152.
 */
package me.ramidzkh.mekae2.ae2;

import appeng.api.behaviors.ContainerItemStrategy;
import appeng.api.config.Actionable;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import me.ramidzkh.mekae2.MekCapabilities;
import me.ramidzkh.mekae2.ae2.MekanismKey;
import mekanism.api.Action;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalHandler;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.Nullable;

public class ChemicalContainerItemStrategy
implements ContainerItemStrategy<MekanismKey, ItemStack> {
    @Nullable
    public GenericStack getContainedStack(ItemStack stack) {
        ChemicalStack chemical;
        MekanismKey key;
        if (stack.isEmpty()) {
            return null;
        }
        IChemicalHandler handler = (IChemicalHandler)stack.getCapability(MekCapabilities.CHEMICAL.item());
        if (handler != null && (key = MekanismKey.of(chemical = handler.extractChemical(Long.MAX_VALUE, Action.SIMULATE))) != null) {
            return new GenericStack((AEKey)key, chemical.getAmount());
        }
        return null;
    }

    @Nullable
    public ItemStack findCarriedContext(Player player, AbstractContainerMenu menu) {
        ItemStack carried = menu.getCarried();
        if (carried.getCapability(MekCapabilities.CHEMICAL.item()) != null) {
            return carried;
        }
        return null;
    }

    @Nullable
    public ItemStack findPlayerSlotContext(Player player, int slot) {
        ItemStack carried = player.getInventory().getItem(slot);
        if (carried.getCapability(MekCapabilities.CHEMICAL.item()) != null) {
            return carried;
        }
        return null;
    }

    public long extract(ItemStack context, MekanismKey what, long amount, Actionable mode) {
        IChemicalHandler handler = (IChemicalHandler)context.getCapability(MekCapabilities.CHEMICAL.item());
        if (handler == null) {
            return 0L;
        }
        return handler.extractChemical(what.withAmount(amount), Action.fromFluidAction((IFluidHandler.FluidAction)mode.getFluidAction())).getAmount();
    }

    public long insert(ItemStack context, MekanismKey what, long amount, Actionable mode) {
        IChemicalHandler handler = (IChemicalHandler)context.getCapability(MekCapabilities.CHEMICAL.item());
        if (handler == null) {
            return 0L;
        }
        return amount - handler.insertChemical(what.withAmount(amount), Action.fromFluidAction((IFluidHandler.FluidAction)mode.getFluidAction())).getAmount();
    }

    public void playFillSound(Player player, MekanismKey what) {
        player.playNotifySound(SoundEvents.BUCKET_FILL, SoundSource.PLAYERS, 1.0f, 1.0f);
    }

    public void playEmptySound(Player player, MekanismKey what) {
        player.playNotifySound(SoundEvents.BUCKET_EMPTY, SoundSource.PLAYERS, 1.0f, 1.0f);
    }

    @Nullable
    public GenericStack getExtractableContent(ItemStack context) {
        return this.getContainedStack(context);
    }
}

