/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.api.fluid.containers;

import com.mojang.serialization.DynamicOps;
import dev.architectury.fluid.FluidStack;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.Tuple;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.Oritech;
import rearth.oritech.api.fluid.FluidApi;
import rearth.oritech.api.networking.NetworkManager;
import rearth.oritech.api.networking.SyncType;
import rearth.oritech.api.networking.UpdatableField;

public class SimpleInOutFluidStorage
extends FluidApi.MultiSlotStorage
implements UpdatableField<Void, Tuple<FluidStack, FluidStack>> {
    private FluidStack contentIn;
    private FluidStack contentOut;
    private final Long capacity;
    private final Runnable onUpdate;
    private final FluidApi.SingleSlotStorage inputContainer;
    private final FluidApi.SingleSlotStorage outputContainer;

    public SimpleInOutFluidStorage(final Long capacity, final Runnable onUpdate) {
        this.capacity = capacity;
        this.onUpdate = onUpdate;
        this.contentIn = FluidStack.empty();
        this.contentOut = FluidStack.empty();
        this.inputContainer = new FluidApi.SingleSlotStorage(){

            @Override
            public void setStack(FluidStack stack) {
                SimpleInOutFluidStorage.this.contentIn = stack;
            }

            @Override
            public FluidStack getStack() {
                return SimpleInOutFluidStorage.this.contentIn;
            }

            @Override
            public long getCapacity() {
                return capacity;
            }

            @Override
            public long insert(FluidStack toInsert, boolean simulate) {
                return SimpleInOutFluidStorage.insertTo(toInsert, simulate, capacity, SimpleInOutFluidStorage.this.contentIn, this::setStack);
            }

            @Override
            public long extract(FluidStack toExtract, boolean simulate) {
                return SimpleInOutFluidStorage.extractFrom(toExtract, simulate, SimpleInOutFluidStorage.this.contentIn);
            }

            @Override
            public List<FluidStack> getContent() {
                return List.of(SimpleInOutFluidStorage.this.contentIn);
            }

            @Override
            public void update() {
                onUpdate.run();
            }
        };
        this.outputContainer = new FluidApi.SingleSlotStorage(){

            @Override
            public void setStack(FluidStack stack) {
                SimpleInOutFluidStorage.this.contentOut = stack;
            }

            @Override
            public FluidStack getStack() {
                return SimpleInOutFluidStorage.this.contentOut;
            }

            @Override
            public long getCapacity() {
                return capacity;
            }

            @Override
            public long insert(FluidStack toInsert, boolean simulate) {
                return SimpleInOutFluidStorage.insertTo(toInsert, simulate, capacity, SimpleInOutFluidStorage.this.contentOut, this::setStack);
            }

            @Override
            public long extract(FluidStack toExtract, boolean simulate) {
                return SimpleInOutFluidStorage.extractFrom(toExtract, simulate, SimpleInOutFluidStorage.this.contentOut);
            }

            @Override
            public List<FluidStack> getContent() {
                return List.of(SimpleInOutFluidStorage.this.contentOut);
            }

            @Override
            public void update() {
                onUpdate.run();
            }
        };
    }

    @Override
    public long getCapacity() {
        return this.capacity;
    }

    @Override
    public long insert(FluidStack toInsert, boolean simulate) {
        return SimpleInOutFluidStorage.insertTo(toInsert, simulate, this.capacity, this.contentIn, stack -> this.setStack(0, (FluidStack)stack));
    }

    @Override
    public long extract(FluidStack toExtract, boolean simulate) {
        return SimpleInOutFluidStorage.extractFrom(toExtract, simulate, this.contentOut);
    }

    @Override
    public List<FluidStack> getContent() {
        return List.of(this.contentIn, this.contentOut);
    }

    @Override
    public void update() {
        this.onUpdate.run();
    }

    public FluidApi.SingleSlotStorage getInputContainer() {
        return this.inputContainer;
    }

    public FluidApi.SingleSlotStorage getOutputContainer() {
        return this.outputContainer;
    }

    @Override
    public FluidApi.FluidStorage getStorageForDirection(@Nullable Direction direction) {
        return this;
    }

    @Override
    public void setStack(int slot, FluidStack stack) {
        if (slot == 0) {
            this.contentIn = stack;
        } else {
            this.contentOut = stack;
        }
    }

    @Override
    public FluidStack getStack(int slot) {
        if (slot == 0) {
            return this.contentIn;
        }
        return this.contentOut;
    }

    @Override
    public int getSlotCount() {
        return 2;
    }

    public void writeNbt(CompoundTag nbt, String suffix) {
        FluidStack.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.contentIn).result().ifPresent(tag -> nbt.put("fluidin" + suffix, tag));
        FluidStack.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.contentOut).result().ifPresent(tag -> nbt.put("fluidout" + suffix, tag));
    }

    public void readNbt(CompoundTag nbt, String suffix) {
        this.contentIn = FluidStack.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)nbt.get("fluidin" + suffix)).result().orElse(FluidStack.empty());
        this.contentOut = FluidStack.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)nbt.get("fluidout" + suffix)).result().orElse(FluidStack.empty());
    }

    public static Long insertTo(FluidStack toInsert, boolean simulate, long capacity, FluidStack content, Consumer<FluidStack> setFunction) {
        if (toInsert.isEmpty()) {
            return 0L;
        }
        if (content.isEmpty()) {
            long inserted = Math.min(toInsert.getAmount(), capacity);
            if (!simulate) {
                setFunction.accept(toInsert.copyWithAmount(inserted));
            }
            return inserted;
        }
        if (content.isFluidEqual(toInsert) && content.isComponentEqual(toInsert)) {
            long inserted = Math.min(toInsert.getAmount(), capacity - content.getAmount());
            if (!simulate) {
                content.grow(inserted);
            }
            return inserted;
        }
        return 0L;
    }

    public static Long extractFrom(FluidStack toExtract, boolean simulate, FluidStack content) {
        if (content.isEmpty()) {
            return 0L;
        }
        if (content.isFluidEqual(toExtract) && content.isComponentEqual(toExtract)) {
            long extracted = Math.min(toExtract.getAmount(), content.getAmount());
            if (!simulate) {
                content.shrink(extracted);
            }
            return extracted;
        }
        return 0L;
    }

    public FluidStack getInStack() {
        return this.contentIn;
    }

    public FluidStack getOutStack() {
        return this.contentOut;
    }

    @Override
    public FluidApi.FluidStorage getStorageForSlot(int slot) {
        return slot == 0 ? this.inputContainer : this.outputContainer;
    }

    @Override
    public Tuple<FluidStack, FluidStack> getDeltaData() {
        return new Tuple((Object)this.contentIn, (Object)this.contentOut);
    }

    @Override
    public Void getFullData() {
        return null;
    }

    @Override
    public StreamCodec<? extends ByteBuf, Tuple<FluidStack, FluidStack>> getDeltaCodec() {
        return new StreamCodec<ByteBuf, Tuple<FluidStack, FluidStack>>(this){

            public Tuple<FluidStack, FluidStack> decode(ByteBuf buf) {
                if (buf instanceof RegistryFriendlyByteBuf) {
                    RegistryFriendlyByteBuf registryByteBuf = (RegistryFriendlyByteBuf)buf;
                    FluidStack left = (FluidStack)NetworkManager.FLUID_STACK_STREAM_CODEC.decode((Object)registryByteBuf);
                    FluidStack right = (FluidStack)NetworkManager.FLUID_STACK_STREAM_CODEC.decode((Object)registryByteBuf);
                    return new Tuple((Object)left, (Object)right);
                }
                Oritech.LOGGER.error("Trying to decode storage data to non-registry buf! {}", (Object)buf);
                return new Tuple((Object)FluidStack.empty(), (Object)FluidStack.empty());
            }

            public void encode(ByteBuf buf, Tuple<FluidStack, FluidStack> value) {
                if (buf instanceof RegistryFriendlyByteBuf) {
                    RegistryFriendlyByteBuf registryByteBuf = (RegistryFriendlyByteBuf)buf;
                    NetworkManager.FLUID_STACK_STREAM_CODEC.encode((Object)registryByteBuf, (Object)((FluidStack)value.getA()));
                    NetworkManager.FLUID_STACK_STREAM_CODEC.encode((Object)registryByteBuf, (Object)((FluidStack)value.getB()));
                } else {
                    Oritech.LOGGER.error("Trying to encode storage data to non-registry buf! {} in {}", (Object)buf, value);
                }
            }
        };
    }

    @Override
    public StreamCodec<? extends ByteBuf, Void> getFullCodec() {
        return null;
    }

    @Override
    public boolean useDeltaOnly(SyncType type) {
        return true;
    }

    @Override
    public void handleFullUpdate(Void updatedData) {
    }

    @Override
    public void handleDeltaUpdate(Tuple<FluidStack, FluidStack> updatedData) {
        this.contentIn = (FluidStack)updatedData.getA();
        this.contentOut = (FluidStack)updatedData.getB();
    }
}

