/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.api.fluid.containers;

import dev.architectury.fluid.FluidStack;
import java.util.function.Consumer;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.item.ItemStack;
import rearth.oritech.api.fluid.FluidApi;
import rearth.oritech.api.fluid.containers.SimpleFluidStorage;

public class SimpleItemFluidStorage
extends SimpleFluidStorage {
    private final ItemStack itemStack;
    public Consumer<ItemStack> contextCallback;

    public SimpleItemFluidStorage(Long capacity, ItemStack itemStack) {
        super(capacity);
        this.itemStack = itemStack;
        this.setStack((FluidStack)itemStack.getOrDefault(FluidApi.ITEM.getFluidComponent(), (Object)FluidStack.empty()));
        if (!this.getStack().isEmpty()) {
            itemStack.set(DataComponents.MAX_STACK_SIZE, (Object)1);
        }
    }

    @Override
    public void update() {
        super.update();
        if (this.getStack().isEmpty()) {
            this.itemStack.remove(FluidApi.ITEM.getFluidComponent());
            this.itemStack.set(DataComponents.MAX_STACK_SIZE, (Object)64);
            return;
        }
        this.itemStack.set(FluidApi.ITEM.getFluidComponent(), (Object)this.getStack());
        this.itemStack.set(DataComponents.MAX_STACK_SIZE, (Object)1);
        if (this.contextCallback != null) {
            this.contextCallback.accept(this.itemStack);
        }
    }

    public SimpleItemFluidStorage withCallback(Consumer<ItemStack> contextCallback) {
        this.contextCallback = contextCallback;
        return this;
    }
}

