/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.api.networking;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import java.lang.reflect.RecordComponent;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Optional;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.Tuple;
import rearth.oritech.api.networking.NetworkManager;

public class ReflectiveCodecBuilder {
    public static <E extends Enum<E>> StreamCodec<RegistryFriendlyByteBuf, E> createForEnum(final Class<E> enumClass) {
        return new StreamCodec<RegistryFriendlyByteBuf, E>(){

            public void encode(RegistryFriendlyByteBuf buf, E value) {
                buf.writeShort(((Enum)value).ordinal());
            }

            public E decode(RegistryFriendlyByteBuf buf) {
                short ordinal = buf.readShort();
                return ((Enum[])enumClass.getEnumConstants())[ordinal];
            }
        };
    }

    public static <T extends Record> StreamCodec<RegistryFriendlyByteBuf, T> create(final Class<T> recordClass) {
        MethodHandle constructorHandle;
        if (!recordClass.isRecord()) {
            throw new IllegalArgumentException(recordClass.getName() + " is not a record type.");
        }
        final RecordComponent[] recordComponents = recordClass.getRecordComponents();
        MethodHandles.Lookup lookup = MethodHandles.publicLookup();
        final ArrayList<MethodHandle> accessors = new ArrayList<MethodHandle>(recordComponents.length);
        final ArrayList<StreamCodec> componentCodecs = new ArrayList<StreamCodec>(recordComponents.length);
        Class[] componentTypes = new Class[recordComponents.length];
        for (int i = 0; i < recordComponents.length; ++i) {
            RecordComponent component = recordComponents[i];
            componentTypes[i] = component.getType();
            try {
                StreamCodec codec;
                accessors.add(lookup.unreflect(component.getAccessor()));
                Optional<Type> listCandidate = NetworkManager.getListType(component.getGenericType());
                Optional<Tuple<Type, Type>> mapCandidate = NetworkManager.getMapType(component.getGenericType());
                if (listCandidate.isPresent()) {
                    codec = NetworkManager.getAutoCodec((Class)listCandidate.get()).apply(ByteBufCodecs.list());
                    if (codec == null) {
                        throw new RuntimeException("Failed to get codec for record component: " + component.getName() + " in " + recordClass.getName());
                    }
                    componentCodecs.add(codec);
                    continue;
                }
                if (mapCandidate.isPresent()) {
                    StreamCodec keyCodec = NetworkManager.getAutoCodec((Class)mapCandidate.get().getA());
                    StreamCodec valueCodec = NetworkManager.getAutoCodec((Class)mapCandidate.get().getB());
                    StreamCodec codec2 = ByteBufCodecs.map(HashMap::new, (StreamCodec)keyCodec, (StreamCodec)valueCodec);
                    componentCodecs.add(codec2);
                    continue;
                }
                codec = NetworkManager.getAutoCodec(component.getType());
                if (codec == null) {
                    throw new RuntimeException("Failed to get codec for record component: " + component.getName() + " in " + recordClass.getName());
                }
                componentCodecs.add(codec);
                continue;
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Failed to unreflect accessor for component: " + component.getName() + " in " + recordClass.getName(), e);
            }
            catch (NullPointerException e) {
                throw new RuntimeException("Failed to get codec for component: " + component.getName() + " in " + recordClass.getName(), e);
            }
        }
        try {
            Constructor<T> constructor = recordClass.getDeclaredConstructor(componentTypes);
            constructor.setAccessible(true);
            constructorHandle = lookup.unreflectConstructor(constructor);
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new RuntimeException("Failed to find or unreflect canonical constructor for record: " + recordClass.getName(), e);
        }
        return new StreamCodec<RegistryFriendlyByteBuf, T>(){

            public T decode(RegistryFriendlyByteBuf buffer) {
                Object[] constructorArgs = new Object[recordComponents.length];
                for (int i = 0; i < recordComponents.length; ++i) {
                    try {
                        constructorArgs[i] = ((StreamCodec)componentCodecs.get(i)).decode((Object)buffer);
                        continue;
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Error decoding component " + recordComponents[i].getName() + " for record " + recordClass.getName(), e);
                    }
                }
                try {
                    return (Record)constructorHandle.invokeWithArguments(constructorArgs);
                }
                catch (Throwable e) {
                    throw new RuntimeException("Error constructing record " + recordClass.getName(), e);
                }
            }

            public void encode(RegistryFriendlyByteBuf buffer, T recordInstance) {
                for (int i = 0; i < recordComponents.length; ++i) {
                    try {
                        Object value = ((MethodHandle)accessors.get(i)).invoke((Record)recordInstance);
                        StreamCodec valueCodec = (StreamCodec)componentCodecs.get(i);
                        valueCodec.encode((Object)buffer, value);
                        continue;
                    }
                    catch (Throwable e) {
                        throw new RuntimeException("Error encoding component " + recordComponents[i].getName() + " of record " + recordClass.getName(), e);
                    }
                }
            }
        };
    }
}

