/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.block.base.entity;

import dev.architectury.fluid.FluidStack;
import dev.architectury.hooks.fluid.FluidStackHooks;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.Tuple;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import rearth.oritech.Oritech;
import rearth.oritech.api.energy.EnergyApi;
import rearth.oritech.api.fluid.containers.SimpleInOutFluidStorage;
import rearth.oritech.api.networking.NetworkedBlockEntity;
import rearth.oritech.api.networking.SyncField;
import rearth.oritech.api.networking.SyncType;
import rearth.oritech.block.base.entity.UpgradableMachineBlockEntity;
import rearth.oritech.block.entity.generators.SteamEngineEntity;
import rearth.oritech.init.BlockContent;
import rearth.oritech.init.recipes.OritechRecipe;
import rearth.oritech.util.MachineAddonController;

public abstract class UpgradableGeneratorBlockEntity
extends UpgradableMachineBlockEntity {
    @SyncField
    public int currentMaxBurnTime;
    private List<ItemStack> pendingOutputs = new ArrayList<ItemStack>();
    @SyncField(value={SyncType.GUI_OPEN})
    public boolean isProducingSteam = false;
    @SyncField(value={SyncType.GUI_TICK})
    public final SimpleInOutFluidStorage boilerStorage;

    public UpgradableGeneratorBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state, int energyPerTick) {
        super(type, pos, state, energyPerTick);
        this.boilerStorage = new SimpleInOutFluidStorage((long)(Oritech.CONFIG.generators.steamEngineData.steamBoilerCapacityBuckets() * (float)FluidStackHooks.bucketAmount()), this::setChanged){

            @Override
            public long insert(FluidStack toInsert, boolean simulate) {
                if (!UpgradableGeneratorBlockEntity.this.boilerAcceptsInput(toInsert.getFluid())) {
                    return 0L;
                }
                return super.insert(toInsert, simulate);
            }
        };
    }

    @Override
    public void serverTick(Level world, BlockPos pos, BlockState state, NetworkedBlockEntity blockEntity) {
        if (world.isClientSide || !this.isActive(state) || this.disabledViaRedstone) {
            return;
        }
        if (this.progress > 0) {
            if (this.canFitEnergy()) {
                --this.progress;
                this.produceEnergy();
                this.lastWorkedAt = world.getGameTime();
                if (this.progress == 0) {
                    this.burningFinished();
                }
                this.setChanged();
            }
        } else if (this.canFitEnergy()) {
            this.tryConsumeInput();
        }
        this.outputEnergy();
    }

    protected void tryConsumeInput() {
        if (this.isProducingSteam && (this.boilerStorage.getInStack().getAmount() == 0L || this.boilerStorage.getOutStack().getAmount() >= this.boilerStorage.getCapacity())) {
            return;
        }
        Optional<RecipeHolder<OritechRecipe>> recipeCandidate = this.getRecipe();
        if (recipeCandidate.isEmpty()) {
            this.currentRecipe = OritechRecipe.DUMMY;
        }
        if (recipeCandidate.isPresent()) {
            int recipeTime;
            OritechRecipe activeRecipe;
            this.currentRecipe = activeRecipe = (OritechRecipe)recipeCandidate.get().value();
            this.progress = recipeTime = (int)((float)this.currentRecipe.getTime() * this.getSpeedMultiplier() * (1.0f / this.getEfficiencyMultiplier()));
            this.currentMaxBurnTime = recipeTime;
            for (int i = 0; i < activeRecipe.getInputs().size(); ++i) {
                ItemStack itemStack = ContainerHelper.removeItem(this.getInputView(), (int)i, (int)1);
            }
            this.pendingOutputs = activeRecipe.getResults();
            this.setChanged();
        }
    }

    protected void burningFinished() {
        this.produceResultItems();
    }

    protected void produceResultItems() {
        if (!this.pendingOutputs.isEmpty()) {
            for (ItemStack stack : this.pendingOutputs) {
                this.inventory.insert(stack, false);
            }
        }
        this.pendingOutputs.clear();
    }

    @Override
    public void gatherAddonStats(List<MachineAddonController.AddonBlock> addons) {
        this.isProducingSteam = false;
        super.gatherAddonStats(addons);
    }

    @Override
    public void getAdditionalStatFromAddon(MachineAddonController.AddonBlock addonBlock) {
        super.getAdditionalStatFromAddon(addonBlock);
        if (addonBlock.state().getBlock() == BlockContent.STEAM_BOILER_ADDON) {
            this.isProducingSteam = true;
            this.level.updateNeighborsAt(addonBlock.pos(), addonBlock.state().getBlock());
        }
    }

    @Override
    public void updateEnergyContainer() {
        super.updateEnergyContainer();
        long insert = this.energyStorage.maxInsert;
        this.energyStorage.maxExtract = this.getDefaultExtractionRate() + insert;
        this.energyStorage.maxInsert = 0L;
    }

    protected boolean canFitEnergy() {
        if (this.isProducingSteam) {
            return true;
        }
        float produced = this.calculateEnergyUsage();
        return (float)this.energyStorage.capacity >= (float)this.energyStorage.amount + produced;
    }

    protected void produceEnergy() {
        float produced = this.calculateEnergyUsage();
        if (this.isProducingSteam) {
            produced *= Oritech.CONFIG.generators.steamEngineData.rfToSteamRatio();
            long extracted = this.boilerStorage.getInputContainer().extract(FluidStack.create((Fluid)Fluids.WATER.getSource(), (long)Math.round(produced *= SteamEngineEntity.STEAM_AMOUNT_MULTIPLIER)), false);
            this.boilerStorage.getOutputContainer().insert(FluidStack.create((Fluid)SteamEngineEntity.getUsedSteamFluid(), (long)extracted), false);
        } else {
            this.energyStorage.amount = (long)((float)this.energyStorage.amount + produced);
        }
    }

    @Override
    protected float calculateEnergyUsage() {
        return (float)this.energyPerTick * (1.0f / this.getSpeedMultiplier());
    }

    @Override
    protected void saveAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.saveAdditional(nbt, registryLookup);
        nbt.putInt("storedBurn", this.currentMaxBurnTime);
        this.boilerStorage.writeNbt(nbt, "");
        nbt.putBoolean("steamAddon", this.isProducingSteam);
        ListTag resList = new ListTag();
        for (ItemStack stack : this.pendingOutputs) {
            Tag data = stack.save(registryLookup);
            resList.add((Object)data);
        }
        nbt.put("pendingResults", (Tag)resList);
    }

    @Override
    protected void loadAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.loadAdditional(nbt, registryLookup);
        this.currentMaxBurnTime = nbt.getInt("storedBurn");
        this.boilerStorage.readNbt(nbt, "");
        this.isProducingSteam = nbt.getBoolean("steamAddon");
        ListTag storedResults = nbt.getList("pendingResults", 10);
        for (Tag elem : storedResults) {
            CompoundTag compound = (CompoundTag)elem;
            ItemStack stack = (ItemStack)ItemStack.parse((HolderLookup.Provider)registryLookup, (Tag)compound).get();
            this.pendingOutputs.add(stack);
        }
    }

    protected abstract Set<Tuple<BlockPos, Direction>> getOutputTargets(BlockPos var1, Level var2);

    protected void outputEnergy() {
        if (this.energyStorage.getAmount() <= 0L) {
            return;
        }
        long moved = 0L;
        for (Tuple<BlockPos, Direction> target : this.getOutputTargets(this.worldPosition, this.level)) {
            EnergyApi.EnergyStorage candidate = EnergyApi.BLOCK.find(this.level, (BlockPos)target.getA(), (Direction)target.getB());
            if (candidate == null) continue;
            moved += EnergyApi.transfer(this.energyStorage, candidate, Long.MAX_VALUE, false).longValue();
        }
        if (moved > 0L) {
            this.setChanged();
        }
    }

    public boolean boilerAcceptsInput(Fluid fluid) {
        return fluid.equals(Fluids.WATER);
    }

    @Override
    public float getProgress() {
        return 1.0f - (float)this.progress / (float)this.currentMaxBurnTime;
    }

    public int getCurrentMaxBurnTime() {
        return this.currentMaxBurnTime;
    }

    public void setCurrentMaxBurnTime(int currentMaxBurnTime) {
        this.currentMaxBurnTime = currentMaxBurnTime;
    }

    @Override
    public long getDefaultInsertRate() {
        return 0L;
    }

    @Override
    public float getDisplayedEnergyTransfer() {
        return this.energyStorage.maxExtract;
    }

    @Override
    public boolean showEnergy() {
        if (this.energyStorage.maxExtract <= 0L && !this.isProducingSteam) {
            return false;
        }
        return super.showEnergy();
    }

    @Override
    protected float getAnimationSpeed() {
        if (this.currentMaxBurnTime <= 0) {
            return 1.0f;
        }
        int recipeTicks = this.currentMaxBurnTime;
        float animationTicks = 60.0f;
        return animationTicks / (float)recipeTicks * Oritech.CONFIG.generators.animationSpeedMultiplier();
    }
}

