/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.block.blocks.decorative;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class TechRedstoneButton
extends ButtonBlock {
    protected static final VoxelShape CEILING_X_SHAPE = Block.box((double)2.0, (double)12.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    protected static final VoxelShape CEILING_Z_SHAPE = Block.box((double)2.0, (double)12.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    protected static final VoxelShape FLOOR_X_SHAPE = Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)4.0, (double)14.0);
    protected static final VoxelShape FLOOR_Z_SHAPE = Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)4.0, (double)14.0);
    protected static final VoxelShape NORTH_SHAPE = Block.box((double)2.0, (double)2.0, (double)12.0, (double)14.0, (double)14.0, (double)16.0);
    protected static final VoxelShape SOUTH_SHAPE = Block.box((double)2.0, (double)2.0, (double)0.0, (double)14.0, (double)14.0, (double)4.0);
    protected static final VoxelShape WEST_SHAPE = Block.box((double)12.0, (double)2.0, (double)2.0, (double)16.0, (double)14.0, (double)14.0);
    protected static final VoxelShape EAST_SHAPE = Block.box((double)0.0, (double)2.0, (double)2.0, (double)4.0, (double)14.0, (double)14.0);

    public TechRedstoneButton(BlockSetType blockSetType, int pressTicks, BlockBehaviour.Properties settings) {
        super(blockSetType, pressTicks, settings);
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return switch ((AttachFace)state.getValue((Property)FACE)) {
            case AttachFace.FLOOR -> {
                switch (((Direction)state.getValue((Property)FACING)).getAxis()) {
                    case X: {
                        yield FLOOR_AABB_X;
                    }
                }
                yield FLOOR_AABB_Z;
            }
            case AttachFace.WALL -> {
                switch ((Direction)state.getValue((Property)FACING)) {
                    case EAST: {
                        yield EAST_AABB;
                    }
                    case WEST: {
                        yield WEST_AABB;
                    }
                    case SOUTH: {
                        yield SOUTH_AABB;
                    }
                }
                yield NORTH_AABB;
            }
            default -> {
                switch (((Direction)state.getValue((Property)FACING)).getAxis()) {
                    case X: {
                        yield CEILING_AABB_X;
                    }
                }
                yield CEILING_AABB_Z;
            }
        };
    }
}

