/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.block.blocks.pipes;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.apache.commons.lang3.function.TriFunction;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.Oritech;
import rearth.oritech.block.blocks.pipes.GenericPipeBlock;
import rearth.oritech.block.entity.pipes.GenericPipeInterfaceEntity;

public abstract class AbstractPipeBlock
extends Block {
    private static final Boolean USE_ACCURATE_OUTLINES = Oritech.CONFIG.tightCableHitboxes();
    protected VoxelShape[] boundingShapes = this.createShapes();

    public AbstractPipeBlock(BlockBehaviour.Properties settings) {
        super(settings);
    }

    protected abstract VoxelShape getShape(BlockState var1);

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        if (!USE_ACCURATE_OUTLINES.booleanValue()) {
            return super.getShape(state, world, pos, context);
        }
        return this.getShape(state);
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return this.getShape(state);
    }

    protected abstract VoxelShape[] createShapes();

    public abstract void onPlace(BlockState var1, Level var2, BlockPos var3, BlockState var4, boolean var5);

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        BlockState baseState = this.addFluidState(super.getStateForPlacement(ctx), ctx.getClickedPos(), ctx.getLevel());
        return this.addConnectionStates(baseState, ctx.getLevel(), ctx.getClickedPos(), true);
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor worldAccess, BlockPos pos, BlockPos neighborPos) {
        Level world = (Level)worldAccess;
        if (world.isClientSide) {
            return state;
        }
        if (neighborState.is(Blocks.AIR)) {
            this.getNetworkData((Level)world).machinePipeNeighbors.remove(neighborPos);
        }
        return state;
    }

    public BlockState addFluidState(BlockState state, BlockPos pos, Level level) {
        if (!state.hasProperty((Property)BlockStateProperties.WATERLOGGED)) {
            return state;
        }
        return (BlockState)state.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(level.getFluidState(pos).is((Fluid)Fluids.WATER)));
    }

    public void onRemove(BlockState state, Level world, BlockPos pos, BlockState newState, boolean moved) {
        super.onRemove(state, world, pos, newState, moved);
        if (!state.is(newState.getBlock()) && !(newState.getBlock() instanceof AbstractPipeBlock)) {
            this.onBlockRemoved(pos, state, world);
        }
    }

    public abstract void updateNeighbors(Level var1, BlockPos var2, boolean var3);

    public BlockState playerWillDestroy(Level world, BlockPos pos, BlockState state, Player player) {
        if (!player.isCreative() && !world.isClientSide) {
            this.onBlockRemoved(pos, state, world);
        }
        return super.playerWillDestroy(world, pos, state, player);
    }

    public abstract BlockState addConnectionStates(BlockState var1, Level var2, BlockPos var3, boolean var4);

    public abstract BlockState addConnectionStates(BlockState var1, Level var2, BlockPos var3, Direction var4);

    public abstract BlockState addStraightState(BlockState var1);

    public abstract boolean shouldConnect(BlockState var1, Direction var2, BlockPos var3, Level var4, boolean var5);

    public abstract boolean isConnectingInDirection(BlockState var1, Direction var2, BlockPos var3, Level var4, boolean var5);

    public boolean hasNeighboringMachine(BlockState state, Level world, BlockPos pos, boolean createConnection) {
        TriFunction<Level, BlockPos, Direction, Boolean> lookup = this.apiValidationFunction();
        return this.isConnectingInDirection(state, Direction.NORTH, pos, world, createConnection) && this.hasMachineInDirection(Direction.NORTH, world, pos, lookup) || this.isConnectingInDirection(state, Direction.EAST, pos, world, createConnection) && this.hasMachineInDirection(Direction.EAST, world, pos, lookup) || this.isConnectingInDirection(state, Direction.SOUTH, pos, world, createConnection) && this.hasMachineInDirection(Direction.SOUTH, world, pos, lookup) || this.isConnectingInDirection(state, Direction.WEST, pos, world, createConnection) && this.hasMachineInDirection(Direction.WEST, world, pos, lookup) || this.isConnectingInDirection(state, Direction.UP, pos, world, createConnection) && this.hasMachineInDirection(Direction.UP, world, pos, lookup) || this.isConnectingInDirection(state, Direction.DOWN, pos, world, createConnection) && this.hasMachineInDirection(Direction.DOWN, world, pos, lookup);
    }

    public boolean hasMachineInDirection(Direction direction, Level world, BlockPos ownPos, TriFunction<Level, BlockPos, Direction, Boolean> lookup) {
        BlockPos neighborPos = ownPos.offset(direction.getNormal());
        BlockState neighborState = world.getBlockState(neighborPos);
        return !(neighborState.getBlock() instanceof GenericPipeBlock) && (Boolean)lookup.apply((Object)world, (Object)neighborPos, (Object)direction.getOpposite()) != false;
    }

    public boolean isValidConnectionTarget(Block target, Level world, Direction direction, BlockPos pos) {
        TriFunction<Level, BlockPos, Direction, Boolean> lookupFunction = this.apiValidationFunction();
        return this.connectToOwnBlockType(target) || (Boolean)lookupFunction.apply((Object)world, (Object)pos, (Object)direction) != false && this.isCompatibleTarget(target);
    }

    public boolean isValidInterfaceTarget(Block target, Level world, Direction direction, BlockPos pos) {
        TriFunction<Level, BlockPos, Direction, Boolean> lookupFunction = this.apiValidationFunction();
        return (Boolean)lookupFunction.apply((Object)world, (Object)pos, (Object)direction) != false && this.isCompatibleTarget(target);
    }

    public boolean isCompatibleTarget(Block block) {
        return true;
    }

    public abstract TriFunction<Level, BlockPos, Direction, Boolean> apiValidationFunction();

    public abstract BlockState getConnectionBlock();

    public abstract BlockState getNormalBlock();

    public abstract String getPipeTypeName();

    public abstract boolean connectToOwnBlockType(Block var1);

    public abstract GenericPipeInterfaceEntity.PipeNetworkData getNetworkData(Level var1);

    protected abstract void onBlockRemoved(BlockPos var1, BlockState var2, Level var3);
}

