/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.block.blocks.pipes.energy;

import java.util.HashMap;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.apache.commons.lang3.function.TriFunction;
import rearth.oritech.Oritech;
import rearth.oritech.api.energy.EnergyApi;
import rearth.oritech.block.blocks.pipes.GenericPipeBlock;
import rearth.oritech.block.blocks.pipes.energy.SuperConductorConnectionBlock;
import rearth.oritech.block.blocks.pipes.energy.SuperConductorDuctBlock;
import rearth.oritech.block.entity.pipes.GenericPipeInterfaceEntity;
import rearth.oritech.init.BlockContent;

public class SuperConductorBlock
extends GenericPipeBlock {
    public static HashMap<ResourceLocation, GenericPipeInterfaceEntity.PipeNetworkData> SUPERCONDUCTOR_DATA = new HashMap();

    public SuperConductorBlock(BlockBehaviour.Properties settings) {
        super(settings);
    }

    @Override
    public TriFunction<Level, BlockPos, Direction, Boolean> apiValidationFunction() {
        return (world, pos, direction) -> EnergyApi.BLOCK.find((Level)world, (BlockPos)pos, (Direction)direction) != null;
    }

    @Override
    public BlockState getConnectionBlock() {
        return BlockContent.SUPERCONDUCTOR_CONNECTION.defaultBlockState();
    }

    @Override
    public BlockState getNormalBlock() {
        return BlockContent.SUPERCONDUCTOR.defaultBlockState();
    }

    @Override
    public String getPipeTypeName() {
        return "superconductor";
    }

    @Override
    public boolean connectToOwnBlockType(Block block) {
        return block instanceof SuperConductorBlock || block instanceof SuperConductorConnectionBlock || block instanceof SuperConductorDuctBlock;
    }

    @Override
    protected VoxelShape[] createShapes() {
        return EXTRA_THICK_SHAPES;
    }

    @Override
    public GenericPipeInterfaceEntity.PipeNetworkData getNetworkData(Level world) {
        return SUPERCONDUCTOR_DATA.computeIfAbsent(world.dimension().location(), data -> new GenericPipeInterfaceEntity.PipeNetworkData());
    }

    @Override
    public boolean isCompatibleTarget(Block block) {
        return !block.equals(BlockContent.ENERGY_PIPE_CONNECTION);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag options) {
        MutableComponent text = Component.translatable((String)"tooltip.oritech.energy_max_transfer").withStyle(ChatFormatting.GRAY).append((Component)Component.translatable((String)"tooltip.oritech.energy_transfer_rate", (Object[])new Object[]{Oritech.CONFIG.superConductorTransferRate()}).withStyle(ChatFormatting.GOLD));
        tooltip.add((Component)text);
        tooltip.add((Component)Component.translatable((String)"tooltip.oritech.superconductor").withStyle(ChatFormatting.GRAY));
        super.appendHoverText(stack, context, tooltip, options);
    }

    public static class FramedSuperConductorBlock
    extends SuperConductorBlock {
        public FramedSuperConductorBlock(BlockBehaviour.Properties settings) {
            super(settings);
        }

        @Override
        public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
            return Shapes.block();
        }

        @Override
        public VoxelShape getCollisionShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
            return state.getShape(world, pos);
        }

        @Override
        public BlockState getNormalBlock() {
            return BlockContent.FRAMED_SUPERCONDUCTOR.defaultBlockState();
        }

        @Override
        public BlockState getConnectionBlock() {
            return BlockContent.FRAMED_SUPERCONDUCTOR_CONNECTION.defaultBlockState();
        }
    }
}

