/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.block.entity.augmenter.api;

import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Position;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import rearth.oritech.Oritech;
import rearth.oritech.api.attachment.Attachment;
import rearth.oritech.api.attachment.AttachmentApi;
import rearth.oritech.block.entity.augmenter.api.Augment;
import rearth.oritech.client.other.OreFinderRenderer;
import rearth.oritech.init.EntitiesContent;
import rearth.oritech.init.TagContent;
import rearth.oritech.util.PortalEntity;

public class CustomAugmentsCollection {
    public static final Map<ResourceLocation, Augment> CUSTOM_AUGMENTS = new HashMap<ResourceLocation, Augment>();
    public static final Attachment<GlobalPos> PORTAL_TARGET_TYPE = new Attachment<GlobalPos>(){

        @Override
        public ResourceLocation identifier() {
            return Oritech.id("portal_target");
        }

        @Override
        public Codec<GlobalPos> persistenceCodec() {
            return GlobalPos.CODEC;
        }

        @Override
        public StreamCodec<ByteBuf, GlobalPos> networkCodec() {
            return GlobalPos.STREAM_CODEC;
        }

        @Override
        public Supplier<GlobalPos> initializer() {
            return () -> GlobalPos.of((ResourceKey)Level.OVERWORLD, (BlockPos)BlockPos.ZERO);
        }
    };
    public static final Augment flight = new Augment(Oritech.id("augment/flight"), true){

        @Override
        public void activate(Player player) {
            player.getAbilities().mayfly = true;
            player.onUpdateAbilities();
        }

        @Override
        public void deactivate(Player player) {
            player.getAbilities().mayfly = false;
            player.getAbilities().flying = false;
            player.onUpdateAbilities();
        }

        @Override
        public void refreshServer(Player player) {
            player.getAbilities().mayfly = true;
            player.onUpdateAbilities();
        }

        @Override
        public int refreshInterval() {
            return 80;
        }
    };
    public static final Augment feeder = new Augment(Oritech.id("augment/autofeeder"), true){

        @Override
        public void activate(Player player) {
        }

        @Override
        public void deactivate(Player player) {
        }

        @Override
        public void refreshServer(Player player) {
            int playerHungerCapacity = 20 - player.getFoodData().getFoodLevel();
            if (playerHungerCapacity < 2) {
                return;
            }
            Stream<ItemStack> foodStackStream = player.getInventory().items.stream().filter(item -> item.has(DataComponents.FOOD) && !item.is(TagContent.FEEDER_BLACKLIST));
            Optional<ItemStack> selectedFood = foodStackStream.reduce((a, b) -> Math.abs(((FoodProperties)a.get(DataComponents.FOOD)).nutrition() - playerHungerCapacity) <= Math.abs(((FoodProperties)b.get(DataComponents.FOOD)).nutrition() - playerHungerCapacity) ? a : b);
            selectedFood.ifPresent(food -> food.finishUsingItem(player.level(), (LivingEntity)player));
        }

        @Override
        public int refreshInterval() {
            return 10;
        }
    };
    public static final Augment magnet = new Augment(Oritech.id("augment/magnet"), true){

        @Override
        public void activate(Player player) {
        }

        @Override
        public void deactivate(Player player) {
        }

        @Override
        public void refreshServer(Player player) {
            Level world = player.level();
            Vec3 target = player.getEyePosition();
            int range = 8;
            double speed = 0.3;
            AABB box = new AABB(target.x - (double)range, target.y - (double)range, target.z - (double)range, target.x + (double)range, target.y + (double)range, target.z + (double)range);
            List items = world.getEntitiesOfClass(ItemEntity.class, box, itemEntity -> !itemEntity.hasPickUpDelay());
            for (ItemEntity item : items) {
                Vec3 direction = target.subtract(item.position()).normalize().scale(speed);
                item.push(direction);
            }
        }

        @Override
        public int refreshInterval() {
            return 4;
        }
    };
    public static final Augment oreFinder = new Augment(Oritech.id("augment/orefinder"), true){

        @Override
        public void activate(Player player) {
        }

        @Override
        public void deactivate(Player player) {
        }

        @Override
        public void refreshServer(Player player) {
        }

        @Override
        public void refreshClient(Player player) {
            Level world = player.level();
            BlockPos target = BlockPos.containing((Position)player.getEyePosition());
            int range = 16;
            ArrayList<BlockPos> highlightPositions = new ArrayList<BlockPos>();
            BlockPos.betweenClosed((int)(target.getX() - range), (int)(target.getY() - range), (int)(target.getZ() - range), (int)(target.getX() + range), (int)(target.getY() + range), (int)(target.getZ() + range)).forEach(pos -> {
                BlockState state = world.getBlockState(pos);
                boolean isOre = state.is(TagContent.CONVENTIONAL_ORES);
                if (isOre) {
                    highlightPositions.add(pos.immutable());
                }
            });
            if (!highlightPositions.isEmpty()) {
                OreFinderRenderer.receivedAt = player.level().getGameTime();
                OreFinderRenderer.renderedBlocks = highlightPositions;
            }
        }

        @Override
        public int refreshInterval() {
            return 6;
        }
    };
    public static final Augment portal = new Augment(Oritech.id("augment/portal"), true){

        @Override
        public void toggle(Player player) {
            Level world = player.level();
            if (world.isClientSide) {
                return;
            }
            HitResult hitResult = player.pick(6.0, 0.0f, false);
            Vec3 spawnPos = hitResult.getLocation();
            Vec3 spawnToPlayer = spawnPos.subtract(player.position()).normalize().scale(0.3);
            spawnPos = spawnPos.subtract(spawnToPlayer);
            GlobalPos targetPos = AttachmentApi.getAttachmentValue((LivingEntity)player, PORTAL_TARGET_TYPE);
            if (targetPos == null) {
                return;
            }
            PortalEntity portalEntity = (PortalEntity)EntitiesContent.PORTAL_ENTITY.create((ServerLevel)world, spawner -> {}, BlockPos.containing((Position)spawnPos), MobSpawnType.EVENT, false, false);
            if (portalEntity != null) {
                portalEntity.setPos(spawnPos);
                portalEntity.setYRot(-player.getYRot() + 90.0f);
                world.addFreshEntity((Entity)portalEntity);
                portalEntity.target = targetPos;
                world.playSound(null, BlockPos.containing((Position)spawnPos), (SoundEvent)SoundEvents.AMBIENT_CAVE.value(), SoundSource.BLOCKS, 2.0f, 1.2f);
            }
        }

        @Override
        public void activate(Player player) {
            AttachmentApi.setAttachment((LivingEntity)player, PORTAL_TARGET_TYPE, GlobalPos.of((ResourceKey)player.level().dimension(), (BlockPos)player.blockPosition()));
        }

        @Override
        public void deactivate(Player player) {
            AttachmentApi.removeAttachment((LivingEntity)player, PORTAL_TARGET_TYPE);
        }

        @Override
        public void refreshServer(Player player) {
        }

        @Override
        public int refreshInterval() {
            return Integer.MAX_VALUE;
        }
    };

    public static Augment getById(ResourceLocation id) {
        return CUSTOM_AUGMENTS.get(id);
    }

    static {
        CUSTOM_AUGMENTS.put(CustomAugmentsCollection.flight.id, flight);
        CUSTOM_AUGMENTS.put(CustomAugmentsCollection.feeder.id, feeder);
        CUSTOM_AUGMENTS.put(CustomAugmentsCollection.magnet.id, magnet);
        CUSTOM_AUGMENTS.put(CustomAugmentsCollection.oreFinder.id, oreFinder);
        CUSTOM_AUGMENTS.put(CustomAugmentsCollection.portal.id, portal);
    }
}

