/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.block.entity.pipes;

import com.google.common.collect.Streams;
import dev.architectury.fluid.FluidStack;
import dev.architectury.hooks.fluid.FluidStackHooks;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Tuple;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import rearth.oritech.Oritech;
import rearth.oritech.api.fluid.FluidApi;
import rearth.oritech.block.blocks.pipes.ExtractablePipeConnectionBlock;
import rearth.oritech.block.blocks.pipes.fluid.FluidPipeBlock;
import rearth.oritech.block.blocks.pipes.fluid.FluidPipeConnectionBlock;
import rearth.oritech.block.entity.pipes.ExtractablePipeInterfaceEntity;
import rearth.oritech.block.entity.pipes.GenericPipeInterfaceEntity;
import rearth.oritech.init.BlockEntitiesContent;

public class FluidPipeInterfaceEntity
extends ExtractablePipeInterfaceEntity {
    public static final int MAX_TRANSFER_RATE = (int)((float)FluidStackHooks.bucketAmount() * Oritech.CONFIG.fluidPipeExtractAmountBuckets());
    private static final int TRANSFER_PERIOD = Oritech.CONFIG.fluidPipeExtractIntervalDuration();
    private List<FluidApi.FluidStorage> filteredFluidTargetsCached;

    public FluidPipeInterfaceEntity(BlockPos pos, BlockState state) {
        super(BlockEntitiesContent.FLUID_PIPE_ENTITY, pos, state);
    }

    public void tick(Level world, BlockPos pos, BlockState state, GenericPipeInterfaceEntity blockEntity) {
        long moved;
        ExtractablePipeConnectionBlock block = (ExtractablePipeConnectionBlock)state.getBlock();
        if (world.isClientSide || !block.isExtractable(state)) {
            return;
        }
        boolean boosted = this.isBoostAvailable();
        if (world.getGameTime() % (long)TRANSFER_PERIOD != 0L && !boosted) {
            return;
        }
        GenericPipeInterfaceEntity.PipeNetworkData data = FluidPipeBlock.FLUID_PIPE_DATA.getOrDefault(world.dimension().location(), new GenericPipeInterfaceEntity.PipeNetworkData());
        int transferAmount = boosted ? MAX_TRANSFER_RATE * 100 : MAX_TRANSFER_RATE;
        FluidStack stackToMove = FluidStack.empty();
        FluidApi.FluidStorage takenFrom = null;
        Set sources = data.machineInterfaces.getOrDefault(pos, new HashSet());
        for (BlockPos sourcePos : sources) {
            List<FluidStack> contents;
            Optional<FluidStack> extractionCandidate;
            FluidApi.FluidStorage sourceContainer;
            BlockPos offset = pos.subtract((Vec3i)sourcePos);
            Direction direction = Direction.fromDelta((int)offset.getX(), (int)offset.getY(), (int)offset.getZ());
            if (!block.isSideExtractable(state, direction.getOpposite())) continue;
            BlockState sourceBlock = world.getBlockState(sourcePos);
            if (sourceBlock.is(BlockTags.CAULDRONS)) {
                transferAmount = (int)FluidStackHooks.bucketAmount();
            }
            if ((sourceContainer = FluidApi.BLOCK.find(world, sourcePos, sourceBlock, null, direction)) == null || !sourceContainer.supportsExtraction() || !(extractionCandidate = Streams.stream(contents = sourceContainer.getContent()).filter(candidate -> !candidate.isEmpty()).filter(candidate -> sourceContainer.extract((FluidStack)candidate, true) > 0L).findFirst()).isPresent()) continue;
            FluidStack extractionTest = extractionCandidate.get().copyWithAmount((long)transferAmount);
            long movedAmount = sourceContainer.extract(extractionTest, true);
            stackToMove = extractionTest;
            stackToMove.setAmount(movedAmount);
            takenFrom = sourceContainer;
            break;
        }
        if (stackToMove.isEmpty() || takenFrom == null) {
            return;
        }
        Set<Tuple<BlockPos, Direction>> targets = FluidPipeInterfaceEntity.findNetworkTargets(pos, data);
        if (targets == null) {
            System.err.println("Yeah your pipe network likely is too long. At: " + String.valueOf(this.getBlockPos()));
            return;
        }
        int netHash = targets.hashCode();
        if (netHash != this.filteredTargetsNetHash || this.filteredFluidTargetsCached == null) {
            this.filteredFluidTargetsCached = targets.stream().filter(target -> {
                Direction direction = (Direction)target.getB();
                BlockPos pipePos = ((BlockPos)target.getA()).offset(direction.getNormal());
                BlockState pipeState = world.getBlockState(pipePos);
                Block patt0$temp = pipeState.getBlock();
                if (!(patt0$temp instanceof FluidPipeConnectionBlock)) {
                    return true;
                }
                FluidPipeConnectionBlock fluidBlock = (FluidPipeConnectionBlock)patt0$temp;
                boolean extracting = fluidBlock.isSideExtractable(pipeState, ((Direction)target.getB()).getOpposite());
                return !extracting;
            }).map(target -> FluidApi.BLOCK.find(world, (BlockPos)target.getA(), (Direction)target.getB())).filter(obj -> Objects.nonNull(obj) && obj.supportsInsertion()).collect(Collectors.toList());
            this.filteredTargetsNetHash = netHash;
        }
        Collections.shuffle(this.filteredFluidTargetsCached);
        long availableFluid = stackToMove.getAmount();
        for (FluidApi.FluidStorage targetStorage : this.filteredFluidTargetsCached) {
            long transferred = targetStorage.insert(stackToMove, false);
            stackToMove.shrink(transferred);
            targetStorage.update();
            if (stackToMove.getAmount() > 0L) continue;
            break;
        }
        if ((moved = availableFluid - stackToMove.getAmount()) > 0L) {
            stackToMove.setAmount(moved);
            takenFrom.extract(stackToMove, false);
            this.onBoostUsed();
            takenFrom.update();
        }
    }
}

