/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.client.ui;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import io.wispforest.owo.ui.base.BaseOwoHandledScreen;
import io.wispforest.owo.ui.component.BoxComponent;
import io.wispforest.owo.ui.component.ButtonComponent;
import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.component.ItemComponent;
import io.wispforest.owo.ui.component.LabelComponent;
import io.wispforest.owo.ui.component.TextureComponent;
import io.wispforest.owo.ui.container.Containers;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.container.OverlayContainer;
import io.wispforest.owo.ui.container.ScrollContainer;
import io.wispforest.owo.ui.core.Color;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.HorizontalAlignment;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.OwoUIAdapter;
import io.wispforest.owo.ui.core.OwoUIDrawContext;
import io.wispforest.owo.ui.core.PositionedRectangle;
import io.wispforest.owo.ui.core.Positioning;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.core.Surface;
import io.wispforest.owo.ui.core.VerticalAlignment;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.joml.Vector2f;
import org.joml.Vector2i;
import org.joml.Vector2ic;
import rearth.oritech.Oritech;
import rearth.oritech.api.networking.NetworkManager;
import rearth.oritech.block.entity.augmenter.AugmentApplicationEntity;
import rearth.oritech.block.entity.augmenter.PlayerAugments;
import rearth.oritech.block.entity.augmenter.api.Augment;
import rearth.oritech.client.ui.AugmentSelectionScreen;
import rearth.oritech.client.ui.BasicMachineScreen;
import rearth.oritech.client.ui.PlayerModifierScreenHandler;
import rearth.oritech.init.recipes.AugmentDataRecipe;
import rearth.oritech.util.SizedIngredient;
import rearth.oritech.util.TooltipHelper;

public class PlayerModifierScreen
extends BaseOwoHandledScreen<FlowLayout, PlayerModifierScreenHandler> {
    private static DraggableScrollContainer<FlowLayout> main;
    private static FlowLayout root;
    private static final HashMap<String, Tuple<Vector2i, Vector2i>> dependencyLines;
    private static final HashMap<ResourceLocation, AugmentUiState> shownAugments;
    private final Set<BoxComponent> highlighters = new HashSet<BoxComponent>();
    private final List<LabelComponent> researchLabels = new ArrayList<LabelComponent>();
    private final int backgroundAugmentFrameSize = 32;
    private final int augmentIconSize = 24;
    private static final float panelHeight = 0.8f;
    private TextureComponent energyIndicator;

    public PlayerModifierScreen(PlayerModifierScreenHandler handler, Inventory inventory, net.minecraft.network.chat.Component title) {
        super((AbstractContainerMenu)handler, inventory, title);
    }

    @NotNull
    protected OwoUIAdapter<FlowLayout> createAdapter() {
        return OwoUIAdapter.create((Screen)this, CustomFlowRootContainer::verticalFlow);
    }

    protected void build(FlowLayout rootComponent) {
        rootComponent.surface(Surface.VANILLA_TRANSLUCENT).horizontalAlignment(HorizontalAlignment.CENTER).verticalAlignment(VerticalAlignment.CENTER);
        root = rootComponent;
        if (((PlayerModifierScreenHandler)this.menu).blockEntity == null) {
            this.onClose();
            return;
        }
        dependencyLines.clear();
        shownAugments.clear();
        FlowLayout outerContainer = Containers.horizontalFlow((Sizing)Sizing.fill((int)60), (Sizing)Sizing.fill((int)80));
        outerContainer.surface(BasicMachineScreen.ORITECH_PANEL);
        FlowLayout movedPanel = Containers.horizontalFlow((Sizing)Sizing.fixed((int)900), (Sizing)Sizing.fill());
        movedPanel.surface(Surface.tiled((ResourceLocation)Oritech.id("textures/block/machine_plating_block/empty.png"), (int)16, (int)16));
        movedPanel.margins(Insets.of((int)2));
        DraggableScrollContainer<FlowLayout> innerContainer = new DraggableScrollContainer<FlowLayout>(ScrollContainer.ScrollDirection.HORIZONTAL, Sizing.fill(), Sizing.fill(), movedPanel);
        innerContainer.scrollbar(ScrollContainer.Scrollbar.vanillaFlat());
        innerContainer.surface(Surface.PANEL_INSET);
        innerContainer.margins(Insets.of((int)6));
        main = innerContainer;
        rootComponent.child((Component)outerContainer.positioning(Positioning.relative((int)50, (int)50)));
        outerContainer.child(innerContainer);
        this.addAvailableAugments(movedPanel);
        int researchWidth = 120;
        FlowLayout researchContainer = Containers.verticalFlow((Sizing)Sizing.fixed((int)researchWidth), (Sizing)Sizing.content());
        researchContainer.alignment(HorizontalAlignment.CENTER, VerticalAlignment.CENTER);
        this.addResearchPanels(researchContainer, researchWidth);
        FlowLayout energyPanel = Containers.verticalFlow((Sizing)Sizing.content((int)3), (Sizing)Sizing.content((int)3));
        energyPanel.surface(BasicMachineScreen.ORITECH_PANEL);
        energyPanel.alignment(HorizontalAlignment.CENTER, VerticalAlignment.CENTER);
        ButtonComponent loadResearchedAugments = Components.button((net.minecraft.network.chat.Component)net.minecraft.network.chat.Component.translatable((String)"\ud83d\udd2c"), elem -> this.onLoadAugmentsClick());
        loadResearchedAugments.tooltip((net.minecraft.network.chat.Component)net.minecraft.network.chat.Component.translatable((String)"text.oritech.load_augments.tooltip"));
        loadResearchedAugments.margins(Insets.of((int)2));
        loadResearchedAugments.renderer(BasicMachineScreen.ORITECH_BUTTON);
        ButtonComponent openInvScreen = Components.button((net.minecraft.network.chat.Component)net.minecraft.network.chat.Component.translatable((String)"\ud83e\uddf0"), elem -> this.onOpenInvClicked());
        openInvScreen.tooltip((net.minecraft.network.chat.Component)net.minecraft.network.chat.Component.translatable((String)"text.oritech.open_inv.tooltip"));
        openInvScreen.margins(Insets.of((int)2));
        openInvScreen.renderer(BasicMachineScreen.ORITECH_BUTTON);
        double energyPanelX = (double)this.width * 0.2 - 22.0;
        double energyPanelY = (double)this.height * 0.3;
        double researchPanelX = (double)this.width * 0.8 - 2.0;
        double researchPanelY = (double)this.height * 0.2;
        this.addEnergyBar(energyPanel);
        energyPanel.child(loadResearchedAugments.horizontalSizing(Sizing.fixed((int)18)));
        energyPanel.child(openInvScreen.horizontalSizing(Sizing.fixed((int)18)));
        root.child(energyPanel.positioning(Positioning.absolute((int)((int)energyPanelX), (int)((int)energyPanelY))).zIndex(-1));
        root.child(researchContainer.positioning(Positioning.absolute((int)((int)researchPanelX), (int)((int)researchPanelY))).zIndex(-1));
    }

    protected void containerTick() {
        super.containerTick();
        if (((PlayerModifierScreenHandler)this.menu).blockEntity == null) {
            return;
        }
        for (int i = 0; i < 3; ++i) {
            boolean isIdle;
            if (i >= this.researchLabels.size()) continue;
            LabelComponent panelData = this.researchLabels.get(i);
            AugmentApplicationEntity.ResearchState researchData = ((PlayerModifierScreenHandler)this.menu).blockEntity.availableStations.get(i);
            if (researchData == null || panelData == null) continue;
            MutableComponent baseKey = net.minecraft.network.chat.Component.literal((String)"");
            long time = ((PlayerModifierScreenHandler)this.menu).blockEntity.getLevel().getGameTime();
            boolean bl = isIdle = !researchData.working;
            if (isIdle) {
                long ticks = time % 20L / 7L;
                baseKey = net.minecraft.network.chat.Component.translatable((String)("text.oritech.accelerator.ui.waiting." + ticks));
            } else {
                long remainingTicks = researchData.researchStartedAt + (long)researchData.workTime - time;
                int remainingSeconds = (int)((float)remainingTicks / 20.0f);
                baseKey = net.minecraft.network.chat.Component.translatable((String)"text.oritech.augmenter_active", (Object[])new Object[]{remainingSeconds});
            }
            panelData.text((net.minecraft.network.chat.Component)baseKey);
        }
        for (Map.Entry<ResourceLocation, AugmentUiState> entry : shownAugments.entrySet()) {
            ResourceLocation augmentId = entry.getKey();
            AugmentUiState augmentState = entry.getValue();
            AugmentDataRecipe augmentRecipe = (AugmentDataRecipe)((RecipeHolder)((PlayerModifierScreenHandler)this.menu).player.level().getRecipeManager().byKey(augmentId).get()).value();
            boolean isResearched = ((PlayerModifierScreenHandler)this.menu).blockEntity.researchedAugments.contains(augmentId);
            boolean isResearching = ((PlayerModifierScreenHandler)this.menu).blockEntity.availableStations.values().stream().filter(Objects::nonNull).anyMatch(station -> station.selectedResearch.equals((Object)augmentId));
            boolean isApplied = ((PlayerModifierScreenHandler)this.menu).blockEntity.hasPlayerAugment(augmentId, ((PlayerModifierScreenHandler)this.menu).player);
            boolean hasRequirements = true;
            ArrayList<MutableComponent> missingRequirements = new ArrayList<MutableComponent>();
            missingRequirements.add(net.minecraft.network.chat.Component.translatable((String)PlayerModifierScreen.augmentKey(augmentId).formatted(ChatFormatting.BOLD)));
            missingRequirements.add(net.minecraft.network.chat.Component.translatable((String)"oritech.text.missing_requirements_title"));
            for (ResourceLocation requirementId : augmentRecipe.getRequirements()) {
                if (!((PlayerModifierScreenHandler)this.menu).blockEntity.researchedAugments.contains(requirementId)) {
                    hasRequirements = false;
                    missingRequirements.add(net.minecraft.network.chat.Component.translatable((String)PlayerModifierScreen.augmentKey(requirementId)).withStyle(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.RED}));
                    continue;
                }
                missingRequirements.add(net.minecraft.network.chat.Component.translatable((String)PlayerModifierScreen.augmentKey(requirementId)).withStyle(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.DARK_GREEN}));
            }
            boolean hasResearchStation = false;
            Block requiredStationBlock = (Block)BuiltInRegistries.BLOCK.get(augmentRecipe.getRequiredStation());
            for (AugmentApplicationEntity.ResearchState ownStation : ((PlayerModifierScreenHandler)this.menu).blockEntity.availableStations.values()) {
                if (ownStation == null || !ownStation.type.equals(requiredStationBlock)) continue;
                hasResearchStation = true;
                break;
            }
            if (!hasResearchStation) {
                missingRequirements.add(net.minecraft.network.chat.Component.translatable((String)"oritech.text.required_station", (Object[])new Object[]{requiredStationBlock.getName()}));
                hasRequirements = false;
            }
            PlayerAugments.AugmentApplicatorOperation operation = PlayerAugments.AugmentApplicatorOperation.RESEARCH;
            MutableComponent tooltipTitleText = net.minecraft.network.chat.Component.translatable((String)PlayerModifierScreen.augmentKey(augmentId)).withStyle(ChatFormatting.BOLD);
            String tooltipOperation = "oritech.text.augment_op.research";
            MutableComponent tooltipDesc = net.minecraft.network.chat.Component.translatable((String)(PlayerModifierScreen.augmentKey(augmentId) + ".desc")).withStyle(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.GRAY});
            ArrayList<MutableComponent> extraTooltips = new ArrayList<MutableComponent>();
            for (int i = 1; i < 8; ++i) {
                String key = PlayerModifierScreen.augmentKey(augmentId) + ".desc." + i;
                if (!I18n.exists((String)key)) continue;
                extraTooltips.add(net.minecraft.network.chat.Component.translatable((String)key).withStyle(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.GRAY}));
            }
            if (isApplied) {
                operation = PlayerAugments.AugmentApplicatorOperation.REMOVE;
                tooltipOperation = "oritech.text.augment_op.remove";
            } else if (isResearched) {
                operation = PlayerAugments.AugmentApplicatorOperation.ADD;
                tooltipOperation = "oritech.text.augment_op.apply";
            } else if (isResearching) {
                operation = PlayerAugments.AugmentApplicatorOperation.NONE;
                tooltipOperation = "oritech.text.augment_op.pending";
            }
            tooltipTitleText = net.minecraft.network.chat.Component.translatable((String)tooltipOperation).append((net.minecraft.network.chat.Component)tooltipTitleText);
            PlayerAugments.AugmentApplicatorOperation lastOp = augmentState.openOp;
            if (operation != lastOp) {
                ArrayList<ClientTooltipComponent> collectedTooltip = new ArrayList<ClientTooltipComponent>();
                Stream.of(tooltipTitleText, tooltipDesc).map(elem -> ClientTooltipComponent.create((FormattedCharSequence)elem.getVisualOrderText())).forEach(collectedTooltip::add);
                extraTooltips.stream().map(elem -> ClientTooltipComponent.create((FormattedCharSequence)elem.getVisualOrderText())).forEach(collectedTooltip::add);
                ResourceLocation backgroundTexture = Oritech.id("textures/gui/augment/background_open.png");
                if (isApplied) {
                    backgroundTexture = Oritech.id("textures/gui/augment/background_installed.png");
                } else if (isResearched) {
                    backgroundTexture = Oritech.id("textures/gui/augment/background_completed.png");
                } else if (isResearching) {
                    backgroundTexture = Oritech.id("textures/gui/augment/background_pending.png");
                } else {
                    List<SizedIngredient> inputs = augmentRecipe.getResearchCost();
                    int time = augmentRecipe.getTime() / 20;
                    collectedTooltip.add(ClientTooltipComponent.create((FormattedCharSequence)net.minecraft.network.chat.Component.translatable((String)"oritech.text.augment_research_time", (Object[])new Object[]{time}).getVisualOrderText()));
                    SizedIngredientTooltipComponent inputsComponent = new SizedIngredientTooltipComponent(inputs);
                    collectedTooltip.add(inputsComponent);
                }
                augmentState.icon.tooltip(collectedTooltip);
                DraggableScrollContainer scrollPanel = (DraggableScrollContainer)augmentState.parent.parent();
                int scrollOffset = (int)scrollPanel.getScrollPosition();
                TextureComponent oldBackground = augmentState.background;
                TextureComponent newBackground = Components.texture((ResourceLocation)backgroundTexture, (int)0, (int)0, (int)16, (int)16, (int)16, (int)16);
                newBackground.sizing(Sizing.fixed((int)32), Sizing.fixed((int)32));
                newBackground.positioning(Positioning.absolute((int)(oldBackground.x() - augmentState.parent.x() - scrollOffset), (int)(oldBackground.y() - augmentState.parent.y())));
                augmentState.parent.removeChild((Component)oldBackground);
                augmentState.parent.child(newBackground.zIndex(2));
                augmentState.openOp = operation;
            }
            if (!hasRequirements && augmentState.blocker == null) {
                BoxComponent blocker = Components.box((Sizing)Sizing.fixed((int)24), (Sizing)Sizing.fixed((int)24));
                blocker.color(new Color(0.3f, 0.4f, 0.4f, 0.8f));
                blocker.fill(true);
                blocker.positioning(Positioning.absolute((int)(augmentState.icon.x() - augmentState.parent.x()), (int)(augmentState.icon.y() - augmentState.parent.y())));
                blocker.mouseDown().subscribe((a, b, c) -> true);
                blocker.zIndex(4);
                augmentState.parent.child((Component)blocker);
                augmentState.blocker = blocker;
            } else if (hasRequirements && augmentState.blocker != null) {
                augmentState.parent.removeChild((Component)augmentState.blocker);
                augmentState.blocker = null;
            }
            if (hasRequirements) continue;
            augmentState.blocker.tooltip(missingRequirements);
        }
        this.updateEnergyBar();
    }

    public void render(GuiGraphics vanillaContext, int mouseX, int mouseY, float delta) {
        for (BoxComponent highlight : this.highlighters) {
            boolean isActive = highlight.isInBoundingBox((double)mouseX, (double)mouseY);
            if (isActive) {
                highlight.color(new Color(0.7f, 0.7f, 0.7f, 1.0f));
                continue;
            }
            highlight.color(new Color(0.7f, 0.7f, 0.7f, 0.0f));
        }
        super.render(vanillaContext, mouseX, mouseY, delta);
    }

    protected void updateEnergyBar() {
        long capacity = ((PlayerModifierScreenHandler)this.menu).blockEntity.getEnergyStorageForMultiblock(null).getCapacity();
        long amount = ((PlayerModifierScreenHandler)this.menu).blockEntity.getEnergyStorageForMultiblock(null).getAmount();
        float fillAmount = (float)amount / (float)capacity;
        net.minecraft.network.chat.Component tooltipText = BasicMachineScreen.getEnergyTooltip(amount, capacity, 0L, (int)AugmentApplicationEntity.maxEnergyTransfer);
        this.energyIndicator.tooltip(tooltipText);
        this.energyIndicator.visibleArea(PositionedRectangle.of((int)0, (int)(96 - (int)(96.0f * fillAmount)), (int)24, (int)((int)(96.0f * fillAmount))));
    }

    private void addResearchPanels(FlowLayout parent, int width) {
        for (int i = 0; i < 3; ++i) {
            AugmentApplicationEntity.ResearchState researchState = ((PlayerModifierScreenHandler)this.menu).blockEntity.availableStations.getOrDefault(i, null);
            if (researchState == null) {
                this.researchLabels.add(null);
                continue;
            }
            FlowLayout panel = Containers.verticalFlow((Sizing)Sizing.fixed((int)width), (Sizing)Sizing.fixed((int)((int)((double)width * 0.4))));
            LabelComponent title = Components.label((net.minecraft.network.chat.Component)researchState.type.getName().withStyle(ChatFormatting.BOLD));
            title.horizontalSizing(Sizing.fill());
            title.horizontalTextAlignment(HorizontalAlignment.CENTER);
            LabelComponent status = Components.label((net.minecraft.network.chat.Component)net.minecraft.network.chat.Component.literal((String)" "));
            panel.child((Component)title);
            panel.child((Component)status.margins(Insets.of((int)4, (int)2, (int)0, (int)0)));
            this.researchLabels.add(status);
            parent.child(panel.surface(BasicMachineScreen.ORITECH_PANEL).padding(Insets.of((int)6)).margins(Insets.of((int)0, (int)10, (int)0, (int)0)).zIndex(-1));
        }
    }

    private void addAvailableAugments(FlowLayout parent) {
        float maxHeight = (float)this.height * 0.75f;
        int leftOffset = 20;
        for (ResourceLocation augmentId : PlayerAugments.allAugments.keySet()) {
            AugmentDataRecipe augmentRecipe = (AugmentDataRecipe)((RecipeHolder)((PlayerModifierScreenHandler)this.menu).player.level().getRecipeManager().byKey(augmentId).get()).value();
            Vector2i position = new Vector2i(leftOffset + augmentRecipe.getUiX() * 4, (int)((float)augmentRecipe.getUiY() / 100.0f * maxHeight));
            ResourceLocation iconTexture = Oritech.id("textures/gui/" + augmentId.getPath() + ".png");
            ResourceLocation backgroundTexture = Oritech.id("textures/gui/augment/background_open.png");
            ResourceLocation augmentOpId = augmentId;
            TextureComponent icon = Components.texture((ResourceLocation)iconTexture, (int)0, (int)0, (int)24, (int)24, (int)24, (int)24);
            icon.mouseDown().subscribe((a, b, c) -> {
                this.onAugmentClick(augmentOpId, PlayerModifierScreen.shownAugments.get((Object)augmentOpId).openOp, false);
                return true;
            });
            icon.sizing(Sizing.fixed((int)24), Sizing.fixed((int)24));
            icon.positioning(Positioning.absolute((int)(position.x - 12), (int)(position.y - 12)));
            TextureComponent background = Components.texture((ResourceLocation)backgroundTexture, (int)0, (int)0, (int)16, (int)16, (int)16, (int)16);
            background.sizing(Sizing.fixed((int)32), Sizing.fixed((int)32));
            background.positioning(Positioning.absolute((int)(position.x - 16), (int)(position.y - 16)));
            BoxComponent highlight = Components.box((Sizing)Sizing.fixed((int)34), (Sizing)Sizing.fixed((int)34));
            highlight.color(new Color(0.7f, 0.7f, 0.7f, 1.0f));
            highlight.positioning(Positioning.absolute((int)(position.x - 16 - 1), (int)(position.y - 16 - 1)));
            for (ResourceLocation dependencyId : augmentRecipe.getRequirements()) {
                AugmentDataRecipe dependencyRecipe = (AugmentDataRecipe)((RecipeHolder)((PlayerModifierScreenHandler)this.menu).player.level().getRecipeManager().byKey(dependencyId).get()).value();
                Vector2i dependencyPos = new Vector2i(leftOffset + dependencyRecipe.getUiX() * 4, (int)((float)dependencyRecipe.getUiY() / 100.0f * maxHeight));
                String depId = augmentId.getPath() + "_" + dependencyId.getPath();
                dependencyLines.put(depId, (Tuple<Vector2i, Vector2i>)new Tuple((Object)position, (Object)dependencyPos));
            }
            parent.child(highlight.zIndex(1));
            parent.child(background.zIndex(2));
            parent.child(icon.zIndex(3));
            this.highlighters.add(highlight);
            shownAugments.put(augmentId, new AugmentUiState(highlight, background, icon, null, PlayerAugments.AugmentApplicatorOperation.NEEDS_INIT, parent));
        }
    }

    private void onAugmentClick(ResourceLocation id, PlayerAugments.AugmentApplicatorOperation operation, boolean confirmed) {
        if (!confirmed) {
            this.showAugmentDialog(id, operation);
            return;
        }
        int operationId = operation.ordinal();
        NetworkManager.sendToServer(new PlayerAugments.AugmentInstallTriggerPacket(((PlayerModifierScreenHandler)this.menu).blockPos, id, operationId));
    }

    private void onLoadAugmentsClick() {
        NetworkManager.sendToServer(new PlayerAugments.LoadPlayerAugmentsToMachinePacket(((PlayerModifierScreenHandler)this.menu).blockPos));
        int loadedAugmentsCount = 0;
        for (Map.Entry<ResourceLocation, Augment> entry : PlayerAugments.allAugments.entrySet()) {
            Augment augment = entry.getValue();
            boolean isResearched = ((PlayerModifierScreenHandler)this.menu).blockEntity.researchedAugments.contains(entry.getKey());
            boolean isInstalled = augment.isInstalled(((PlayerModifierScreenHandler)this.menu).player);
            if (!isInstalled || isResearched) continue;
            ++loadedAugmentsCount;
        }
        ((PlayerModifierScreenHandler)this.menu).player.sendSystemMessage((net.minecraft.network.chat.Component)net.minecraft.network.chat.Component.translatable((String)"text.oritech.loaded_augments", (Object[])new Object[]{loadedAugmentsCount}));
        this.onClose();
    }

    private void onOpenInvClicked() {
        this.onClose();
        NetworkManager.sendToServer(new PlayerAugments.OpenAugmentScreenPacket(((PlayerModifierScreenHandler)this.menu).blockPos));
    }

    private void showAugmentDialog(ResourceLocation id, PlayerAugments.AugmentApplicatorOperation operation) {
        AugmentDataRecipe researchRecipe = (AugmentDataRecipe)((RecipeHolder)((PlayerModifierScreenHandler)this.menu).blockEntity.getLevel().getRecipeManager().byKey(id).get()).value();
        boolean isCreative = ((PlayerModifierScreenHandler)this.menu).player.isCreative();
        boolean hasResources = true;
        boolean hasEnergy = true;
        FlowLayout panel = Containers.verticalFlow((Sizing)Sizing.fixed((int)310), (Sizing)Sizing.content((int)1));
        panel.padding(Insets.of((int)5));
        panel.surface(BasicMachineScreen.ORITECH_PANEL);
        panel.horizontalAlignment(HorizontalAlignment.CENTER);
        FlowLayout descriptionPanel = Containers.verticalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content((int)3));
        descriptionPanel.surface(Surface.PANEL_INSET);
        descriptionPanel.padding(Insets.of((int)3, (int)0, (int)3, (int)3));
        descriptionPanel.margins(Insets.of((int)4));
        OverlayContainer overlay = Containers.overlay((Component)panel);
        LabelComponent titleLabel = Components.label((net.minecraft.network.chat.Component)net.minecraft.network.chat.Component.translatable((String)PlayerModifierScreen.augmentKey(id)).withStyle(new ChatFormatting[]{ChatFormatting.BOLD, ChatFormatting.BLACK}));
        titleLabel.margins(Insets.of((int)3, (int)1, (int)0, (int)0));
        descriptionPanel.child((Component)Components.label((net.minecraft.network.chat.Component)net.minecraft.network.chat.Component.translatable((String)(PlayerModifierScreen.augmentKey(id) + ".desc")).withStyle(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.GRAY})));
        for (int i = 1; i < 8; ++i) {
            String key = PlayerModifierScreen.augmentKey(id) + ".desc." + i;
            if (!I18n.exists((String)key)) continue;
            descriptionPanel.child((Component)Components.label((net.minecraft.network.chat.Component)net.minecraft.network.chat.Component.translatable((String)key).withStyle(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.GRAY})));
        }
        Block requiredStationBlock = (Block)BuiltInRegistries.BLOCK.get(researchRecipe.getRequiredStation());
        LabelComponent requiredStationLabel = Components.label((net.minecraft.network.chat.Component)net.minecraft.network.chat.Component.translatable((String)"oritech.text.required_station", (Object[])new Object[]{requiredStationBlock.getName()}));
        descriptionPanel.child((Component)requiredStationLabel.margins(Insets.of((int)4, (int)2, (int)0, (int)0)));
        boolean hasRequiredStation = false;
        for (int i = 0; i < 3; ++i) {
            AugmentApplicationEntity.ResearchState station = ((PlayerModifierScreenHandler)this.menu).blockEntity.availableStations.getOrDefault(i, null);
            if (station == null || station.working || !requiredStationBlock.equals(station.type)) continue;
            hasRequiredStation = true;
        }
        if (!operation.equals((Object)PlayerAugments.AugmentApplicatorOperation.REMOVE)) {
            if (operation.equals((Object)PlayerAugments.AugmentApplicatorOperation.RESEARCH)) {
                long rfCost = researchRecipe.getRfCost();
                Iterator<SizedIngredient> parsedCost = TooltipHelper.getEnergyText(rfCost);
                descriptionPanel.child((Component)Components.label((net.minecraft.network.chat.Component)net.minecraft.network.chat.Component.translatable((String)"oritech.text.augment_research_time", (Object[])new Object[]{researchRecipe.getTime() / 20}).withStyle(ChatFormatting.WHITE)).margins(Insets.of((int)4, (int)0, (int)0, (int)0)));
                descriptionPanel.child((Component)Components.label((net.minecraft.network.chat.Component)net.minecraft.network.chat.Component.translatable((String)"oritech.text.energy_cost", (Object[])new Object[]{parsedCost}).withStyle(ChatFormatting.WHITE)).margins(Insets.of((int)4, (int)0, (int)0, (int)0)));
                if (((PlayerModifierScreenHandler)this.menu).blockEntity.getEnergyStorageForMultiblock(null).getAmount() < rfCost) {
                    hasEnergy = false;
                }
            }
            descriptionPanel.child((Component)Components.label((net.minecraft.network.chat.Component)net.minecraft.network.chat.Component.translatable((String)"oritech.text.augment_resource_cost").withStyle(ChatFormatting.WHITE)).margins(Insets.of((int)4, (int)0, (int)0, (int)0)));
            FlowLayout itemContainer = Containers.horizontalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content((int)1));
            List<SizedIngredient> shownCost = researchRecipe.getResearchCost();
            if (operation.equals((Object)PlayerAugments.AugmentApplicatorOperation.ADD)) {
                shownCost = researchRecipe.getApplyCost();
            }
            for (SizedIngredient wantedInput : shownCost) {
                Ingredient type = wantedInput.ingredient();
                int count = wantedInput.count();
                int matchingIngredients = ((PlayerModifierScreenHandler)this.menu).blockEntity.inventory.heldStacks.stream().filter(type).mapToInt(ItemStack::getCount).sum();
                int playerMatchingIngredients = ((PlayerModifierScreenHandler)this.menu).player.getInventory().items.stream().filter(type).mapToInt(ItemStack::getCount).sum();
                if (playerMatchingIngredients + matchingIngredients >= count) continue;
                hasResources = false;
                break;
            }
            for (SizedIngredient input : shownCost) {
                Item shownItem = Arrays.stream(input.ingredient().getItems()).findFirst().get().getItem();
                ItemStack shownStack = new ItemStack((ItemLike)shownItem, input.count());
                List<net.minecraft.network.chat.Component> allMatchingItems = Arrays.stream(input.ingredient().getItems()).map(ItemStack::getHoverName).toList();
                ArrayList<Object> combinedList = new ArrayList<Object>();
                combinedList.add(net.minecraft.network.chat.Component.translatable((String)"oritech.text.augment_ingredient_tip").withStyle(new ChatFormatting[]{ChatFormatting.BOLD, ChatFormatting.GRAY}));
                combinedList.addAll(allMatchingItems);
                ItemComponent shown = Components.item((ItemStack)shownStack).showOverlay(true).setTooltipFromStack(false);
                if (allMatchingItems.size() > 1) {
                    shown.tooltip(combinedList);
                } else {
                    shown.setTooltipFromStack(true);
                }
                itemContainer.child((Component)shown.margins(Insets.of((int)2)));
            }
            descriptionPanel.child((Component)itemContainer);
        }
        FlowLayout buttonPanel = Containers.horizontalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.fixed((int)26));
        buttonPanel.margins(Insets.of((int)2, (int)0, (int)4, (int)4));
        buttonPanel.horizontalAlignment(HorizontalAlignment.RIGHT);
        String confirmKey = "text.oritech.begin_research";
        if (operation.equals((Object)PlayerAugments.AugmentApplicatorOperation.ADD)) {
            confirmKey = "text.oritech.install";
        } else if (operation.equals((Object)PlayerAugments.AugmentApplicatorOperation.REMOVE)) {
            confirmKey = "text.oritech.remove";
        } else if (operation.equals((Object)PlayerAugments.AugmentApplicatorOperation.NONE)) {
            confirmKey = "text.oritech.noop";
        }
        ButtonComponent cancelButton = Components.button((net.minecraft.network.chat.Component)net.minecraft.network.chat.Component.translatable((String)"text.oritech.cancel").withColor(BasicMachineScreen.GRAY_TEXT_COLOR), component -> overlay.remove());
        cancelButton.textShadow(false);
        ButtonComponent confirmButton = Components.button((net.minecraft.network.chat.Component)net.minecraft.network.chat.Component.translatable((String)confirmKey).withColor(BasicMachineScreen.GRAY_TEXT_COLOR), component -> {
            this.onAugmentClick(id, operation, true);
            overlay.remove();
        });
        confirmButton.textShadow(false);
        cancelButton.renderer(BasicMachineScreen.ORITECH_BUTTON);
        confirmButton.renderer(BasicMachineScreen.ORITECH_BUTTON);
        if (!(hasResources && hasEnergy || !isCreative)) {
            hasResources = true;
            hasEnergy = true;
            MutableComponent text = net.minecraft.network.chat.Component.literal((String)"[C] ").withStyle(ChatFormatting.DARK_PURPLE).append((net.minecraft.network.chat.Component)net.minecraft.network.chat.Component.translatable((String)confirmKey));
            confirmButton.setMessage((net.minecraft.network.chat.Component)text);
            confirmButton.tooltip((net.minecraft.network.chat.Component)net.minecraft.network.chat.Component.translatable((String)"text.oritech.augmenter_creative_tooltip"));
        }
        if (operation.equals((Object)PlayerAugments.AugmentApplicatorOperation.NONE) || operation.equals((Object)PlayerAugments.AugmentApplicatorOperation.RESEARCH) && (!hasRequiredStation || !hasResources || !hasEnergy) || operation.equals((Object)PlayerAugments.AugmentApplicatorOperation.ADD) && !hasResources) {
            confirmButton.active(false);
        }
        buttonPanel.child(cancelButton.margins(Insets.of((int)2)));
        buttonPanel.child(confirmButton.margins(Insets.of((int)2, (int)2, (int)2, (int)0)));
        panel.child((Component)titleLabel);
        panel.child((Component)descriptionPanel);
        panel.child((Component)buttonPanel);
        overlay.zIndex(100);
        root.child((Component)overlay);
    }

    private void addEnergyBar(FlowLayout panel) {
        int insetSize = 1;
        MutableComponent tooltipText = net.minecraft.network.chat.Component.translatable((String)"tooltip.oritech.energy_indicator", (Object[])new Object[]{10, 50});
        int width = 17;
        int height = 80;
        FlowLayout frame = Containers.horizontalFlow((Sizing)Sizing.fixed((int)(width + insetSize * 2)), (Sizing)Sizing.fixed((int)(height + insetSize * 2)));
        frame.surface(Surface.PANEL_INSET);
        frame.padding(Insets.of((int)insetSize));
        panel.child((Component)frame);
        TextureComponent indicator_background = Components.texture((ResourceLocation)BasicMachineScreen.GUI_COMPONENTS, (int)24, (int)0, (int)24, (int)96, (int)98, (int)96);
        indicator_background.sizing(Sizing.fixed((int)width), Sizing.fixed((int)height));
        this.energyIndicator = Components.texture((ResourceLocation)BasicMachineScreen.GUI_COMPONENTS, (int)0, (int)0, (int)24, (int)96, (int)98, (int)96);
        this.energyIndicator.sizing(Sizing.fixed((int)width), Sizing.fixed((int)height));
        this.energyIndicator.positioning(Positioning.absolute((int)0, (int)0));
        this.energyIndicator.tooltip((net.minecraft.network.chat.Component)tooltipText);
        frame.child((Component)indicator_background).child((Component)this.energyIndicator);
    }

    private static void drawLine(GuiGraphics context, Vector2i from, Vector2i to, int color) {
        if ((double)from.distanceSquared((Vector2ic)to) < 0.1) {
            return;
        }
        PoseStack matrices = context.pose();
        matrices.pushPose();
        Matrix4f pos = matrices.last().pose();
        Vector2f normal = AugmentSelectionScreen.getNormalVector(from, to).normalize();
        Vector2f offset = normal.mul(1.0f);
        float zIndex = 1.1f;
        VertexConsumer buffer = context.bufferSource().getBuffer(RenderType.gui());
        buffer.addVertex(pos, (float)from.x - offset.x, (float)from.y - offset.y, zIndex).setColor(color);
        buffer.addVertex(pos, (float)from.x + offset.x, (float)from.y + offset.y, zIndex).setColor(color);
        buffer.addVertex(pos, (float)to.x + offset.x, (float)to.y + offset.y, zIndex).setColor(color);
        buffer.addVertex(pos, (float)to.x - offset.x, (float)to.y - offset.y, zIndex).setColor(color);
        context.flush();
        matrices.popPose();
    }

    public static String augmentKey(ResourceLocation id) {
        return "oritech.text." + id.getPath().replace('/', '.');
    }

    static {
        dependencyLines = new HashMap();
        shownAugments = new HashMap();
    }

    private static class DraggableScrollContainer<C extends Component>
    extends ScrollContainer<C> {
        protected DraggableScrollContainer(ScrollContainer.ScrollDirection direction, Sizing horizontalSizing, Sizing verticalSizing, C child) {
            super(direction, horizontalSizing, verticalSizing, child);
        }

        public boolean onMouseDrag(double mouseX, double mouseY, double deltaX, double deltaY, int button) {
            boolean inScrollBar = this.isInScrollbar((double)this.x + mouseX, (double)this.y + mouseY);
            double delta = this.direction.choose(deltaX, deltaY);
            double selfSize = (Integer)this.direction.sizeGetter.apply(this) - (Integer)this.direction.insetGetter.apply((Insets)this.padding.get());
            double scalar = (double)this.maxScroll / (selfSize - this.lastScrollbarLength);
            if (!Double.isFinite(scalar)) {
                scalar = 0.0;
            }
            this.scrollBy(delta * (scalar *= -0.5), true, false);
            if (inScrollBar) {
                this.scrollbaring = true;
            }
            return false;
        }

        public void draw(OwoUIDrawContext context, int mouseX, int mouseY, float partialTicks, float delta) {
            super.draw(context, mouseX, mouseY, partialTicks, delta);
            Vector2i offset = new Vector2i((int)(-this.currentScrollPosition), 0).add(this.x, this.y);
            for (Tuple<Vector2i, Vector2i> dependency : dependencyLines.values()) {
                PlayerModifierScreen.drawLine((GuiGraphics)context, new Vector2i((Vector2ic)dependency.getA()).add((Vector2ic)offset), new Vector2i((Vector2ic)dependency.getB()).add((Vector2ic)offset), new Color(0.1f, 0.15f, 0.2f, 1.0f).argb());
            }
        }

        public double getScrollPosition() {
            return this.currentScrollPosition;
        }
    }

    private static final class AugmentUiState {
        private BoxComponent highlight;
        private TextureComponent background;
        private TextureComponent icon;
        private BoxComponent blocker;
        private PlayerAugments.AugmentApplicatorOperation openOp;
        private final FlowLayout parent;

        private AugmentUiState(BoxComponent highlight, TextureComponent background, TextureComponent icon, BoxComponent blocker, PlayerAugments.AugmentApplicatorOperation openOp, FlowLayout parent) {
            this.highlight = highlight;
            this.background = background;
            this.icon = icon;
            this.blocker = blocker;
            this.openOp = openOp;
            this.parent = parent;
        }
    }

    public static class SizedIngredientTooltipComponent
    implements ClientTooltipComponent {
        private final List<SizedIngredient> items;
        private final int size = 16;
        private final int spacing = 3;

        public SizedIngredientTooltipComponent(List<SizedIngredient> items) {
            this.items = items;
        }

        public int getHeight() {
            return 24;
        }

        public int getWidth(Font textRenderer) {
            return 19 * this.items.size();
        }

        public void renderImage(Font textRenderer, int x, int y, GuiGraphics context) {
            context.push();
            for (int i = 0; i < this.items.size(); ++i) {
                SizedIngredient ingredient = this.items.get(i);
                if (ingredient.ingredient().getItems().length == 0) continue;
                ItemStack stack = Arrays.stream(ingredient.ingredient().getItems()).findFirst().get();
                stack = new ItemStack((ItemLike)stack.getItem(), ingredient.count());
                int itemX = x + 19 * i;
                int itemY = y + 3;
                context.renderItem(stack, itemX, itemY);
                if (stack.getCount() <= 1) continue;
                context.pose().translate(0.0f, 0.0f, 200.0f);
                context.drawString(textRenderer, String.valueOf(stack.getCount()), itemX + 19 - 2 - textRenderer.width(String.valueOf(stack.getCount())), itemY + 6 + 3, 0xFFFFFF, true);
            }
            context.pop();
        }
    }

    private static class CustomFlowRootContainer
    extends FlowLayout {
        public static FlowLayout verticalFlow(Sizing horizontalSizing, Sizing verticalSizing) {
            return new CustomFlowRootContainer(horizontalSizing, verticalSizing, FlowLayout.Algorithm.VERTICAL);
        }

        protected CustomFlowRootContainer(Sizing horizontalSizing, Sizing verticalSizing, FlowLayout.Algorithm algorithm) {
            super(horizontalSizing, verticalSizing, algorithm);
        }

        public boolean onMouseDrag(double mouseX, double mouseY, double deltaX, double deltaY, int button) {
            if (main != null) {
                return main.onMouseDrag(mouseX, mouseY, deltaX, deltaY, button);
            }
            return super.onMouseDrag(mouseX, mouseY, deltaX, deltaY, button);
        }
    }
}

