/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.init.compat.jei;

import java.util.List;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.init.BlockContent;
import rearth.oritech.init.recipes.OritechRecipe;
import rearth.oritech.init.recipes.OritechRecipeType;
import rearth.oritech.init.recipes.RecipeContent;

public class OritechJeiParticleCollisionRecipe
implements IRecipeCategory<OritechRecipe> {
    public final OritechRecipeType type = RecipeContent.PARTICLE_COLLISION;
    public final IDrawable icon;
    public final IDrawableAnimated arrow;
    public final IDrawableStatic background;

    public OritechJeiParticleCollisionRecipe(IGuiHelper helper) {
        this.icon = helper.createDrawableItemStack(new ItemStack((ItemLike)BlockContent.ACCELERATOR_CONTROLLER.asItem()));
        this.arrow = helper.createAnimatedRecipeArrow(40);
        this.background = helper.getSlotDrawable();
    }

    @NotNull
    public RecipeType<OritechRecipe> getRecipeType() {
        return RecipeType.create((String)this.type.getIdentifier().getNamespace(), (String)this.type.getIdentifier().getPath(), OritechRecipe.class);
    }

    @NotNull
    public Component getTitle() {
        return Component.translatable((String)("emi.category.oritech." + this.type.getIdentifier().getPath()));
    }

    @Nullable
    public IDrawable getIcon() {
        return this.icon;
    }

    public int getWidth() {
        return 170;
    }

    public int getHeight() {
        return 66;
    }

    public void draw(OritechRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        this.arrow.draw(guiGraphics, 57, 24);
        guiGraphics.drawString(Minecraft.getInstance().font, (Component)Component.translatable((String)"emi.title.oritech.collisionspeed", (Object[])new Object[]{recipe.getTime()}), 2, (int)((double)this.getHeight() * 0.88), 0xFFFFFF);
    }

    public void setRecipe(IRecipeLayoutBuilder builder, OritechRecipe recipe, IFocusGroup focuses) {
        List<Ingredient> inputs = recipe.getInputs();
        ((IRecipeSlotBuilder)builder.addInputSlot(25, 10).addIngredients(inputs.get(0))).setBackground((IDrawable)this.background, -1, -1);
        ((IRecipeSlotBuilder)builder.addInputSlot(25, 33).addIngredients(inputs.get(1))).setBackground((IDrawable)this.background, -1, -1);
        ((IRecipeSlotBuilder)builder.addOutputSlot(90, 24).addItemStack(recipe.getResults().get(0))).setBackground((IDrawable)this.background, -1, -1);
    }
}

