/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.item.other;

import dev.architectury.fluid.FluidStack;
import dev.architectury.hooks.fluid.FluidStackHooks;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluids;
import rearth.oritech.Oritech;
import rearth.oritech.api.fluid.FluidApi;
import rearth.oritech.api.fluid.containers.SimpleItemFluidStorage;

public class SmallFluidTankBlockItem
extends BlockItem
implements FluidApi.ItemProvider {
    public SmallFluidTankBlockItem(Block block, Item.Properties settings) {
        super(block, settings);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        FluidStack data = (FluidStack)stack.getOrDefault(FluidApi.ITEM.getFluidComponent(), (Object)FluidStack.empty());
        if (data.isEmpty()) {
            tooltip.add((Component)Component.translatable((String)"tooltip.oritech.fluid_empty"));
        } else {
            float amount = (float)data.getAmount() / (float)FluidStackHooks.bucketAmount();
            tooltip.add((Component)Component.translatable((String)"tooltip.oritech.fluid_content_tank_tooltip", (Object[])new Object[]{Float.valueOf(amount), FluidStackHooks.getName((FluidStack)data).getString()}).withStyle(ChatFormatting.GRAY));
        }
        super.appendHoverText(stack, context, tooltip, type);
    }

    public Component getName(ItemStack stack) {
        FluidStack content = (FluidStack)stack.getOrDefault(FluidApi.ITEM.getFluidComponent(), (Object)FluidStack.empty());
        if (content.isEmpty()) {
            return super.getName(stack);
        }
        return FluidStackHooks.getName((FluidStack)content).copy().append((Component)Component.literal((String)" ")).append(super.getName(stack));
    }

    @Override
    public FluidApi.SingleSlotStorage getFluidStorage(ItemStack stack) {
        return new SimpleItemFluidStorage((Long)((long)Oritech.CONFIG.portableTankCapacityBuckets() * FluidStackHooks.bucketAmount()), stack);
    }

    public boolean isBarVisible(ItemStack stack) {
        boolean contentEmpty = ((FluidStack)stack.getOrDefault(FluidApi.ITEM.getFluidComponent(), (Object)FluidStack.empty())).isEmpty();
        return !contentEmpty;
    }

    public int getBarColor(ItemStack stack) {
        FluidStack content = (FluidStack)stack.getOrDefault(FluidApi.ITEM.getFluidComponent(), (Object)FluidStack.empty());
        if (content.isEmpty()) {
            return 507391;
        }
        if (content.getFluid().equals(Fluids.LAVA)) {
            return 0xFF8000;
        }
        return FluidStackHooks.getColor((FluidStack)content);
    }

    public int getBarWidth(ItemStack stack) {
        long capacity = (long)Oritech.CONFIG.portableTankCapacityBuckets() * FluidStackHooks.bucketAmount();
        long fillAmount = ((FluidStack)stack.getOrDefault(FluidApi.ITEM.getFluidComponent(), (Object)FluidStack.empty())).getAmount();
        return Math.round((float)fillAmount * 100.0f / (float)capacity * 13.0f) / 100;
    }
}

