/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.item.tools.armor;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import rearth.oritech.Oritech;
import rearth.oritech.api.energy.EnergyApi;
import rearth.oritech.api.energy.containers.SimpleEnergyItemStorage;
import rearth.oritech.item.tools.armor.ExoArmorItem;
import rearth.oritech.item.tools.util.OritechEnergyItem;
import rearth.oritech.util.StackContext;
import rearth.oritech.util.TooltipHelper;

public class BackstorageExoArmorItem
extends ExoArmorItem
implements OritechEnergyItem {
    public BackstorageExoArmorItem(Holder<ArmorMaterial> material, ArmorItem.Type type, Item.Properties settings) {
        super(material, type, settings);
    }

    public void inventoryTick(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        if (world.isClientSide) {
            return;
        }
        int tickPeriod = 10;
        if (world.getGameTime() % (long)tickPeriod != 0L) {
            return;
        }
        boolean isPlayer = entity instanceof Player;
        boolean isEquipped = ((Player)entity).getItemBySlot(EquipmentSlot.CHEST).equals(stack);
        if (isPlayer && isEquipped) {
            this.distributePower((Player)entity, stack, slot);
        }
    }

    private void distributePower(Player player, ItemStack pack, int slot) {
        SimpleEnergyItemStorage packStorage = new SimpleEnergyItemStorage(this.getEnergyMaxInput(pack), this.getEnergyMaxOutput(pack), this.getEnergyCapacity(pack), pack);
        if (packStorage.getAmount() < 10L) {
            return;
        }
        for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
            int finalI;
            StackContext stackRef;
            EnergyApi.EnergyStorage stackStorage;
            ItemStack stack = player.getInventory().getItem(i);
            if (stack.isEmpty() || stack == pack || slot == i || (stackStorage = EnergyApi.ITEM.find(stackRef = new StackContext(stack, arg_0 -> BackstorageExoArmorItem.lambda$distributePower$0(player, finalI = i, arg_0)))) == null || stackStorage.getAmount() >= stackStorage.getCapacity()) continue;
            EnergyApi.transfer(packStorage, stackStorage, Long.MAX_VALUE, false);
        }
    }

    @Override
    public long getEnergyCapacity(ItemStack stack) {
        return Oritech.CONFIG.exoChestplate.energyCapacity();
    }

    @Override
    public long getEnergyMaxInput(ItemStack stack) {
        return Oritech.CONFIG.exoChestplate.chargeSpeed();
    }

    @Override
    public long getEnergyMaxOutput(ItemStack stack) {
        return Oritech.CONFIG.exoChestplate.energyUsage();
    }

    @Override
    public boolean isBarVisible(ItemStack stack) {
        return true;
    }

    public int getBarColor(ItemStack stack) {
        return 0xFF7007;
    }

    public int getBarWidth(ItemStack stack) {
        return Math.round((float)this.getStoredEnergy(stack) * 100.0f / (float)this.getEnergyCapacity(stack) * 13.0f) / 100;
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        super.appendHoverText(stack, context, tooltip, type);
        MutableComponent text = Component.translatable((String)"tooltip.oritech.energy_indicator", (Object[])new Object[]{TooltipHelper.getEnergyText(this.getStoredEnergy(stack)), TooltipHelper.getEnergyText(this.getEnergyCapacity(stack))});
        tooltip.add((Component)text.withStyle(ChatFormatting.GOLD));
    }

    private static /* synthetic */ void lambda$distributePower$0(Player player, int finalI, ItemStack updated) {
        player.getInventory().setItem(finalI, updated);
    }
}

