/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.util;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.function.Predicate;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;

public record SizedIngredient(int count, Ingredient ingredient) implements Predicate<ItemStack>
{
    public static MapCodec<SizedIngredient> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.INT.optionalFieldOf("count", (Object)1).forGetter(SizedIngredient::count), (App)Ingredient.CODEC_NONEMPTY.fieldOf("ingredient").forGetter(SizedIngredient::ingredient)).apply((Applicative)instance, SizedIngredient::new));
    public static StreamCodec<RegistryFriendlyByteBuf, SizedIngredient> PACKET_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, SizedIngredient::count, (StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, SizedIngredient::ingredient, SizedIngredient::new);

    @Override
    public boolean test(ItemStack itemStack) {
        if (itemStack.isEmpty()) {
            return false;
        }
        if (itemStack.getCount() < this.count) {
            return false;
        }
        return this.ingredient.test(itemStack);
    }
}

