/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivetrees.event;

import cy.jdkdigital.productivelib.util.ColorUtil;
import cy.jdkdigital.productivetrees.client.particle.PetalParticle;
import cy.jdkdigital.productivetrees.client.render.block.PollinatedLeavesBlockEntityRenderer;
import cy.jdkdigital.productivetrees.client.render.block.StripperBlockEntityRenderer;
import cy.jdkdigital.productivetrees.client.render.block.TimeTravellerDisplayBlockEntityRenderer;
import cy.jdkdigital.productivetrees.common.block.entity.PollinatedLeavesBlockEntity;
import cy.jdkdigital.productivetrees.inventory.screen.PollenSifterScreen;
import cy.jdkdigital.productivetrees.inventory.screen.SawmillScreen;
import cy.jdkdigital.productivetrees.inventory.screen.StripperScreen;
import cy.jdkdigital.productivetrees.inventory.screen.WoodworkerScreen;
import cy.jdkdigital.productivetrees.registry.ClientRegistration;
import cy.jdkdigital.productivetrees.registry.TreeFinder;
import cy.jdkdigital.productivetrees.registry.TreeRegistrator;
import cy.jdkdigital.productivetrees.util.TreeUtil;
import net.minecraft.client.renderer.blockentity.HangingSignRenderer;
import net.minecraft.client.renderer.blockentity.SignRenderer;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.FoliageColor;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.client.event.RegisterParticleProvidersEvent;

@EventBusSubscriber(modid="productivetrees", value={Dist.CLIENT}, bus=EventBusSubscriber.Bus.MOD)
public class ClientSetupEvents {
    @SubscribeEvent
    public static void registerParticles(RegisterParticleProvidersEvent event) {
        event.registerSpriteSet((ParticleType)ClientRegistration.PETAL_PARTICLES.get(), PetalParticle.Provider::new);
    }

    @SubscribeEvent
    public static void clientSetupEvent(RegisterMenuScreensEvent event) {
        event.register((MenuType)TreeRegistrator.STRIPPER_MENU.get(), StripperScreen::new);
        event.register((MenuType)TreeRegistrator.SAWMILL_MENU.get(), SawmillScreen::new);
        event.register((MenuType)TreeRegistrator.WOOD_WORKER_MENU.get(), WoodworkerScreen::new);
        event.register((MenuType)TreeRegistrator.POLLEN_SIFTER_MENU.get(), PollenSifterScreen::new);
    }

    @SubscribeEvent
    public static void clientSetupEvent(FMLClientSetupEvent event) {
        event.enqueueWork(() -> ItemProperties.register((Item)((Item)TreeRegistrator.FUSTIC.get()), (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"count"), (stack, world, entity, i) -> stack.getCount()));
    }

    @SubscribeEvent
    public static void registerEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerBlockEntityRenderer((BlockEntityType)TreeRegistrator.POLLINATED_LEAVES_BLOCK_ENTITY.get(), PollinatedLeavesBlockEntityRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)TreeRegistrator.STRIPPER_BLOCK_ENTITY.get(), StripperBlockEntityRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)TreeRegistrator.TIME_TRAVELLER_DISPLAY_BLOCK_ENTITY.get(), TimeTravellerDisplayBlockEntityRenderer::new);
        event.registerBlockEntityRenderer(TreeRegistrator.SIGN_BE.get(), SignRenderer::new);
        event.registerBlockEntityRenderer(TreeRegistrator.HANGING_SIGN_BE.get(), HangingSignRenderer::new);
    }

    @SubscribeEvent
    public static void registerItemColors(RegisterColorHandlersEvent.Item event) {
        event.register((stack, tintIndex) -> {
            if (stack.has(TreeRegistrator.POLLEN_BLOCK_COMPONENT)) {
                return TreeUtil.getLeafColor((Block)BuiltInRegistries.BLOCK.get((ResourceLocation)stack.get(TreeRegistrator.POLLEN_BLOCK_COMPONENT)));
            }
            return FoliageColor.getDefaultColor();
        }, new ItemLike[]{(ItemLike)TreeRegistrator.POLLEN.get()});
        TreeFinder.trees.forEach((id, treeObject) -> {
            event.register((stack, tintIndex) -> tintIndex == 0 ? ColorUtil.getCacheColor((String)treeObject.getLeafColor()) : (treeObject.hasFruit() && tintIndex == 2 ? ColorUtil.getCacheColor((String)treeObject.getFruit().ripeColor()) : ColorUtil.getCacheColor((String)treeObject.getLogColor())), new ItemLike[]{TreeUtil.getBlock(treeObject.getId(), "_sapling"), TreeUtil.getBlock(treeObject.getId(), "_potted_sapling")});
            if (ModList.get().isLoaded("productivebees") && treeObject.getStyle().hiveStyle() != null && treeObject.tintHives()) {
                event.register((stack, tintIndex) -> ColorUtil.getCacheColor((String)treeObject.getPlankColor()), new ItemLike[]{(ItemLike)BuiltInRegistries.BLOCK.get(id.withPath(p -> "advanced_" + p + "_beehive")), (ItemLike)BuiltInRegistries.BLOCK.get(id.withPath(p -> "expansion_box_" + p))});
            }
        });
    }

    @SubscribeEvent
    public static void registerBlockColors(RegisterColorHandlersEvent.Block event) {
        event.register((blockState, lightReader, pos, tintIndex) -> {
            BlockEntity be;
            if (lightReader != null && pos != null && (be = lightReader.getBlockEntity(pos)) instanceof PollinatedLeavesBlockEntity) {
                PollinatedLeavesBlockEntity pollinatedLeavesBlockEntity = (PollinatedLeavesBlockEntity)be;
                int colorA = TreeUtil.getLeafColor(pollinatedLeavesBlockEntity.getLeafA(), lightReader, pos);
                int colorB = TreeUtil.getLeafColor(pollinatedLeavesBlockEntity.getLeafB(), lightReader, pos);
                return ColorUtil.blend((int)colorA, (int)colorB, (float)0.5f);
            }
            return FoliageColor.getDefaultColor();
        }, new Block[]{(Block)TreeRegistrator.POLLINATED_LEAVES.get()});
        TreeFinder.trees.forEach((id, treeObject) -> {
            event.register((blockState, lightReader, pos, tintIndex) -> tintIndex == 0 ? ColorUtil.getCacheColor((String)treeObject.getLeafColor()) : (treeObject.hasFruit() && tintIndex == 2 ? ColorUtil.getCacheColor((String)treeObject.getFruit().ripeColor()) : ColorUtil.getCacheColor((String)treeObject.getLogColor())), new Block[]{TreeUtil.getBlock(treeObject.getId(), "_sapling"), TreeUtil.getBlock(treeObject.getId(), "_potted_sapling")});
            if (ModList.get().isLoaded("productivebees") && treeObject.getStyle().hiveStyle() != null && treeObject.tintHives()) {
                event.register((blockState, lightReader, pos, tintIndex) -> ColorUtil.getCacheColor((String)treeObject.getPlankColor()), new Block[]{(Block)BuiltInRegistries.BLOCK.get(id.withPath(p -> "advanced_" + p + "_beehive")), (Block)BuiltInRegistries.BLOCK.get(id.withPath(p -> "expansion_box_" + p))});
            }
        });
    }
}

