/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivetrees.inventory;

import cy.jdkdigital.productivelib.common.block.entity.InventoryHandlerHelper;
import cy.jdkdigital.productivelib.container.AbstractContainer;
import cy.jdkdigital.productivelib.container.ManualSlotItemHandler;
import cy.jdkdigital.productivetrees.common.block.Stripper;
import cy.jdkdigital.productivetrees.common.block.entity.StripperBlockEntity;
import cy.jdkdigital.productivetrees.registry.TreeRegistrator;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.items.IItemHandler;

public class StripperContainer
extends AbstractContainer {
    public final StripperBlockEntity blockEntity;
    private final ContainerLevelAccess canInteractWithCallable;

    public StripperContainer(int windowId, Inventory playerInventory, FriendlyByteBuf data) {
        this(windowId, playerInventory, StripperContainer.getTileEntity(playerInventory, data));
    }

    public StripperContainer(int windowId, Inventory playerInventory, StripperBlockEntity blockEntity) {
        super((MenuType)TreeRegistrator.STRIPPER_MENU.get(), windowId);
        this.blockEntity = blockEntity;
        this.canInteractWithCallable = ContainerLevelAccess.create((Level)blockEntity.getLevel(), (BlockPos)blockEntity.getBlockPos());
        this.addSlot((Slot)new ManualSlotItemHandler((InventoryHandlerHelper.BlockEntityItemStackHandler)this.blockEntity.inventoryHandler, StripperBlockEntity.SLOT_IN, 31, 25));
        this.addSlot((Slot)new ManualSlotItemHandler((InventoryHandlerHelper.BlockEntityItemStackHandler)this.blockEntity.inventoryHandler, StripperBlockEntity.SLOT_AXE, 31, 44));
        this.addSlot((Slot)new ManualSlotItemHandler((InventoryHandlerHelper.BlockEntityItemStackHandler)this.blockEntity.inventoryHandler, StripperBlockEntity.SLOT_OUT, 103, 25));
        this.addSlot((Slot)new ManualSlotItemHandler((InventoryHandlerHelper.BlockEntityItemStackHandler)this.blockEntity.inventoryHandler, StripperBlockEntity.SLOT_BARK, 103, 44));
        this.addSlotBox((IItemHandler)this.blockEntity.getUpgradeHandler(), 0, 165, 8, 1, 18, 4, 18);
        this.layoutPlayerInventorySlots(playerInventory, 0, -5, 84);
    }

    private static StripperBlockEntity getTileEntity(Inventory playerInventory, FriendlyByteBuf data) {
        Objects.requireNonNull(playerInventory, "playerInventory cannot be null!");
        Objects.requireNonNull(data, "data cannot be null!");
        BlockEntity tileAtPos = playerInventory.player.level().getBlockEntity(data.readBlockPos());
        if (tileAtPos instanceof StripperBlockEntity) {
            return (StripperBlockEntity)tileAtPos;
        }
        throw new IllegalStateException("Block entity is not correct! " + String.valueOf(tileAtPos));
    }

    public boolean stillValid(@Nonnull Player player) {
        return (Boolean)this.canInteractWithCallable.evaluate((world, pos) -> world.getBlockState(pos).getBlock() instanceof Stripper && player.distanceToSqr((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5) <= 64.0, (Object)true);
    }

    protected BlockEntity getBlockEntity() {
        return this.blockEntity;
    }
}

