/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.catjammies;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.JukeboxBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;

@FunctionalInterface
public interface IJammyDetector {
    public static final List<IJammyDetector> DETECTORS = new ArrayList<IJammyDetector>();
    public static final IJammyDetector MUSIC = (level, entity) -> {
        int jamDistance = 5;
        int jamAmount = 0;
        AABB aabb = new AABB(entity.getX() - (double)jamDistance, entity.getY() - (double)jamDistance, entity.getZ() - (double)jamDistance, entity.getX() + (double)jamDistance, entity.getY() + (double)jamDistance, entity.getZ() + (double)jamDistance);
        for (BlockPos blockPos : IJammyDetector.getBlockPosInAABB(aabb)) {
            if (!(entity.level().getBlockState(blockPos).getBlock() instanceof JukeboxBlock) || !((Boolean)entity.level().getBlockState(blockPos).getValue((Property)JukeboxBlock.HAS_RECORD)).booleanValue()) continue;
            ++jamAmount;
        }
        return jamAmount;
    };
    public static final IJammyDetector ME = (level, entity) -> {
        int jamDistance = 10;
        AABB aabb = new AABB(entity.getX() - (double)jamDistance, entity.getY() - (double)jamDistance, entity.getZ() - (double)jamDistance, entity.getX() + (double)jamDistance, entity.getY() + (double)jamDistance, entity.getZ() + (double)jamDistance);
        return level.getEntitiesOfClass(Player.class, aabb, playerEntity -> playerEntity.getDisplayName().getString().equals("Buuz135")).size();
    };

    public int detect(Level var1, Cat var2);

    public static List<BlockPos> getBlockPosInAABB(AABB aabb) {
        ArrayList<BlockPos> blocks = new ArrayList<BlockPos>();
        for (double y = aabb.minY; y < aabb.maxY; y += 1.0) {
            for (double x = aabb.minX; x < aabb.maxX; x += 1.0) {
                for (double z = aabb.minZ; z < aabb.maxZ; z += 1.0) {
                    blocks.add(BlockPos.containing((double)x, (double)y, (double)z));
                }
            }
        }
        return blocks;
    }
}

