/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.effects.exchange;

import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.dataattachments.mahou.IMahou;
import stepsword.mahoutsukai.mana.PlayerManaManager;
import stepsword.mahoutsukai.util.Utils;

public class DamageExchangeSpellEffect {
    public static boolean addProtectionToUser(Player player) {
        IMahou mahou;
        if (player != null && (mahou = Utils.getPlayerMahou(player)) != null) {
            mahou.setDamageExchangeUses(Math.min(MTConfig.DAMAGE_EXCHANGE_CAP, mahou.getDamageExchangeUses() + 5));
            if (player instanceof ServerPlayer) {
                PlayerManaManager.updateClientMahou((ServerPlayer)player, mahou);
            }
            return true;
        }
        return false;
    }

    public static void damageExchangeLivingHurt(LivingIncomingDamageEvent event) {
        int protD;
        Player player;
        IMahou mahou;
        if (!event.getEntity().level().isClientSide && event.getEntity() instanceof Player && (mahou = Utils.getPlayerMahou(player = (Player)event.getEntity())) != null && (protD = mahou.getDamageExchangeUses()) > 0 && !Utils.damageSourceAny(event.getSource(), DamageTypes.FELL_OUT_OF_WORLD, DamageTypes.GENERIC_KILL)) {
            if (MTConfig.DAMAGE_EXCHANGE_MANA_GAIN > 0) {
                mahou.setStoredMana(Math.max(0, Math.min(mahou.getStoredMana() + MTConfig.DAMAGE_EXCHANGE_MANA_GAIN * (int)Math.floor(event.getAmount()), mahou.getMaxMana())));
                event.setAmount((float)MTConfig.DAMAGE_EXCHANGE_REDUCE_TO);
                mahou.setDamageExchangeUses(protD - 1);
                if (player instanceof ServerPlayer) {
                    PlayerManaManager.updateClientMahou((ServerPlayer)player, mahou);
                }
            } else if (MTConfig.DAMAGE_EXCHANGE_MANA_GAIN < 0 && PlayerManaManager.drainMana(player, MTConfig.DAMAGE_EXCHANGE_MANA_GAIN, false, false) == MTConfig.DAMAGE_EXCHANGE_MANA_GAIN) {
                event.setAmount((float)MTConfig.DAMAGE_EXCHANGE_REDUCE_TO);
                mahou.setDamageExchangeUses(protD - 1);
                if (player instanceof ServerPlayer) {
                    PlayerManaManager.updateClientMahou((ServerPlayer)player, mahou);
                }
            }
        }
    }
}

