/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.effects.mystic;

import java.util.List;
import java.util.UUID;
import net.minecraft.core.Holder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.event.entity.living.MobEffectEvent;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.dataattachments.mahou.IMahou;
import stepsword.mahoutsukai.item.rulebreaker.ProbabilityAlterRandom;
import stepsword.mahoutsukai.potion.ProbabilityAlterPotion;
import stepsword.mahoutsukai.util.EffectUtil;
import stepsword.mahoutsukai.util.Utils;

public class DamageReplicationSpellEffect {
    public static int range = MTConfig.GLOBAL_LOOK_RANGE;

    public static boolean damageReplication(Player user) {
        IMahou mahou;
        Entity target = Utils.selectEntityNearCursor(user, MTConfig.GLOBAL_LOOK_RANGE, user.level(), a -> Utils.getPredicate(Utils.MAHOU_SELECTION.SCROLL_DAMAGE_REPLICATION, a, user), Utils.nearAllowed(Utils.MAHOU_SELECTION.SCROLL_DAMAGE_REPLICATION));
        if (target instanceof LivingEntity && (mahou = Utils.getPlayerMahou(user)) != null) {
            mahou.setDamageReplicationTarget(target.getUUID());
            return true;
        }
        return false;
    }

    public static void damageReplicationLivingDamage(LivingIncomingDamageEvent event) {
        LivingEntity entity = event.getEntity();
        if (!entity.level().isClientSide) {
            Entity target = DamageReplicationSpellEffect.findTarget((Entity)entity);
            Entity targettarget = null;
            if (target != null) {
                targettarget = DamageReplicationSpellEffect.findTarget(target);
            }
            if (target instanceof LivingEntity) {
                IMahou mahou;
                if (targettarget == entity && target instanceof Player && (mahou = Utils.getPlayerMahou((Player)target)) != null) {
                    mahou.setDamageReplicationTarget(null);
                }
                target.hurt(event.getSource(), event.getAmount());
                if (targettarget == entity && target instanceof Player && (mahou = Utils.getPlayerMahou((Player)target)) != null) {
                    mahou.setDamageReplicationTarget(targettarget.getUUID());
                }
            }
        }
    }

    public static Entity findTarget(Entity entity) {
        UUID enemy;
        Player player;
        IMahou mahou;
        Player target = null;
        if (!entity.level().isClientSide && entity instanceof Player && (mahou = Utils.getPlayerMahou(player = (Player)entity)) != null && (enemy = mahou.getDamageReplicationTarget()) != null) {
            Player enemyplayer = player.level().getPlayerByUUID(enemy);
            if (enemyplayer != null) {
                target = enemyplayer;
            } else {
                List lst = player.level().getEntitiesOfClass(LivingEntity.class, new AABB(player.getX() - (double)(range / 2), player.getY() - (double)(range / 2), player.getZ() - (double)(range / 2), player.getX() + (double)(range / 2), player.getY() + (double)(range / 2), player.getZ() + (double)(range / 2)));
                for (int i = 0; i < lst.size(); ++i) {
                    if (!enemy.equals(((LivingEntity)lst.get(i)).getUUID())) continue;
                    target = (Entity)lst.get(i);
                    break;
                }
            }
        }
        return target;
    }

    public static void damageReplicationLivingDeath(Entity entity) {
        Player player;
        IMahou mahou;
        if (entity instanceof Player && !entity.level().isClientSide && (mahou = Utils.getPlayerMahou(player = (Player)entity)) != null && mahou.getDamageReplicationTarget() != null) {
            mahou.setDamageReplicationTarget(null);
        }
    }

    public static void damageReplicationPotionAdded(MobEffectEvent.Added event) {
        LivingEntity entity = event.getEntity();
        if (!entity.level().isClientSide) {
            Entity target = DamageReplicationSpellEffect.findTarget((Entity)entity);
            Entity targettarget = null;
            if (target != null) {
                targettarget = DamageReplicationSpellEffect.findTarget(target);
            }
            if (target instanceof LivingEntity) {
                IMahou mahou;
                if (targettarget == entity && target instanceof Player) {
                    mahou = Utils.getPlayerMahou((Player)target);
                    mahou.setDamageReplicationTarget(null);
                }
                EffectUtil.buff((LivingEntity)target, (Holder<MobEffect>)event.getEffectInstance().getEffect(), false, event.getEffectInstance().getDuration(), event.getEffectInstance().getAmplifier());
                if (targettarget == entity && target instanceof Player) {
                    mahou = Utils.getPlayerMahou((Player)target);
                    mahou.setDamageReplicationTarget(targettarget.getUUID());
                }
                if (event.getEffectInstance().getEffect().value() instanceof ProbabilityAlterPotion && entity.random instanceof ProbabilityAlterRandom) {
                    int d = ((ProbabilityAlterRandom)entity.random).designation;
                    int m = ((ProbabilityAlterRandom)entity.random).modulus;
                    ProbabilityAlterPotion.createProbabilityAlter((LivingEntity)target, d, m);
                }
            }
        }
    }
}

