/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.entity.butterfly;

import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class SerializableBlockPlace {
    public BlockPos loc;
    public BlockState state;
    public ItemStack stack;

    public CompoundTag write(Level level) {
        CompoundTag ret = new CompoundTag();
        if (this.loc != null) {
            ret.putInt("locx", this.loc.getX());
            ret.putInt("locy", this.loc.getY());
            ret.putInt("locz", this.loc.getZ());
        }
        if (this.state != null) {
            ret.put("state", (Tag)NbtUtils.writeBlockState((BlockState)this.state));
        }
        if (this.stack != null) {
            ret.put("stack", this.stack.save((HolderLookup.Provider)level.registryAccess(), (Tag)new CompoundTag()));
        }
        return ret;
    }

    public void read(Level level, CompoundTag nbt) {
        if (nbt.contains("locx") && nbt.contains("locy") && nbt.contains("locz")) {
            this.loc = new BlockPos(nbt.getInt("locx"), nbt.getInt("locy"), nbt.getInt("locz"));
        }
        if (nbt.contains("state")) {
            this.state = NbtUtils.readBlockState((HolderGetter)level.holderLookup(Registries.BLOCK), (CompoundTag)nbt.getCompound("state"));
        }
        if (nbt.contains("stack")) {
            this.stack = ItemStack.parse((HolderLookup.Provider)level.registryAccess(), (Tag)nbt.getCompound("stack")).orElse(ItemStack.EMPTY);
        }
    }
}

