/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.entity.fae;

import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.phys.Vec3;
import stepsword.mahoutsukai.util.Utils;

public class FaeAIWander
extends Goal {
    protected final PathfinderMob entity;
    protected double x;
    protected double y;
    protected double z;
    public int m = 100;
    protected final double speed;
    protected int executionChance;
    protected boolean mustUpdate;

    public FaeAIWander(PathfinderMob creatureIn, double speedIn) {
        this(creatureIn, speedIn, 120);
    }

    public FaeAIWander(PathfinderMob creatureIn, double speedIn, int chance) {
        this.entity = creatureIn;
        this.speed = speedIn;
        this.executionChance = chance;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean canUse() {
        if (!this.mustUpdate && this.m < 100) {
            return true;
        }
        Vec3 Vec32 = null;
        Vec32 = this.getPosition();
        if (Vec32 == null) {
            return false;
        }
        this.x = Vec32.x;
        this.y = Vec32.y;
        this.z = Vec32.z;
        this.mustUpdate = false;
        if (this.m > 100) {
            this.m = 0;
        }
        return true;
    }

    @Nullable
    protected Vec3 getPosition() {
        int r = 10;
        int r2 = 10;
        int yr = 7;
        int p = this.entity.getRandom().nextInt(4) - 2;
        int p2 = this.entity.getRandom().nextInt(4) - 2;
        int p3 = this.entity.getRandom().nextInt(4) - 2;
        if (this.entity.getRandom().nextBoolean()) {
            r = -r;
        }
        if (this.entity.getRandom().nextBoolean()) {
            r2 = -r2;
        }
        return this.entity.position().add((double)(p + r), (double)p3, (double)(p2 + r2));
    }

    public void tick() {
        float f = 0.01f;
        Vec3 motion = this.entity.getDeltaMovement();
        ++this.m;
        double motionX = motion.x;
        double motionY = motion.y;
        double motionZ = motion.z;
        if (Utils.isBlockAir(this.entity.level(), this.entity.blockPosition().below()) && Math.random() > 0.5 && Math.random() > 0.6) {
            motionY += (double)f;
        }
        this.entity.setDeltaMovement(motionX, motionY, motionZ);
    }

    public boolean canContinueToUse() {
        return !this.entity.getNavigation().isDone();
    }

    public void start() {
        this.entity.getNavigation().moveTo(this.x, this.y, this.z, this.speed);
    }

    public void makeUpdate() {
        this.mustUpdate = true;
    }

    public void setExecutionChance(int newchance) {
        this.executionChance = newchance;
    }
}

