/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.entity.mahoujin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.client.renderer.EffectInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import stepsword.mahoutsukai.block.ModBlocks;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.dataattachments.mahou.IMahou;
import stepsword.mahoutsukai.entity.ModEntities;
import stepsword.mahoutsukai.entity.butterfly.SafeFakePlayer;
import stepsword.mahoutsukai.handlers.ServerHandler;
import stepsword.mahoutsukai.item.mysticcode.MysticCode;
import stepsword.mahoutsukai.item.spells.secret.FallenDownSpellScroll;
import stepsword.mahoutsukai.mana.PlayerManaManager;
import stepsword.mahoutsukai.tile.exchange.ContractMahoujinTileEntity;
import stepsword.mahoutsukai.util.EffectUtil;
import stepsword.mahoutsukai.util.Utils;

public class FallenDownBeamEntity
extends Entity {
    Player player;
    public ArrayList<String> waterbased;
    public static final String entityName = "fallen_down_beam_entity";
    private static final String TAG_LIFE = "MAHOUTSUKAI_LIFE";
    private static final String TAG_CASTER = "MAHOUTSUKAI_CASTER";
    private static final String TAG_FIRED = "MAHOUTSUKAI_FIRED";
    private static final EntityDataAccessor<Integer> LIFE = SynchedEntityData.defineId(FallenDownBeamEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Optional<UUID>> CASTER_UUID = SynchedEntityData.defineId(FallenDownBeamEntity.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_UUID);
    private static final EntityDataAccessor<Boolean> FIRED = SynchedEntityData.defineId(FallenDownBeamEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public ArrayList<EffectInstance> effects = new ArrayList();
    public float damage = 0.0f;

    public FallenDownBeamEntity(EntityType entityEntityType, Level world) {
        super(entityEntityType, world);
    }

    public FallenDownBeamEntity(Level world) {
        super((EntityType)ModEntities.FALLEN_DOWN_BEAM.get(), world);
        this.noCulling = true;
    }

    public FallenDownBeamEntity(Level world, LivingEntity caster) {
        this(world);
        this.setCasterUUID(caster.getUUID());
        this.waterbased = new ArrayList<String>(Arrays.asList(Utils.getRegistryName(Blocks.SNOW, this.level()), Utils.getRegistryName(Blocks.WATER, this.level()), Utils.getRegistryName((Block)ModBlocks.murkyFluid.get(), this.level())));
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(LIFE, (Object)0);
        builder.define(CASTER_UUID, Optional.empty());
        builder.define(FIRED, (Object)false);
    }

    protected void readAdditionalSaveData(CompoundTag compound) {
        this.setLife(compound.getInt(TAG_LIFE));
        this.setFired(compound.getBoolean(TAG_FIRED));
        if (compound.hasUUID(TAG_CASTER)) {
            this.setCasterUUID(compound.getUUID(TAG_CASTER));
        }
    }

    protected void addAdditionalSaveData(CompoundTag compound) {
        compound.putInt(TAG_LIFE, this.getLife());
        compound.putBoolean(TAG_FIRED, this.getFired());
        if (this.getCasterUUID() != null) {
            compound.putUUID(TAG_CASTER, this.getCasterUUID());
        }
    }

    public float getGrowingLife() {
        return 50.0f;
    }

    public double getCurrentRadius() {
        return Math.max(0.0, Math.min((double)MTConfig.FALLEN_DOWN_RADIUS, (double)((float)this.getLife() - this.getGrowingLife()) * 0.12));
    }

    public void tick() {
        double radius = this.getCurrentRadius();
        if (!this.level().isClientSide && ServerHandler.tickCounter % 4L == 0L) {
            ServerPlayer caster = null;
            if (this.level().getServer() != null) {
                caster = this.level().getServer().getPlayerList().getPlayer(this.getCasterUUID());
            }
            int mana = MTConfig.FALLEN_DOWN_MANA_PER_TICK;
            if (caster == null || !(caster.getUseItem().getItem() instanceof FallenDownSpellScroll) && !(caster.getUseItem().getItem() instanceof MysticCode)) {
                this.discard();
            }
            if (caster == null) {
                this.discard();
                return;
            }
            if (PlayerManaManager.drainMana((Player)caster, mana, false, false, true, false) == mana && this.getLife() > 20) {
                AABB aabb = new AABB((double)this.blockPosition().getX() - radius, 0.0, (double)this.blockPosition().getZ() - radius, (double)this.blockPosition().getX() + radius, 255.0, (double)this.blockPosition().getZ() + radius);
                List lst = this.level().getEntities((Entity)this, aabb, a -> a instanceof LivingEntity && !ContractMahoujinTileEntity.isImmuneToSpell(this.level(), this.getCasterUUID(), a));
                float damage = (float)MTConfig.FALLEN_DOWN_BEAM_DAMAGE;
                IMahou mahou = Utils.getPlayerMahou((Player)caster);
                if (mahou != null) {
                    damage = (float)((double)damage + (double)mahou.getMaxMana() * MTConfig.FALLEN_DOWN_BEAM_MANA_SCALED_DAMAGE);
                }
                for (Entity e : lst) {
                    float extra = 0.0f;
                    if (e instanceof LivingEntity) {
                        extra = (float)((double)((LivingEntity)e).getHealth() * MTConfig.FALLEN_DOWN_BEAM_TARGET_HEALTH_PERCENTAGE_DAMAGE);
                    }
                    e.hurt(e.damageSources().onFire(), damage + extra);
                }
                ArrayList<BlockPos> blocksBurn = new ArrayList<BlockPos>();
                if (radius > 0.0) {
                    for (double i = -radius - 2.0; i < radius + 2.0; i += 1.0) {
                        for (double j = -radius - 2.0; j < radius + 2.0; j += 1.0) {
                            for (int y = this.level().getMinBuildHeight(); y < this.level().getMaxBuildHeight(); ++y) {
                                if (!(i * i + j * j < (radius + 1.0) * (radius + 1.0))) continue;
                                BlockPos pos = this.blockPosition().offset((int)i, y, (int)j).offset(0, -this.blockPosition().getY(), 0);
                                BlockState bs = this.level().getBlockState(pos);
                                if (!bs.isFlammable((BlockGetter)this.level(), pos, Direction.UP) && this.getBlocksTransform(Utils.getRegistryKey(bs.getBlock(), this.level())) == null) continue;
                                blocksBurn.add(pos);
                            }
                        }
                    }
                }
                this.fallenDown(blocksBurn, (Player)caster, (ServerLevel)this.level(), "", false, false);
            }
        }
        this.setLife(this.getLife() + 1);
    }

    public void fallenDown(List<BlockPos> affected, Player caster, ServerLevel world, String name, boolean drop, boolean fall) {
        if (caster == null && this.player == null) {
            this.player = new SafeFakePlayer(world, name);
        } else if (caster != null) {
            this.player = caster;
        }
        Collections.shuffle(affected);
        EffectUtil.tryFakeExplosion(affected, (Entity)this.player, this.player, name, drop, new ArrayList<Entity>(), this.player.position(), MTConfig.FALLEN_DOWN_BLOCK_BREAK_PER_TICK, (bs, e, d, p) -> {
            boolean ret = false;
            if (FallenDownBeamEntity.okToBreak(bs, this.player.level(), p)) {
                Block b = this.getBlocksTransform(Utils.getRegistryKey(bs.getBlock(), this.player.level()));
                if (b != null) {
                    world.setBlockAndUpdate(p, b.defaultBlockState());
                }
                if (Math.random() < 0.04 && world.isEmptyBlock(p.above())) {
                    world.setBlockAndUpdate(p.above(), Blocks.FIRE.defaultBlockState());
                }
                if (this.waterbased == null) {
                    this.waterbased = new ArrayList<String>(Arrays.asList(Utils.getRegistryName(Blocks.SNOW, this.level()), Utils.getRegistryName(Blocks.WATER, this.level()), Utils.getRegistryName((Block)ModBlocks.murkyFluid.get(), this.level())));
                }
                if (this.waterbased.contains(Utils.getRegistryName(bs.getBlock(), this.level())) || world.getBlockState(p).getFluidState().isSource()) {
                    if (world.random.nextFloat() > 0.8f) {
                        world.playSound(null, p, SoundEvents.LAVA_EXTINGUISH, SoundSource.BLOCKS, 0.5f, 2.6f + (world.random.nextFloat() - world.random.nextFloat()) * 0.8f);
                    }
                    if (world.random.nextFloat() > 0.2f) {
                        // empty if block
                    }
                }
                ret = true;
            }
            return ret;
        });
    }

    public Block getBlocksTransform(ResourceLocation loc) {
        List<? extends String> inblocks = MTConfig.FALLEN_DOWN_BEAM_IN;
        List<? extends String> outblocks = MTConfig.FALLEN_DOWN_BEAM_OUT;
        String m = loc.toString();
        int index = inblocks.indexOf(m);
        Block b = null;
        if (index >= 0 && index < outblocks.size()) {
            b = Utils.getBlockFromRegistryName(outblocks.get(index));
        } else {
            index = inblocks.indexOf(loc.getNamespace());
            if (index >= 0 && index < outblocks.size()) {
                b = Utils.getBlockFromRegistryName(outblocks.get(index));
            }
        }
        if (b != null && Utils.getRegistryKey(b, this.level()) != null && Utils.getRegistryKey(b, this.level()).equals((Object)loc)) {
            return null;
        }
        return b;
    }

    public static boolean okToBreak(BlockState bs, Level w, BlockPos p) {
        return !EffectUtil.unchangableBlock(bs.getBlock()) && !bs.isAir() && w.getBlockEntity(p) == null;
    }

    public int getLife() {
        return (Integer)this.entityData.get(LIFE);
    }

    public void setLife(int l) {
        this.entityData.set(LIFE, (Object)l);
    }

    public UUID getCasterUUID() {
        return ((Optional)this.entityData.get(CASTER_UUID)).orElse(null);
    }

    public void setCasterUUID(UUID uuid) {
        this.entityData.set(CASTER_UUID, Optional.of(uuid));
    }

    public boolean getFired() {
        return (Boolean)this.entityData.get(FIRED);
    }

    public void setFired(boolean f) {
        this.entityData.set(FIRED, (Object)f);
    }
}

