/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.entity.mahoujin;

import com.google.common.primitives.Floats;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.EffectInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import stepsword.mahoutsukai.MahouTsukaiMod;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.entity.ModEntities;
import stepsword.mahoutsukai.entity.mahoujin.GunEntity;
import stepsword.mahoutsukai.item.nobu.Nobu;
import stepsword.mahoutsukai.networking.PacketHandler;
import stepsword.mahoutsukai.networking.SparkExplosionPacket;
import stepsword.mahoutsukai.tile.exchange.ContractMahoujinTileEntity;
import stepsword.mahoutsukai.util.EffectUtil;
import stepsword.mahoutsukai.util.Utils;

public class GunBeamProjectileEntity
extends Entity {
    public static final String entityName = "beam_projectile_entity";
    private static final String TAG_LIFE = "MAHOUTSUKAI_LIFE";
    private static final String TAG_CASTER = "MAHOUTSUKAI_CASTER";
    private static final String TAG_FIRED = "MAHOUTSUKAI_FIRED";
    private static final String TAG_ROTATION_YAW = "MAHOUTSUKAI_ROTATION_YAW";
    private static final String TAG_ROTATION_ROLL = "MAHOUTSUKAI_ROTATION_ROLL";
    private static final String TAG_ROTATION_PITCH = "MAHOUTSUKAI_ROTATION_PITCH";
    private static final String TAG_TARGET = "MAHOUTSUKAI_TARGET";
    private static final String TAG_COLOR_R = "MAHOUTSUKAI_COLOR_R";
    private static final String TAG_COLOR_G = "MAHOUTSUKAI_COLOR_G";
    private static final String TAG_COLOR_B = "MAHOUTSUKAI_COLOR_B";
    private static final String TAG_COLOR_R2 = "MAHOUTSUKAI_COLOR_R2";
    private static final String TAG_COLOR_G2 = "MAHOUTSUKAI_COLOR_G2";
    private static final String TAG_COLOR_B2 = "MAHOUTSUKAI_COLOR_B2";
    private static final String TAG_COLOR_A = "MAHOUTSUKAI_COLOR_A";
    private static final String TAG_COLOR_A2 = "MAHOUTSUKAI_COLOR_A2";
    private static final String TAG_RADIUS = "MAHOUTSUKAI_RADIUS";
    private static final String TAG_LENGTH = "MAHOUTSUKAI_LENGTH";
    private static final EntityDataAccessor<Float> ROTATION_YAW = SynchedEntityData.defineId(GunBeamProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> ROTATION_ROLL = SynchedEntityData.defineId(GunBeamProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> ROTATION_PITCH = SynchedEntityData.defineId(GunBeamProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Integer> TARGET = SynchedEntityData.defineId(GunBeamProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> LIFE = SynchedEntityData.defineId(GunBeamProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Optional<UUID>> CASTER_UUID = SynchedEntityData.defineId(GunBeamProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_UUID);
    private static final EntityDataAccessor<Boolean> FIRED = SynchedEntityData.defineId(GunBeamProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Float> COLOR_R = SynchedEntityData.defineId(GunBeamProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> COLOR_G = SynchedEntityData.defineId(GunBeamProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> COLOR_B = SynchedEntityData.defineId(GunBeamProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> COLOR_R2 = SynchedEntityData.defineId(GunBeamProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> COLOR_G2 = SynchedEntityData.defineId(GunBeamProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> COLOR_B2 = SynchedEntityData.defineId(GunBeamProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> COLOR_A = SynchedEntityData.defineId(GunBeamProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> COLOR_A2 = SynchedEntityData.defineId(GunBeamProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> RADIUS = SynchedEntityData.defineId(GunBeamProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> LENGTH = SynchedEntityData.defineId(GunBeamProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> SPEED = SynchedEntityData.defineId(GunBeamProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    public ArrayList<EffectInstance> effects = new ArrayList();
    public int ticksSinceFired = 0;
    public long timeCreated = -1L;
    public int hitCD = 5;
    boolean hit = false;
    public boolean autonomous = false;
    public GunEntity owner = null;

    public GunBeamProjectileEntity(EntityType entityEntityType, Level world) {
        super(entityEntityType, world);
    }

    public GunBeamProjectileEntity(Level world) {
        super((EntityType)ModEntities.GUN_BEAM_PROJECTILE.get(), world);
        this.noCulling = true;
    }

    public GunBeamProjectileEntity(Level world, UUID caster, float r, float g, float b, float a, float r2, float g2, float b2, float a2, float radius, float length, int targetID) {
        this(world);
        this.setCasterUUID(caster);
        this.setColor(r, g, b, a, r2, g2, b2, a2);
        this.setRadius(radius);
        this.setLength(length);
        this.setTarget(targetID);
    }

    public void setColor(float r, float g, float b, float a, float r2, float g2, float b2, float a2) {
        this.entityData.set(COLOR_R, (Object)Float.valueOf(r));
        this.entityData.set(COLOR_G, (Object)Float.valueOf(g));
        this.entityData.set(COLOR_B, (Object)Float.valueOf(b));
        this.entityData.set(COLOR_R2, (Object)Float.valueOf(r2));
        this.entityData.set(COLOR_G2, (Object)Float.valueOf(g2));
        this.entityData.set(COLOR_B2, (Object)Float.valueOf(b2));
        this.entityData.set(COLOR_A, (Object)Float.valueOf(a));
        this.entityData.set(COLOR_A2, (Object)Float.valueOf(a2));
    }

    public float[] getColor() {
        return new float[]{((Float)this.entityData.get(COLOR_R)).floatValue(), ((Float)this.entityData.get(COLOR_G)).floatValue(), ((Float)this.entityData.get(COLOR_B)).floatValue(), ((Float)this.entityData.get(COLOR_A)).floatValue(), ((Float)this.entityData.get(COLOR_R2)).floatValue(), ((Float)this.entityData.get(COLOR_G2)).floatValue(), ((Float)this.entityData.get(COLOR_B2)).floatValue(), ((Float)this.entityData.get(COLOR_A2)).floatValue()};
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(ROTATION_YAW, (Object)Float.valueOf(0.0f));
        builder.define(ROTATION_ROLL, (Object)Float.valueOf(0.0f));
        builder.define(ROTATION_PITCH, (Object)Float.valueOf(0.0f));
        builder.define(LIFE, (Object)0);
        builder.define(CASTER_UUID, Optional.empty());
        builder.define(FIRED, (Object)false);
        builder.define(COLOR_R, (Object)Float.valueOf(1.0f));
        builder.define(COLOR_G, (Object)Float.valueOf(0.0f));
        builder.define(COLOR_B, (Object)Float.valueOf(0.0f));
        builder.define(COLOR_R2, (Object)Float.valueOf(1.0f));
        builder.define(COLOR_G2, (Object)Float.valueOf(1.0f));
        builder.define(COLOR_B2, (Object)Float.valueOf(1.0f));
        builder.define(COLOR_A, (Object)Float.valueOf(1.0f));
        builder.define(COLOR_A2, (Object)Float.valueOf(1.0f));
        builder.define(RADIUS, (Object)Float.valueOf(1.0f));
        builder.define(LENGTH, (Object)Float.valueOf(1.0f));
        builder.define(TARGET, (Object)0);
        builder.define(SPEED, (Object)Float.valueOf(0.0f));
    }

    protected void readAdditionalSaveData(CompoundTag compound) {
        this.setLife(compound.getInt(TAG_LIFE));
        this.setFired(compound.getBoolean(TAG_FIRED));
        if (compound.hasUUID(TAG_CASTER)) {
            this.setCasterUUID(compound.getUUID(TAG_CASTER));
        }
        this.setColor(compound.getFloat(TAG_COLOR_R), compound.getFloat(TAG_COLOR_G), compound.getFloat(TAG_COLOR_B), compound.getFloat(TAG_COLOR_A), compound.getFloat(TAG_COLOR_R2), compound.getFloat(TAG_COLOR_G2), compound.getFloat(TAG_COLOR_B2), compound.getFloat(TAG_COLOR_A2));
        this.setLength(compound.getFloat(TAG_LENGTH));
        this.setRadius(compound.getFloat(TAG_RADIUS));
        this.setRotationYaw(compound.getFloat(TAG_ROTATION_YAW));
        this.setRotationRoll(compound.getFloat(TAG_ROTATION_ROLL));
        this.setRotationPitch(compound.getFloat(TAG_ROTATION_PITCH));
        this.setTarget(compound.getInt(TAG_TARGET));
    }

    protected void addAdditionalSaveData(CompoundTag compound) {
        compound.putInt(TAG_LIFE, this.getLife());
        compound.putBoolean(TAG_FIRED, this.getFired());
        if (this.getCasterUUID() != null) {
            compound.putUUID(TAG_CASTER, this.getCasterUUID());
        }
        float[] colors = this.getColor();
        compound.putFloat(TAG_COLOR_R, colors[0]);
        compound.putFloat(TAG_COLOR_G, colors[1]);
        compound.putFloat(TAG_COLOR_B, colors[2]);
        compound.putFloat(TAG_COLOR_A, colors[3]);
        compound.putFloat(TAG_COLOR_R2, colors[4]);
        compound.putFloat(TAG_COLOR_G2, colors[5]);
        compound.putFloat(TAG_COLOR_B2, colors[6]);
        compound.putFloat(TAG_COLOR_A2, colors[7]);
        compound.putFloat(TAG_LENGTH, this.getLength());
        compound.putFloat(TAG_RADIUS, this.getRadius());
        compound.putFloat(TAG_ROTATION_YAW, this.getRotationYaw());
        compound.putFloat(TAG_ROTATION_ROLL, this.getRotationRoll());
        compound.putFloat(TAG_ROTATION_PITCH, this.getRotationPitch());
        compound.putInt(TAG_TARGET, this.getTarget());
    }

    public void setDeltaMovement(Vec3 pDeltaMovement) {
        if (pDeltaMovement.x > 0.0 && this.getDeltaMovement().x < 0.0 || !(pDeltaMovement.x < 0.0) || this.getDeltaMovement().x > 0.0) {
            // empty if block
        }
        super.setDeltaMovement(pDeltaMovement);
    }

    public void tick() {
        boolean hasTarget;
        super.tick();
        boolean client = this.level().isClientSide;
        long time = this.level().getGameTime();
        boolean fired = this.getFired();
        Entity target = this.getTarget() > 0 ? this.level().getEntity(this.getTarget()) : null;
        boolean bl = hasTarget = target != null && target.isAlive();
        if (this.timeCreated == -1L) {
            this.timeCreated = time;
        }
        this.setLife(this.getLife() + 1);
        if (fired) {
            ++this.ticksSinceFired;
        }
        if (client) {
            this.setSpeed((float)this.getDeltaMovement().length());
            MahouTsukaiMod.proxy.spawnGunBeamLightning(this);
            if (this.ticksSinceFired == 1 || this.ticksSinceFired == 2) {
                MahouTsukaiMod.proxy.spawnSmokeRings(this);
            }
        } else {
            --this.hitCD;
            if (this.ticksSinceFired > 400 || time - this.timeCreated > 800L) {
                this.discard();
            }
        }
        if (!client) {
            this.seppuku(fired, hasTarget);
            if (hasTarget && fired && !this.hit) {
                this.aimAt(target.getEyePosition());
                Vec3 adjustVector = this.position().subtract(target.getEyePosition()).normalize().scale(-5.0);
                Vec3 currentDelta = this.getDeltaMovement();
                if (adjustVector.x * currentDelta.x >= 0.0 && adjustVector.y * currentDelta.y >= 0.0 && adjustVector.z * currentDelta.z >= 0.0) {
                    this.setDeltaMovement(this.position().subtract(target.getEyePosition()).normalize().scale(-5.0));
                }
            }
            this.setLength((float)Math.min(1.0, (double)this.getLength() + this.getDeltaMovement().length() / 5.0));
            this.checkHit();
        }
        this.teleportTo(this.getX() + this.getDeltaMovement().x, this.getY() + this.getDeltaMovement().y, this.getZ() + this.getDeltaMovement().z);
    }

    public void seppuku(boolean fired, boolean hasTarget) {
        Player caster = this.getCaster();
        if (caster == null) {
            this.discard();
            return;
        }
        if (!this.autonomous) {
            if (!(fired && hasTarget || caster.getUseItem().getItem() instanceof Nobu && Utils.getMode(caster.getUseItem()) == 0)) {
                this.discard();
            }
        } else if (Nobu.player_storage.containsKey(this.getCasterUUID())) {
            Nobu.NobuUserStorage storage = Nobu.player_storage.get(this.getCasterUUID());
            if (this.owner == null || !storage.guns.containsValue((Object)this.owner) || !this.owner.isAlive()) {
                this.discard();
            }
        } else {
            this.discard();
        }
    }

    public Player getCaster() {
        if (this.getCasterUUID() != null) {
            return this.level().getPlayerByUUID(this.getCasterUUID());
        }
        return null;
    }

    public void shoot(double p_70186_1_, double p_70186_3_, double p_70186_5_, float p_70186_7_, float p_70186_8_) {
        Vec3 Vec32 = new Vec3(p_70186_1_, p_70186_3_, p_70186_5_).normalize().add(this.random.nextGaussian() * (double)0.0075f * (double)p_70186_8_, this.random.nextGaussian() * (double)0.0075f * (double)p_70186_8_, this.random.nextGaussian() * (double)0.0075f * (double)p_70186_8_).scale((double)p_70186_7_);
        this.setDeltaMovement(Vec32);
        float f = Mth.sqrt((float)((float)Vec32.horizontalDistanceSqr()));
        this.yRot = (float)(Mth.atan2((double)Vec32.x, (double)Vec32.z) * 57.2957763671875);
        this.xRot = (float)(Mth.atan2((double)Vec32.y, (double)f) * 57.2957763671875);
        this.yRotO = this.yRot;
        this.xRotO = this.xRot;
    }

    public void checkHit() {
        EntityHitResult entityraytraceresult;
        Vec3 vec3d = this.getDeltaMovement();
        Vec3 vec3d2 = this.position();
        Vec3 vec3d3 = vec3d2.add(vec3d);
        BlockHitResult raytraceresult = this.level().clip(new ClipContext(vec3d2, vec3d3, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
        if (raytraceresult.getType() != HitResult.Type.MISS) {
            vec3d3 = raytraceresult.getLocation();
        }
        if ((entityraytraceresult = this.rayTraceEntities(vec3d2, vec3d3)) != null) {
            raytraceresult = entityraytraceresult;
        }
        if (raytraceresult != null && raytraceresult.getType() == HitResult.Type.ENTITY && raytraceresult instanceof EntityHitResult) {
            Entity entity = ((EntityHitResult)raytraceresult).getEntity();
            Entity entity1 = this.getShooter();
            if (entity instanceof Player && entity1 instanceof Player && !((Player)entity1).canHarmPlayer((Player)entity) && !ContractMahoujinTileEntity.isImmuneToSpell(this.level(), this.getCasterUUID(), entity)) {
                raytraceresult = null;
                entityraytraceresult = null;
            }
        }
        if (this.hitCD < 0 && raytraceresult != null && raytraceresult.getType() != HitResult.Type.MISS) {
            this.onHit((HitResult)raytraceresult);
            this.hitCD = 1;
        }
        raytraceresult = null;
    }

    public void aimAt(Vec3 pos) {
        Vec3 aim = pos.subtract(this.position());
        this.setRotationPitch(EffectUtil.toDegrees((float)(-Math.atan2(Math.sqrt(aim.z * aim.z + aim.x * aim.x), aim.y))));
        this.setRotationYaw(-EffectUtil.toDegrees((float)Math.atan2(aim.z, aim.x)) + 270.0f);
    }

    public void onHit(HitResult result) {
        EntityHitResult ehr;
        Entity entity;
        Vec3 target = result.getLocation();
        double x = target.x;
        double y = target.y;
        double z = target.z;
        Player caster = this.getCaster();
        float damage = (float)MTConfig.NOBU_BULLET_DAMAGE;
        if (caster.getMainHandItem().getItem() instanceof Nobu && EffectUtil.hasEnchantment(caster.getMainHandItem(), (ResourceKey<Enchantment>)Enchantments.POWER, this.level())) {
            damage += (float)(MTConfig.NOBU_POWER_DAMAGE_FACTOR * (double)EffectUtil.getEnchantmentLevel(caster.getMainHandItem(), EffectUtil.toHolder((ResourceKey<Enchantment>)Enchantments.POWER, this.level())));
        }
        if (result instanceof EntityHitResult && (entity = (ehr = (EntityHitResult)result).getEntity()) instanceof LivingEntity) {
            LivingEntity b = (LivingEntity)entity;
            if (this.getCasterUUID() == null || !ContractMahoujinTileEntity.isImmuneToSpell(this.level(), this.getCasterUUID(), (Entity)b)) {
                EffectUtil.magicAttack(b, damage, (LivingEntity)caster);
            }
            PacketHandler.sendTracking(this, new SparkExplosionPacket(ehr.getEntity().position().add(0.0, (double)(ehr.getEntity().getEyeHeight() / 2.0f), 0.0), Floats.asList((float[])this.getColor())));
            this.setTarget(-1);
            this.hit = true;
        }
        if (result instanceof BlockHitResult) {
            PacketHandler.sendTracking(this, new SparkExplosionPacket(((BlockHitResult)result).getBlockPos().relative(((BlockHitResult)result).getDirection()).getCenter(), Floats.asList((float[])this.getColor())));
            if (MTConfig.NOBU_AOE_HIT > 0.0) {
                List entities = this.level().getEntities((Entity)this, new AABB(this.position().subtract(MTConfig.NOBU_AOE_HIT, MTConfig.NOBU_AOE_HIT, MTConfig.NOBU_AOE_HIT), this.position().add(MTConfig.NOBU_AOE_HIT, MTConfig.NOBU_AOE_HIT, MTConfig.NOBU_AOE_HIT)), a -> a instanceof LivingEntity && !a.getUUID().equals(this.getCasterUUID()));
                for (Entity e : entities) {
                    if (this.getCasterUUID() != null && ContractMahoujinTileEntity.isImmuneToSpell(this.level(), this.getCasterUUID(), e)) continue;
                    EffectUtil.magicAttack((LivingEntity)e, (float)(MTConfig.NOBU_AOE_FACTOR * (double)damage), (LivingEntity)caster);
                }
            }
            this.discard();
        }
    }

    public void specialDiscard() {
        PacketHandler.sendTracking(this, new SparkExplosionPacket(this.position(), Floats.asList((float[])this.getColor())));
        this.discard();
    }

    public boolean canCollideWith(Entity pEntity) {
        return false;
    }

    public boolean canBeCollidedWith() {
        return true;
    }

    public boolean isColliding(BlockPos pPos, BlockState pState) {
        return true;
    }

    @Nullable
    public Entity getShooter() {
        return this.getCasterUUID() != null && this.level() instanceof ServerLevel ? ((ServerLevel)this.level()).getEntity(this.getCasterUUID()) : null;
    }

    @Nullable
    protected EntityHitResult rayTraceEntities(Vec3 startVec, Vec3 endVec) {
        return ProjectileUtil.getEntityHitResult((Level)this.level(), (Entity)this, (Vec3)startVec, (Vec3)endVec, (AABB)this.getBoundingBox().expandTowards(this.getDeltaMovement()).inflate(1.3), p_213871_1_ -> !p_213871_1_.isSpectator() && p_213871_1_.isAlive() && p_213871_1_.isPickable() && !(p_213871_1_ instanceof GunBeamProjectileEntity) && (!p_213871_1_.getUUID().equals(this.getCasterUUID()) || this.ticksSinceFired >= 5));
    }

    public int getLife() {
        return (Integer)this.entityData.get(LIFE);
    }

    public void setLife(int l) {
        this.entityData.set(LIFE, (Object)l);
    }

    public UUID getCasterUUID() {
        return ((Optional)this.entityData.get(CASTER_UUID)).orElse(null);
    }

    public void setCasterUUID(UUID uuid) {
        this.entityData.set(CASTER_UUID, Optional.of(uuid));
    }

    public boolean getFired() {
        return (Boolean)this.entityData.get(FIRED);
    }

    public void setFired(boolean f) {
        this.entityData.set(FIRED, (Object)f);
    }

    public float getLength() {
        return ((Float)this.entityData.get(LENGTH)).floatValue();
    }

    public void setLength(float f) {
        this.entityData.set(LENGTH, (Object)Float.valueOf(f));
    }

    public float getRadius() {
        return ((Float)this.entityData.get(RADIUS)).floatValue();
    }

    public void setRadius(float f) {
        this.entityData.set(RADIUS, (Object)Float.valueOf(f));
    }

    public float getRotationYaw() {
        return ((Float)this.entityData.get(ROTATION_YAW)).floatValue();
    }

    public void setRotationYaw(float y) {
        this.entityData.set(ROTATION_YAW, (Object)Float.valueOf(y));
    }

    public float getRotationRoll() {
        return ((Float)this.entityData.get(ROTATION_ROLL)).floatValue();
    }

    public void setRotationRoll(float y) {
        this.entityData.set(ROTATION_ROLL, (Object)Float.valueOf(y));
    }

    public float getRotationPitch() {
        return ((Float)this.entityData.get(ROTATION_PITCH)).floatValue();
    }

    public void setRotationPitch(float p) {
        this.entityData.set(ROTATION_PITCH, (Object)Float.valueOf(p));
    }

    public int getTarget() {
        return (Integer)this.entityData.get(TARGET);
    }

    public void setTarget(int p) {
        this.entityData.set(TARGET, (Object)p);
    }

    public float getSpeed() {
        return ((Float)this.entityData.get(SPEED)).floatValue();
    }

    public void setSpeed(float p) {
        this.entityData.set(SPEED, (Object)Float.valueOf(p));
    }
}

