/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.entity.mahoujin;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import stepsword.mahoutsukai.MahouTsukaiMod;
import stepsword.mahoutsukai.advancements.MahouTrigger;
import stepsword.mahoutsukai.advancements.ModTriggers;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.dataattachments.mahou.IMahou;
import stepsword.mahoutsukai.entity.ModEntities;
import stepsword.mahoutsukai.item.spells.mystic.MysticStaff.MysticStaff;
import stepsword.mahoutsukai.mana.PlayerManaManager;
import stepsword.mahoutsukai.networking.BeamPacket;
import stepsword.mahoutsukai.networking.PacketHandler;
import stepsword.mahoutsukai.tile.exchange.ContractMahoujinTileEntity;
import stepsword.mahoutsukai.util.EffectUtil;
import stepsword.mahoutsukai.util.Utils;

public class MysticStaffBeamMahoujinEntity
extends Entity {
    private static final String TAG_ROTATION_YAW = "MAHOUTSUKAI_ROTATION_YAW";
    private static final String TAG_ROTATION_ROLL = "MAHOUTSUKAI_ROTATION_ROLL";
    private static final String TAG_ROTATION_PITCH = "MAHOUTSUKAI_ROTATION_PITCH";
    private static final String TAG_ROTATION_SPEED = "MAHOUTSUKAI_ROTATION_SPEED";
    private static final String TAG_CIRCLE_SIZE = "MAHOUTSUKAI_ROTATION_SPEED";
    private static final String TAG_BEAM_SIZE = "MAHOUTSUKAI_BEAM_SIZE";
    private static final String TAG_BEAM_LENGTH = "MAHOUTSUKAI_BEAM_LENGTH";
    private static final String TAG_LIFE = "MAHOUTSUKAI_LIFE";
    private static final String TAG_SPHERE_SIZE = "MAHOUTSUKAI_SPHERE_SIZE";
    private static final String TAG_COLOR_R = "MAHOUTSUKAI_COLOR_R";
    private static final String TAG_COLOR_G = "MAHOUTSUKAI_COLOR_G";
    private static final String TAG_COLOR_B = "MAHOUTSUKAI_COLOR_B";
    private static final String TAG_COLOR_A = "MAHOUTSUKAI_COLOR_A";
    private static final String TAG_CASTER = "MAHOUTSUKAI_CASTER";
    private static final String TAG_DYING = "MAHOUTSUKAI_DYING";
    public float prev_beam_size;
    public float prev_beam_len;
    public float prev_sphere_size;
    public float prev_mini_roll;
    public static int dyingticks = 6;
    public double prevx;
    public double prevy;
    public double prevz;
    private static final AABB ZERO_AABB = new AABB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    public static final AABB bb = new AABB(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
    private static final EntityDataAccessor<Float> ROTATION_YAW = SynchedEntityData.defineId(MysticStaffBeamMahoujinEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> ROTATION_ROLL = SynchedEntityData.defineId(MysticStaffBeamMahoujinEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> ROTATION_PITCH = SynchedEntityData.defineId(MysticStaffBeamMahoujinEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> ROTATION_SPEED = SynchedEntityData.defineId(MysticStaffBeamMahoujinEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> CIRCLE_SIZE = SynchedEntityData.defineId(MysticStaffBeamMahoujinEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> BEAM_SIZE = SynchedEntityData.defineId(MysticStaffBeamMahoujinEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> BEAM_LENGTH = SynchedEntityData.defineId(MysticStaffBeamMahoujinEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Integer> LIFE = SynchedEntityData.defineId(MysticStaffBeamMahoujinEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Float> SPHERE_SIZE = SynchedEntityData.defineId(MysticStaffBeamMahoujinEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> COLOR_R = SynchedEntityData.defineId(MysticStaffBeamMahoujinEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> COLOR_G = SynchedEntityData.defineId(MysticStaffBeamMahoujinEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> COLOR_B = SynchedEntityData.defineId(MysticStaffBeamMahoujinEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> COLOR_A = SynchedEntityData.defineId(MysticStaffBeamMahoujinEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Optional<UUID>> CASTER = SynchedEntityData.defineId(MysticStaffBeamMahoujinEntity.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_UUID);
    private static final EntityDataAccessor<Integer> DYING = SynchedEntityData.defineId(MysticStaffBeamMahoujinEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final String entityName = "mahoujin_beam_entity";
    Player caster = null;

    public MysticStaffBeamMahoujinEntity(EntityType entityEntityType, Level world) {
        super(entityEntityType, world);
    }

    public MysticStaffBeamMahoujinEntity(Level world) {
        super((EntityType)ModEntities.BEAM_MAHOUJIN.get(), world);
        this.noCulling = true;
    }

    public MysticStaffBeamMahoujinEntity(Level world, Player caster, float r, float g, float b) {
        this(world);
        this.caster = caster;
        this.setCaster(caster.getUUID());
        this.setColor(r, g, b, 1.0f);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(ROTATION_YAW, (Object)Float.valueOf(0.0f));
        builder.define(ROTATION_ROLL, (Object)Float.valueOf(0.0f));
        builder.define(ROTATION_PITCH, (Object)Float.valueOf(0.0f));
        builder.define(ROTATION_SPEED, (Object)Float.valueOf(0.0f));
        builder.define(CIRCLE_SIZE, (Object)Float.valueOf(0.0f));
        builder.define(LIFE, (Object)0);
        builder.define(BEAM_SIZE, (Object)Float.valueOf(0.0f));
        builder.define(BEAM_LENGTH, (Object)Float.valueOf(0.0f));
        builder.define(COLOR_R, (Object)Float.valueOf(1.0f));
        builder.define(COLOR_G, (Object)Float.valueOf(1.0f));
        builder.define(COLOR_B, (Object)Float.valueOf(1.0f));
        builder.define(COLOR_A, (Object)Float.valueOf(0.0f));
        builder.define(SPHERE_SIZE, (Object)Float.valueOf(0.0f));
        builder.define(CASTER, Optional.of(UUID.randomUUID()));
        builder.define(DYING, (Object)0);
    }

    public void tick() {
        super.tick();
        this.yRotO = this.yRot;
        boolean circle_size_min_time = false;
        int circle_size_max_time = 15;
        int mini_speed_min_time = 15;
        int mini_speed_max_time = 35;
        int sphere_size_min_time = 25;
        int sphere_size_max_time = 35;
        int beam_size_min_time = 40;
        int beam_size_max_time = 45;
        int beam_len_min_time = 40;
        int beam_len_max_time = 45;
        float goal_circle_size = 1.5f;
        float goal_mini_speed = 6.0f;
        float goal_beam_size = 0.7f;
        float goal_beam_len = 64.0f;
        float goal_sphere_size = 0.7f;
        this.prev_beam_size = this.getBeamSize();
        this.prev_beam_len = this.getBeamLength();
        this.prev_sphere_size = this.getSphereSize();
        this.prev_mini_roll = this.getRotationRoll();
        if (this.getLife() == sphere_size_min_time - 3 && !this.level().isClientSide) {
            for (ServerPlayer p : ((ServerLevel)this.level()).players()) {
                if (p.level() != this.level()) continue;
                PacketHandler.sendTo(p, new BeamPacket(this.getId()));
            }
        }
        if (this.getCaster() != null && this.caster == null) {
            this.caster = this.level().getPlayerByUUID(this.getCaster());
        }
        if (this.caster != null && this.getDying() <= 0) {
            this.casterPosition(false);
            if (!(this.caster.getUseItem().getItem() instanceof MysticStaff)) {
                this.setDying(1);
                MahouTsukaiMod.proxy.speedUp();
            }
            if (this.getLife() == beam_len_min_time + 1) {
                this.boopCaster();
                if (this.caster instanceof ServerPlayer) {
                    ((MahouTrigger)((Object)ModTriggers.BEAM.get())).trigger((ServerPlayer)this.caster);
                }
            } else if (this.getLife() < beam_len_min_time + 1 || this.getLife() > beam_len_max_time + 4) {
                this.holdCaster();
            }
        } else if (this.getDying() <= 0) {
            this.setDying(1);
        }
        int life = this.getLife();
        this.setCircleSize(goal_circle_size);
        if (this.getDying() <= 0) {
            this.setRotationSpeed(life < mini_speed_min_time ? 0.0f : (life > mini_speed_max_time ? goal_mini_speed : goal_mini_speed * ((float)life - (float)mini_speed_min_time) / ((float)mini_speed_max_time - (float)mini_speed_min_time)));
            this.setBeamSize(life < beam_size_min_time ? 0.0f : (life > beam_size_max_time ? goal_beam_size : goal_beam_size * ((float)life - (float)beam_size_max_time) / ((float)beam_size_max_time - (float)beam_size_min_time)));
            this.setSphereSize(life < sphere_size_min_time ? 0.0f : (life > sphere_size_max_time ? goal_sphere_size : goal_sphere_size * ((float)life - (float)sphere_size_min_time) / ((float)sphere_size_max_time - (float)sphere_size_min_time)));
            this.setBeamLength(life < beam_len_min_time ? 0.0f : (life > beam_len_max_time ? goal_beam_len : goal_beam_len * ((float)life - (float)beam_len_min_time) / ((float)beam_len_max_time - (float)beam_len_min_time)));
            this.setRotationSpeed(Math.max(this.getRotationSpeed(), 0.0f));
            this.setBeamSize(Math.max(this.getBeamSize(), 0.0f));
            this.setSphereSize(Math.max(this.getSphereSize(), 0.0f));
            this.setBeamLength(Math.max(this.getBeamLength(), 0.0f));
        } else {
            float factor = ((float)dyingticks - 1.0f) / (float)dyingticks;
            this.setRotationSpeed(factor * this.getRotationSpeed());
            this.setBeamSize(factor * this.getBeamSize());
            this.setSphereSize(factor * this.getSphereSize());
            if (this.getDying() > dyingticks * 3) {
                this.discard();
            }
            this.setDying(this.getDying() + 1);
        }
        this.setRotationYaw(this.getRotationYaw() % 360.0f);
        if (this.getRotationYaw() < 0.0f) {
            this.setRotationYaw(this.getRotationYaw() + 360.0f);
        }
        if (this.getRotationYaw() > 360.0f) {
            this.setRotationYaw(this.getRotationYaw() - 360.0f);
        }
        this.setLife(this.getLife() + 1);
        this.setRotationRoll(this.getRotationRoll() + this.getRotationSpeed());
        if (!this.level().isClientSide && this.getDying() <= 0 && this.getLife() > beam_len_min_time) {
            this.bakuretsu(beam_len_min_time);
        }
    }

    public void holdCaster() {
        this.caster.setDeltaMovement(0.0, 0.0, 0.0);
        this.caster.hurtMarked = true;
    }

    public void boopCaster() {
        double strength = 0.03;
        this.caster.hasImpulse = true;
        Vec3 v = this.caster.getLookAngle();
        float f = Mth.sqrt((float)((float)(v.x * v.x + v.z * v.z + v.y * v.y)));
        double motionX = 0.0;
        double motionZ = 0.0;
        double motionY = 0.0;
        motionX -= v.x / (double)f * strength;
        motionZ -= v.z / (double)f * strength;
        motionY -= v.y / (double)f * strength;
        if (this.caster.onGround()) {
            motionY /= 2.0;
            if ((motionY += 0.3) > 0.1) {
                motionY = 0.1;
            }
        }
        this.caster.setDeltaMovement(motionX, motionY, motionZ);
        this.caster.hurtMarked = true;
    }

    public void bakuretsu(int beam_start) {
        IMahou mahou;
        double mana_factor = MTConfig.MYSTIC_STAFF_BEAM_SCALING_MANA;
        if (Utils.getPlayerMahou(this.caster) != null) {
            mana_factor *= (double)Utils.getPlayerMahou(this.caster).getMaxMana();
        }
        int mana = (int)mana_factor + MTConfig.MYSTIC_STAFF_BEAM_MANA_PER_TICK;
        int seconds = (this.getLife() - beam_start) / 20;
        double damage = MTConfig.MYSTIC_STAFF_BEAM_DAMAGE_FACTOR;
        if (MTConfig.MYSTIC_STAFF_BEAM_DAMAGE_SCALES && (mahou = Utils.getPlayerMahou(this.caster)) != null) {
            damage *= (double)mahou.getMaxMana();
        }
        for (int i = 0; i < seconds; ++i) {
            damage *= MTConfig.MYSTIC_STAFF_BEAM_DAMAGE_ACCELERATION;
        }
        if (PlayerManaManager.drainMana(this.caster, mana, false, false) == mana) {
            HashSet<BlockPos> blocks = new HashSet<BlockPos>();
            int blockspertick = MTConfig.MYSTIC_STAFF_BEAM_MAX_BLOCK_BREAK_PER_TICK;
            float pt = this.getRotationPitch();
            float yw = this.getRotationYaw();
            Vec3 direction = Vec3.directionFromRotation((float)(90.0f - pt), (float)(360.0f - yw + 180.0f)).normalize();
            Vec3 pos = this.position();
            boolean keepbreaking = true;
            ArrayList<Entity> lst = new ArrayList<Entity>();
            for (float i = 0.0f; i < this.getBeamLength(); i += 1.0f) {
                Vec3 diskcenter = pos.add(direction.scale((double)i));
                AABB aabb = new AABB(Utils.toBlockPos(diskcenter).offset(-2, -2, -2).getCenter(), Utils.toBlockPos(diskcenter).offset(2, 2, 2).getCenter());
                for (Entity e : this.level().getEntities((Entity)null, aabb, Entity::isAlive)) {
                    if (e == this.caster || e instanceof MysticStaffBeamMahoujinEntity || !(e instanceof LivingEntity) || ContractMahoujinTileEntity.isImmuneToSpell(this.level(), this.getCaster(), e)) continue;
                    lst.add(e);
                }
                if (blocks.size() >= blockspertick) {
                    keepbreaking = false;
                }
                if (!keepbreaking) continue;
                for (int j = -3; j <= 3; ++j) {
                    for (int k = -3; k <= 3; ++k) {
                        for (int m = -3; m <= 3; ++m) {
                            BlockPos p = Utils.toBlockPos((double)j + diskcenter.x, (double)k + diskcenter.y, (double)m + diskcenter.z);
                            if (!(p.distToCenterSqr(diskcenter.x, diskcenter.y, diskcenter.z) <= 7.0)) continue;
                            BlockState bs = this.level().getBlockState(p);
                            boolean whitelisted = false;
                            if (MTConfig.MYSTIC_STAFF_BEAM_BLOCK_WHITELIST.size() > 0) {
                                whitelisted = EffectUtil.inBlockBlacklist(bs.getBlock(), MTConfig.MYSTIC_STAFF_BEAM_BLOCK_WHITELIST, this.level());
                            }
                            if (bs.isAir() || whitelisted) continue;
                            blocks.add(p);
                        }
                    }
                }
            }
            ArrayList<BlockPos> bs = new ArrayList<BlockPos>(blocks);
            EffectUtil.tryFakeExplosion(EffectUtil.createFakeExplosion((Entity)this.caster, this.caster, this.caster.position(), bs), bs, (Entity)this.caster, this.caster, "mahou_beam", false, lst);
            for (Entity e : lst) {
                EffectUtil.magicAttack((LivingEntity)e, (float)damage, (LivingEntity)this.caster);
            }
        } else {
            this.setDying(1);
        }
    }

    public void casterPosition(boolean casterpos) {
        this.prevx = this.getX();
        this.prevy = this.getY();
        this.prevz = this.getZ();
        this.xRotO = this.getRotationPitch();
        this.yRotO = this.getRotationYaw();
        this.setRotationPitch(90.0f - this.caster.xRot);
        this.setRotationYaw(360.0f - this.caster.yRot + 180.0f);
        this.yRot = this.getRotationYaw();
        this.xRot = this.getRotationPitch();
        if (casterpos) {
            Vec3 v = this.caster.getLookAngle().scale((double)1.4f).add(this.caster.getEyePosition(1.0f));
            this.setPos(v.x, v.y, v.z);
        }
    }

    public void setColor(float r, float g, float b, float a) {
        this.entityData.set(COLOR_R, (Object)Float.valueOf(r));
        this.entityData.set(COLOR_G, (Object)Float.valueOf(g));
        this.entityData.set(COLOR_B, (Object)Float.valueOf(b));
        this.entityData.set(COLOR_A, (Object)Float.valueOf(a));
    }

    public float[] getColor() {
        return new float[]{((Float)this.entityData.get(COLOR_R)).floatValue(), ((Float)this.entityData.get(COLOR_G)).floatValue(), ((Float)this.entityData.get(COLOR_B)).floatValue(), ((Float)this.entityData.get(COLOR_A)).floatValue()};
    }

    public static float toRad(float degrees) {
        return degrees * ((float)Math.PI / 180);
    }

    protected void readAdditionalSaveData(CompoundTag compound) {
        this.setRotationYaw(compound.getFloat(TAG_ROTATION_YAW));
        this.setRotationRoll(compound.getFloat(TAG_ROTATION_ROLL));
        this.setRotationPitch(compound.getFloat(TAG_ROTATION_PITCH));
        this.setRotationSpeed(compound.getFloat("MAHOUTSUKAI_ROTATION_SPEED"));
        this.setCircleSize(compound.getFloat("MAHOUTSUKAI_ROTATION_SPEED"));
        this.setLife(compound.getInt(TAG_LIFE));
        this.setBeamSize(compound.getFloat(TAG_BEAM_SIZE));
        this.setBeamLength(compound.getFloat(TAG_BEAM_LENGTH));
        this.setCaster(compound.getUUID(TAG_CASTER));
        this.setColor(compound.getFloat(TAG_COLOR_R), compound.getFloat(TAG_COLOR_G), compound.getFloat(TAG_COLOR_B), compound.getFloat(TAG_COLOR_A));
        this.setDying(compound.getInt(TAG_DYING));
        this.setSphereSize(compound.getFloat(TAG_SPHERE_SIZE));
    }

    protected void addAdditionalSaveData(CompoundTag compound) {
        compound.putFloat(TAG_ROTATION_YAW, this.getRotationYaw());
        compound.putFloat(TAG_ROTATION_ROLL, this.getRotationRoll());
        compound.putFloat(TAG_ROTATION_PITCH, this.getRotationPitch());
        compound.putFloat("MAHOUTSUKAI_ROTATION_SPEED", this.getRotationSpeed());
        compound.putFloat("MAHOUTSUKAI_ROTATION_SPEED", this.getCircleSize());
        compound.putInt(TAG_LIFE, this.getLife());
        compound.putUUID(TAG_CASTER, this.getCaster());
        compound.putFloat(TAG_BEAM_LENGTH, this.getBeamLength());
        compound.putFloat(TAG_BEAM_SIZE, this.getBeamSize());
        float[] colors = this.getColor();
        compound.putFloat(TAG_COLOR_R, colors[0]);
        compound.putFloat(TAG_COLOR_G, colors[1]);
        compound.putFloat(TAG_COLOR_B, colors[2]);
        compound.putFloat(TAG_COLOR_A, colors[3]);
        compound.putFloat(TAG_SPHERE_SIZE, this.getSphereSize());
        compound.putInt(TAG_DYING, this.getDying());
    }

    protected void checkInsideBlocks() {
    }

    @Nullable
    public AABB getBoundingBox() {
        return ZERO_AABB;
    }

    public void push(Entity entityIn) {
    }

    public AABB getBoundingBoxForCulling() {
        return ZERO_AABB;
    }

    public boolean shouldRenderAtSqrDistance(double distance) {
        return true;
    }

    public boolean shouldRender(double x, double y, double z) {
        return true;
    }

    public float getRotationYaw() {
        return ((Float)this.entityData.get(ROTATION_YAW)).floatValue();
    }

    public void setRotationYaw(float y) {
        this.entityData.set(ROTATION_YAW, (Object)Float.valueOf(y));
    }

    public float getRotationRoll() {
        return ((Float)this.entityData.get(ROTATION_ROLL)).floatValue();
    }

    public void setRotationRoll(float y) {
        this.entityData.set(ROTATION_ROLL, (Object)Float.valueOf(y));
    }

    public float getRotationPitch() {
        return ((Float)this.entityData.get(ROTATION_PITCH)).floatValue();
    }

    public void setRotationPitch(float p) {
        this.entityData.set(ROTATION_PITCH, (Object)Float.valueOf(p));
    }

    public float getRotationSpeed() {
        return ((Float)this.entityData.get(ROTATION_SPEED)).floatValue();
    }

    public void setRotationSpeed(float s) {
        this.entityData.set(ROTATION_SPEED, (Object)Float.valueOf(s));
    }

    public float getCircleSize() {
        return ((Float)this.entityData.get(CIRCLE_SIZE)).floatValue();
    }

    public void setCircleSize(float s) {
        this.entityData.set(CIRCLE_SIZE, (Object)Float.valueOf(s));
    }

    public int getLife() {
        return (Integer)this.entityData.get(LIFE);
    }

    public void setLife(int l) {
        this.entityData.set(LIFE, (Object)l);
    }

    public float getBeamSize() {
        return ((Float)this.entityData.get(BEAM_SIZE)).floatValue();
    }

    public void setBeamSize(float b) {
        this.entityData.set(BEAM_SIZE, (Object)Float.valueOf(b));
    }

    public float getBeamLength() {
        return ((Float)this.entityData.get(BEAM_LENGTH)).floatValue();
    }

    public void setBeamLength(float b) {
        this.entityData.set(BEAM_LENGTH, (Object)Float.valueOf(b));
    }

    public UUID getCaster() {
        return ((Optional)this.entityData.get(CASTER)).orElse(UUID.fromString("00000000-0000-0000-0000-000000000000"));
    }

    public void setCaster(UUID uuid) {
        this.entityData.set(CASTER, Optional.of(uuid));
    }

    public int getDying() {
        return (Integer)this.entityData.get(DYING);
    }

    public void setDying(int d) {
        this.entityData.set(DYING, (Object)d);
    }

    public float getSphereSize() {
        return ((Float)this.entityData.get(SPHERE_SIZE)).floatValue();
    }

    public void setSphereSize(float d) {
        this.entityData.set(SPHERE_SIZE, (Object)Float.valueOf(d));
    }
}

