/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.integration.emi;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.emi.emi.api.render.EmiRenderable;
import dev.emi.emi.api.stack.EmiStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTextTooltip;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.client.ClientHooks;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import stepsword.mahoutsukai.block.ModBlocks;
import stepsword.mahoutsukai.block.spells.Mahoujin;
import stepsword.mahoutsukai.render.item.MahoujinItemStackRenderer;
import stepsword.mahoutsukai.tile.MahoujinTileEntity;
import stepsword.mahoutsukai.util.UnorderedList;

public class MahoujinEmiStack
extends EmiStack
implements EmiRenderable {
    ItemStack stack = new ItemStack((ItemLike)ModBlocks.mahoujinBlockItem);
    public ResourceLocation loc;
    public Component name;
    public Block b;
    public MahoujinTileEntity be;
    public UnorderedList recipe;

    public MahoujinEmiStack(ResourceLocation loc, Block b, UnorderedList recipe) {
        this.loc = loc;
        this.name = b.getName();
        this.b = b;
        this.recipe = recipe;
        this.be = new MahoujinTileEntity(new BlockPos(0, 0, 0), ((Mahoujin)((Object)ModBlocks.mahoujin.get())).defaultBlockState());
        this.be.setCatalysts(recipe, false);
    }

    public MahoujinEmiStack(ResourceLocation loc, Block b, UnorderedList recipe, boolean cloth) {
        this(loc, b, recipe);
        this.be.setCloth(cloth);
    }

    public void render(GuiGraphics guiGraphics, int i, int i1, float v) {
        ItemStack stack = this.getItemStack();
        Lighting.setupFor3DItems();
        this.renderItem(this.be, guiGraphics, null, null, stack, i, i1, 0, 0);
    }

    public void render(GuiGraphics guiGraphics, int i, int i1, float v, int i2) {
        ItemStack stack = this.getItemStack();
        Lighting.setupFor3DItems();
        this.renderItem(this.be, guiGraphics, null, null, stack, i, i1, 0, 0);
    }

    public EmiStack copy() {
        return new MahoujinEmiStack(this.loc, this.b, this.recipe);
    }

    public boolean isEmpty() {
        return false;
    }

    public DataComponentPatch getComponentChanges() {
        return DataComponentPatch.EMPTY;
    }

    public Object getKey() {
        return ModBlocks.mahoujinBlockItem;
    }

    public ResourceLocation getId() {
        return this.loc;
    }

    public ItemStack getItemStack() {
        return this.stack;
    }

    public boolean isEqual(EmiStack stack) {
        return stack.getId().equals((Object)this.getId());
    }

    public List<ClientTooltipComponent> getTooltip() {
        ItemStack stack = this.getItemStack();
        ArrayList list = Lists.newArrayList();
        if (!this.isEmpty()) {
            Minecraft client = Minecraft.getInstance();
            list.addAll(ClientHooks.gatherTooltipComponents((ItemStack)stack, (List)Screen.getTooltipFromItem((Minecraft)client, (ItemStack)stack), (Optional)stack.getTooltipImage(), (int)0, (int)Integer.MAX_VALUE, (int)Integer.MAX_VALUE, (Font)client.font));
            list.removeFirst();
            list.addFirst(new ClientTextTooltip(this.getName().getVisualOrderText()));
        }
        return list;
    }

    public List<Component> getTooltipText() {
        return this.getItemStack().getTooltipLines(Item.TooltipContext.of((Level)Minecraft.getInstance().level), (Player)Minecraft.getInstance().player, (TooltipFlag)TooltipFlag.NORMAL);
    }

    public Component getName() {
        return this.name;
    }

    private void renderItem(MahoujinTileEntity te, GuiGraphics graphics, @Nullable LivingEntity pEntity, @Nullable Level pLevel, ItemStack pStack, int pX, int pY, int pSeed, int pGuiOffset) {
        if (!pStack.isEmpty()) {
            BakedModel bakedmodel = Minecraft.getInstance().getItemRenderer().getModel(pStack, pLevel, pEntity, pSeed);
            graphics.pose().pushPose();
            graphics.pose().translate((float)(pX + 8), (float)(pY + 8), (float)(150 + (bakedmodel.isGui3d() ? pGuiOffset : 0)));
            try {
                boolean flag;
                graphics.pose().scale(16.0f, -16.0f, 16.0f);
                boolean bl = flag = !bakedmodel.usesBlockLight();
                if (flag) {
                    Lighting.setupForFlatItems();
                }
                this.render(te, pStack, ItemDisplayContext.GUI, false, graphics.pose(), (MultiBufferSource)graphics.bufferSource(), 0xF000F0, OverlayTexture.NO_OVERLAY, bakedmodel);
                graphics.flush();
                if (flag) {
                    Lighting.setupFor3DItems();
                }
            }
            catch (Throwable throwable) {
                CrashReport crashreport = CrashReport.forThrowable((Throwable)throwable, (String)"Rendering item");
                CrashReportCategory crashreportcategory = crashreport.addCategory("Item being rendered");
                crashreportcategory.setDetail("Item Type", () -> String.valueOf(pStack.getItem()));
                crashreportcategory.setDetail("Item Components", () -> String.valueOf(pStack.getComponents()));
                crashreportcategory.setDetail("Item Foil", () -> String.valueOf(pStack.hasFoil()));
                throw new ReportedException(crashreport);
            }
            graphics.pose().popPose();
        }
    }

    public void render(MahoujinTileEntity te, ItemStack pItemStack, ItemDisplayContext pDisplayContext, boolean pLeftHand, PoseStack pPoseStack, MultiBufferSource pBuffer, int pCombinedLight, int pCombinedOverlay, BakedModel pModel) {
        if (!pItemStack.isEmpty()) {
            pPoseStack.pushPose();
            pModel = ClientHooks.handleCameraTransforms((PoseStack)pPoseStack, (BakedModel)pModel, (ItemDisplayContext)pDisplayContext, (boolean)pLeftHand);
            pPoseStack.translate(-0.5f, -0.5f, -0.5f);
            BlockEntityWithoutLevelRenderer bewlr = IClientItemExtensions.of((ItemStack)pItemStack).getCustomRenderer();
            if (bewlr instanceof MahoujinItemStackRenderer) {
                MahoujinItemStackRenderer misr = (MahoujinItemStackRenderer)bewlr;
                misr.renderByItem(te, pItemStack, pDisplayContext, pPoseStack, pBuffer, pCombinedLight, pCombinedOverlay);
            }
            pPoseStack.popPose();
        }
    }
}

