/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.networking;

import io.netty.buffer.ByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.chunk.LevelChunk;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.dataattachments.chunks.IChunkMahou;
import stepsword.mahoutsukai.networking.ChunkMahouPacket;
import stepsword.mahoutsukai.networking.MahouPackets;
import stepsword.mahoutsukai.networking.PacketHandler;
import stepsword.mahoutsukai.util.Utils;

public class ChunkMahouRequestPacket
implements CustomPacketPayload {
    int x;
    int z;
    public static final StreamCodec<ByteBuf, ChunkMahouRequestPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, p -> p.x, (StreamCodec)ByteBufCodecs.INT, p -> p.z, ChunkMahouRequestPacket::new);

    public ChunkMahouRequestPacket(int x, int z) {
        this.x = x;
        this.z = z;
    }

    public static void handle(ChunkMahouRequestPacket message, IPayloadContext context) {
        ServerPlayer sender = (ServerPlayer)context.player();
        Utils.schedule(sender.level(), () -> {
            if (MTConfig.CHUNK_PACKET_REPLIES_ENABLED) {
                ChunkMahouRequestPacket.sendChunkMahouPackets(sender, message.x, message.z);
            }
        });
    }

    public static void sendChunkMahouPackets(ServerPlayer sender, int x, int z) {
        LevelChunk c = sender.level().getChunk(x, z);
        IChunkMahou chunkMahou = Utils.getChunkMahou(c);
        if (chunkMahou.getLakeBlocks() != null && !chunkMahou.getLakeBlocks().isEmpty()) {
            PacketHandler.sendTo(sender, new ChunkMahouPacket(chunkMahou.getLakeBlocks(), x, z));
        }
        if (chunkMahou.getFogProjectors() != null && !chunkMahou.getFogProjectors().isEmpty()) {
            PacketHandler.sendTo(sender, new ChunkMahouPacket(chunkMahou.getFogProjectors(), x, z, 1));
        }
    }

    public CustomPacketPayload.Type<ChunkMahouRequestPacket> type() {
        return MahouPackets.CHUNK_MAHOU_REQUEST_TYPE;
    }
}

