/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.potion;

import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.neoforge.event.level.BlockEvent;
import stepsword.mahoutsukai.advancements.MahouTrigger;
import stepsword.mahoutsukai.advancements.ModTriggers;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.entity.ModEntities;
import stepsword.mahoutsukai.entity.butterfly.ButterflyEntity;
import stepsword.mahoutsukai.potion.ModEffects;
import stepsword.mahoutsukai.util.EffectUtil;

public class ForesightPotion
extends MobEffect {
    protected ForesightPotion() {
        super(MobEffectCategory.NEUTRAL, ModEffects.getColorNumber(252, 45, 45));
    }

    public static boolean checkBlockAndChunk(BlockPos p, Level level) {
        LevelChunk c = (LevelChunk)level.getChunk(p);
        ChunkPos cp = c.getPos();
        AABB aabb = new AABB((double)cp.getMinBlockX(), (double)level.getMinBuildHeight(), (double)cp.getMinBlockZ(), (double)cp.getMaxBlockX(), (double)level.getMaxBuildHeight(), (double)cp.getMaxBlockZ());
        List lst = level.getEntities((EntityTypeTest)ModEntities.BUTTERFLY.get(), aabb, Objects::nonNull);
        int numBlock = 0;
        int numChunk = 0;
        for (ButterflyEntity be : lst) {
            if (be.origPos.equals((Object)p)) {
                ++numBlock;
            }
            ++numChunk;
            if (numBlock >= MTConfig.BUTTERFLY_EFFECT_BLOCK_LIMIT) {
                return false;
            }
            if (numChunk < MTConfig.BUTTERFLY_EFFECT_CHUNK_LIMIT) continue;
            return false;
        }
        return true;
    }

    public static void butterflyPlaceBlock(BlockEvent.EntityPlaceEvent event) {
        if (event.getEntity() instanceof Player) {
            Player player = (Player)event.getEntity();
            if (!player.level().isClientSide && EffectUtil.hasBuff((LivingEntity)player, ModEffects.FORESIGHT) && !event.getPlacedBlock().hasBlockEntity() && player.getMainHandItem().getItem() instanceof BlockItem) {
                ButterflyEntity butterfly = new ButterflyEntity(event.getEntity().level(), player, player.getRandom().nextInt(6000000), player.getRandom().nextFloat() * 0.5f + 0.2f);
                HitResult result = player.pick(8.0, 1.0f, false);
                if (result instanceof BlockHitResult) {
                    BlockHitResult r = (BlockHitResult)result;
                    butterfly.setPlaceEffect(event.getPos(), r.getDirection(), event.getPlacedBlock(), player.getMainHandItem().split(1));
                    if (ForesightPotion.checkBlockAndChunk(butterfly.origPos, player.level())) {
                        player.level().addFreshEntity((Entity)butterfly);
                        ((MahouTrigger)((Object)ModTriggers.BUTTERFLY.get())).trigger((ServerPlayer)player);
                        event.setCanceled(true);
                        if (MTConfig.BUTTERFLY_EFFECT_SINGLE_USE) {
                            EffectUtil.debuff((LivingEntity)player, ModEffects.FORESIGHT);
                        }
                    }
                }
            }
        }
    }

    public static void butterflyBreakBlock(BlockEvent.BreakEvent event) {
        HitResult result;
        if (!event.getPlayer().level().isClientSide && event.getPlayer() != null && !event.getState().isAir() && !event.getState().hasBlockEntity() && EffectUtil.hasBuff((LivingEntity)event.getPlayer(), ModEffects.FORESIGHT) && (result = event.getPlayer().pick(8.0, 1.0f, false)) instanceof BlockHitResult) {
            BlockHitResult r = (BlockHitResult)result;
            ButterflyEntity butterfly = new ButterflyEntity(event.getPlayer().level(), event.getPlayer(), event.getPlayer().getRandom().nextInt(6000000), event.getPlayer().getRandom().nextFloat() * 0.5f + 0.2f);
            butterfly.setBreakEffect(event.getPos(), r.getDirection(), event.getState());
            if (ForesightPotion.checkBlockAndChunk(butterfly.origPos, event.getPlayer().level())) {
                ((MahouTrigger)((Object)ModTriggers.BUTTERFLY.get())).trigger((ServerPlayer)event.getPlayer());
                event.getPlayer().level().addFreshEntity((Entity)butterfly);
                event.setCanceled(true);
                if (MTConfig.BUTTERFLY_EFFECT_SINGLE_USE) {
                    EffectUtil.debuff((LivingEntity)event.getPlayer(), ModEffects.FORESIGHT);
                }
            }
        }
    }

    public static void butterflyHit(Player player) {
        if (player != null && !player.level().isClientSide && EffectUtil.hasBuff((LivingEntity)player, ModEffects.FORESIGHT)) {
            ButterflyEntity butterfly = new ButterflyEntity(player.level(), player, player.getRandom().nextInt(6000000), player.getRandom().nextFloat() * 0.5f + 0.2f);
            butterfly.setHitEffect(player, player.getMainHandItem(), player.getOffhandItem());
            if (ForesightPotion.checkBlockAndChunk(butterfly.origPos, player.level())) {
                player.level().addFreshEntity((Entity)butterfly);
                ((MahouTrigger)((Object)ModTriggers.BUTTERFLY.get())).trigger((ServerPlayer)player);
                if (MTConfig.BUTTERFLY_EFFECT_SINGLE_USE) {
                    EffectUtil.debuff((LivingEntity)player, ModEffects.FORESIGHT);
                }
            }
        }
    }
}

