/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.potion;

import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import stepsword.mahoutsukai.dataattachments.mahou.IMahou;
import stepsword.mahoutsukai.mana.PlayerManaManager;
import stepsword.mahoutsukai.potion.ModEffects;
import stepsword.mahoutsukai.potion.ScrollPotion;
import stepsword.mahoutsukai.util.EffectUtil;
import stepsword.mahoutsukai.util.Utils;

public class ImmunityExchangePotion
extends ScrollPotion {
    protected ImmunityExchangePotion() {
        super(ModEffects.getColorNumber(252, 45, 225));
    }

    public static boolean immunityExchangeLivingHurt(LivingIncomingDamageEvent event) {
        IMahou mahou;
        LivingEntity e = event.getEntity();
        boolean ret = false;
        if (EffectUtil.hasBuff(e, ModEffects.IMMUNITY_EXCHANGE) && e instanceof Player && (mahou = Utils.getPlayerMahou((Player)e)) != null && event.getSource() != e.damageSources().fellOutOfWorld()) {
            String last = mahou.getImmunityDamageType();
            if (last != null && !last.equals("")) {
                if (last.equals(event.getSource().getMsgId())) {
                    event.setAmount(0.0f);
                    ret = true;
                } else {
                    event.setAmount(event.getAmount() * 2.0f);
                    ret = false;
                }
            }
            mahou.setImmunityDamageType(event.getSource().getMsgId());
            if (e instanceof ServerPlayer) {
                PlayerManaManager.updateClientMahou((ServerPlayer)e, mahou);
            }
        }
        return ret;
    }
}

