/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.render.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.resources.ResourceLocation;
import stepsword.mahoutsukai.client.ClientHandler;
import stepsword.mahoutsukai.entity.LightningEntity;
import stepsword.mahoutsukai.render.MahoujinRenderType;
import stepsword.mahoutsukai.render.RenderUtils;

public class RenderLightningEntity
extends EntityRenderer<LightningEntity> {
    private static final ResourceLocation beam = ResourceLocation.fromNamespaceAndPath((String)"mahoutsukai", (String)"textures/block/white.png");

    public RenderLightningEntity(EntityRendererProvider.Context renderManager) {
        super(renderManager);
    }

    public ResourceLocation getTextureLocation(LightningEntity entity) {
        return TextureAtlas.LOCATION_BLOCKS;
    }

    public void render(LightningEntity entity, float eyaw, float partialTicks, PoseStack matrix, MultiBufferSource buffer, int packedLight) {
    }

    public static void renderLightning(LightningEntity entity, double x, double y, double z, PoseStack matrix, float partialTicks) {
        float h;
        float pit;
        int i;
        matrix.pushPose();
        matrix.translate(x, y, z);
        float[] colors = entity.getColor();
        int lightmapX = 240;
        int lightmapY = 240;
        float w = entity.getBeamSize();
        float r2 = colors[0];
        float g2 = colors[1];
        float b2 = colors[2];
        float a2 = colors[3];
        float r = 1.0f;
        float g = 1.0f;
        float b = 1.0f;
        float a = 1.0f;
        r2 = 0.2f;
        g2 = 0.5f;
        b2 = 1.0f;
        a2 = 0.2f;
        RenderUtils.rotateQ(entity.yaw, 0.0f, 1.0f, 0.0f, matrix);
        RenderUtils.rotateQ(entity.pitch, 1.0f, 0.0f, 0.0f, matrix);
        if (entity.getZap()) {
            RenderUtils.rotateQ(-ClientHandler.clientTickCounter % 40L, 0.0f, 1.0f, 0.0f, matrix);
        } else {
            RenderUtils.rotateQ(ClientHandler.clientTickCounter % 40L, 0.0f, 1.0f, 0.0f, matrix);
        }
        MultiBufferSource.BufferSource buf = Minecraft.getInstance().renderBuffers().bufferSource();
        float th = 0.0f;
        matrix.pushPose();
        if (entity.getHasBall()) {
            RenderType sphere = MahoujinRenderType.wrapCullLayer(MahoujinRenderType.createSphereRenderType(beam, 0));
            RenderUtils.renderSphere(matrix, (MultiBufferSource)buf, w * 5.0f, 14, lightmapX, lightmapY, r, g, b, a, sphere);
            buf.endBatch(sphere);
        }
        matrix.pushPose();
        for (i = 0; i < entity.segments; ++i) {
            RenderType ringType = MahoujinRenderType.wrapCullLayer(MahoujinRenderType.createRunesRenderType(beam, 0));
            pit = entity.prevpitchs[i] + (entity.pitchs[i] - entity.prevpitchs[i]) * partialTicks;
            RenderUtils.rotateQ(pit, 1.0f, 0.0f, 0.0f, matrix);
            h = entity.prevreallengths[i] + (entity.reallengths[i] - entity.prevreallengths[i]) * partialTicks;
            RenderUtils.renderRing(matrix, (MultiBufferSource)buf, 0.0, 90.0f, w, h, 20, 240, 240, r, g, b, a, ringType);
            buf.endBatch(ringType);
            matrix.translate(0.0f, -h, 0.0f);
            th -= h;
            RenderUtils.rotateQ(-pit, 1.0f, 0.0f, 0.0f, matrix);
        }
        matrix.popPose();
        for (i = 0; i < entity.segments; ++i) {
            RenderType ringType2 = MahoujinRenderType.wrapCullLayer(MahoujinRenderType.createRunesRenderType(beam, 1));
            pit = entity.prevpitchs[i] + (entity.pitchs[i] - entity.prevpitchs[i]) * partialTicks;
            RenderUtils.rotateQ(pit, 1.0f, 0.0f, 0.0f, matrix);
            h = entity.prevreallengths[i] + (entity.reallengths[i] - entity.prevreallengths[i]) * partialTicks;
            RenderUtils.renderRing(matrix, (MultiBufferSource)buf, 0.0, 90.0f, w * 2.8f, h, 20, 240, 240, r2, g2, b2, a2, ringType2);
            buf.endBatch(ringType2);
            matrix.translate(0.0f, -h, 0.0f);
            th -= h;
            RenderUtils.rotateQ(-pit, 1.0f, 0.0f, 0.0f, matrix);
        }
        matrix.popPose();
        if (entity.getHasBall()) {
            RenderType sphere = MahoujinRenderType.wrapCullLayer(MahoujinRenderType.createSphereRenderType(beam, 0));
            RenderUtils.renderSphere(matrix, (MultiBufferSource)buf, w * 6.9f, 14, lightmapX, lightmapY, r2, g2, b2, a2 / 2.0f, sphere);
            buf.endBatch(sphere);
        }
        matrix.popPose();
    }
}

