/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.render.item;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import stepsword.mahoutsukai.client.ClientHandler;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.item.morgan.Morgan;
import stepsword.mahoutsukai.render.RenderBaseItem;
import stepsword.mahoutsukai.render.RenderUtils;
import stepsword.mahoutsukai.util.Utils;

public class MorganRenderer
extends BlockEntityWithoutLevelRenderer {
    public MorganRenderer(BlockEntityRenderDispatcher p_172550_, EntityModelSet p_172551_) {
        super(p_172550_, p_172551_);
    }

    public void renderByItem(ItemStack itemStackIn, ItemDisplayContext transform, PoseStack matrix, MultiBufferSource buffer, int var1, int var2) {
        if (itemStackIn != null && itemStackIn.getItem() instanceof Morgan) {
            matrix.pushPose();
            RenderBaseItem.render(itemStackIn, matrix, buffer, 240, var2, RenderBaseItem.morgan, true);
            float offsetx = 0.0f;
            float offsety = 0.0f;
            float offsetz = 0.5f;
            float r = 255.0f;
            float g = 50.0f;
            float b = 50.0f;
            float a = 1.0f;
            float[] colors = Utils.getColor(itemStackIn);
            if (colors != null && colors.length > 2) {
                r = colors[0];
                g = colors[1];
                b = colors[2];
            }
            float rotation = 0.0f;
            float yaw = 90.0f;
            float pitch = 45.0f;
            double speed = MTConfig.POWER_CONSOLIDATION_CALIBURN_RING_SPEED;
            float ring = 90.0f;
            float size = 1.0f;
            float pull = Minecraft.getInstance().level != null ? (float)(ClientHandler.clientTickCounter % 360L) : 0.0f;
            rotation = (float)((double)rotation + (double)pull * speed);
            float secondrotation = (float)(360.0 - (double)pull * speed % 360.0);
            secondrotation %= 360.0f;
            matrix.translate(offsetx, offsety, offsetz);
            RenderUtils.rotateQ(yaw, 0.0f, 1.0f, 0.0f, matrix);
            RenderUtils.rotateQ(pitch, 1.0f, 0.0f, 0.0f, matrix);
            RenderUtils.rotateQ(rotation %= 360.0f, 0.0f, 1.0f, 0.0f, matrix);
            int lightmapX = 240;
            int lightmapY = 240;
            RenderType t1 = RenderUtils.renderRing(matrix, buffer, (double)0.907f, ring - 20.0f, size / 8.9f, 0.05f, 48, lightmapX, lightmapY, r /= 255.0f, g /= 255.0f, b /= 255.0f, a, 0, transform);
            RenderUtils.rotateQ(rotation, 0.0f, -1.0f, 0.0f, matrix);
            RenderUtils.rotateQ(secondrotation, 0.0f, 1.0f, 0.0f, matrix);
            RenderType t2 = RenderUtils.renderRing(matrix, buffer, 0.7, ring - 10.0f, size / 6.8f, 0.05f, 48, lightmapX, lightmapY, r, g, b, a, 1, transform);
            RenderUtils.rotateQ(secondrotation, 0.0f, -1.0f, 0.0f, matrix);
            RenderUtils.rotateQ(rotation, 0.0f, 1.0f, 0.0f, matrix);
            RenderType t3 = RenderUtils.renderRing(matrix, buffer, 0.5, ring - 4.0f, size / 3.7f, 0.09f, 48, lightmapX, lightmapY, r, g, b, a, 2, transform);
            matrix.popPose();
            RenderUtils.conditionalBatchEnder(t1, buffer);
            RenderUtils.conditionalBatchEnder(t2, buffer);
            RenderUtils.conditionalBatchEnder(t3, buffer);
        }
    }
}

