/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.render.overlay;

import com.mojang.blaze3d.shaders.FogShape;
import io.netty.util.internal.ConcurrentSet;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.client.event.ViewportEvent;
import stepsword.mahoutsukai.block.ModBlocks;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.dataattachments.chunks.IChunkMahou;
import stepsword.mahoutsukai.render.gui.FogProjectorScreen;
import stepsword.mahoutsukai.tile.FogProjectorTileEntity;
import stepsword.mahoutsukai.util.EffectUtil;
import stepsword.mahoutsukai.util.Utils;

public class RenderFogProjectors {
    public static ConcurrentSet<FogProjectorTileEntity> distanceToFog(Entity entity) {
        int r = (int)MTConfig.FOG_PROJECTOR_MAX_RADIUS;
        BlockPos minPos = entity.blockPosition().offset(-r, -r, -r);
        BlockPos maxPos = entity.blockPosition().offset(r, r, r);
        ChunkPos minCPos = new ChunkPos(minPos);
        ChunkPos maxCPos = new ChunkPos(maxPos);
        ConcurrentSet ret = new ConcurrentSet();
        try {
            for (int x = minCPos.x; x < maxCPos.x + 1; ++x) {
                for (int z = minCPos.z; z < maxCPos.z + 1; ++z) {
                    IChunkMahou chunkMahou;
                    ConcurrentSet<BlockPos> blocks;
                    LevelChunk c = entity.level().getChunk(x, z);
                    if (!(c instanceof LevelChunk) || (blocks = (chunkMahou = Utils.getChunkMahou(c)).getFogProjectors()) == null || blocks.size() <= 0) continue;
                    for (BlockPos p : blocks) {
                        BlockEntity be;
                        Block b = entity.level().getBlockState(p).getBlock();
                        if (b != ModBlocks.fogProjector.get() || Math.abs(p.getX() - entity.blockPosition().getX()) >= r || Math.abs(p.getZ() - entity.blockPosition().getZ()) >= r || Math.abs(p.getY() - entity.blockPosition().getY()) >= r || !((be = entity.level().getBlockEntity(p)) instanceof FogProjectorTileEntity) || !((FogProjectorTileEntity)be).get_camera_fog_toggle() || entity.level().hasNeighborSignal(p)) continue;
                        ret.add((Object)((FogProjectorTileEntity)be));
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret;
    }

    public static boolean fogProjectorColor(ViewportEvent.ComputeFogColor event) {
        boolean ret = false;
        double td = 0.0;
        double tr = 0.0;
        double tg = 0.0;
        double tb = 0.0;
        boolean doChange = false;
        ConcurrentSet<FogProjectorTileEntity> blocks = RenderFogProjectors.distanceToFog(Minecraft.getInstance().getCameraEntity());
        for (FogProjectorTileEntity te : blocks) {
            Vec3 v = EffectUtil.fromBlockPos(te.getBlockPos()).add(0.5, 0.5, 0.5);
            double d = v.distanceTo(Minecraft.getInstance().getCameraEntity().position());
            if (d <= 0.0) {
                d = 1.0E-8;
            }
            if (!(d < (double)te.get_camera_fog_radius())) continue;
            double colorstrength = ((double)te.get_camera_fog_radius() - d) / (double)te.get_camera_fog_radius();
            td += (colorstrength *= 2.0);
            tr += (double)te.get_camera_fog_color_r() * colorstrength;
            tg += (double)te.get_camera_fog_color_g() * colorstrength;
            tb += (double)te.get_camera_fog_color_b() * colorstrength;
            doChange = true;
        }
        td += 1.0;
        tr += (double)(event.getRed() * 255.0f);
        tg += (double)(event.getGreen() * 255.0f);
        tb += (double)(event.getBlue() * 255.0f);
        if (td > 0.0 && doChange) {
            float r = (float)(tr / td / 255.0);
            float g = (float)(tg / td / 255.0);
            float b = (float)(tb / td / 255.0);
            event.setRed(r);
            event.setGreen(g);
            event.setBlue(b);
            ret = true;
        }
        return ret;
    }

    public static boolean fogProjectorRenderFog(ViewportEvent.RenderFog event) {
        boolean ret = RenderFogProjectors.doFog(event.getNearPlaneDistance(), event.getFarPlaneDistance(), event);
        if (ret) {
            event.setFogShape(FogShape.SPHERE);
        }
        return ret;
    }

    public static double getStrength() {
        double strength = 0.0;
        ConcurrentSet<FogProjectorTileEntity> blocks = RenderFogProjectors.distanceToFog(Minecraft.getInstance().getCameraEntity());
        for (FogProjectorTileEntity te : blocks) {
            Vec3 v = EffectUtil.fromBlockPos(te.getBlockPos()).add(0.5, 0.5, 0.5);
            double d = v.distanceTo(Minecraft.getInstance().getCameraEntity().position());
            if (!(d < (double)te.get_camera_fog_radius())) continue;
            strength += (double)te.get_camera_fog_strength() - (double)(te.get_camera_fog_strength() / te.get_camera_fog_radius()) * d;
        }
        return strength;
    }

    public static boolean doFog(float nearPlane, float farPlane, ViewportEvent.RenderFog event) {
        boolean ret = false;
        double strength = RenderFogProjectors.getStrength();
        if (strength > 0.0) {
            float offset = 2.0f;
            double f1 = Math.min(strength, (double)FogProjectorScreen.camera_fog_strength_max) / (double)FogProjectorScreen.camera_fog_strength_max;
            float oldstart = nearPlane;
            double f2 = RenderFogProjectors.fogScaleFormula(farPlane, f1);
            double f3 = RenderFogProjectors.fogScaleFormula(oldstart, f1);
            double fogStart = Mth.clamp((double)f3, (double)1.0, (double)oldstart);
            double fogEnd = Mth.clamp((double)f2, (double)4.0, (double)farPlane);
            if (oldstart == 0.0f) {
                fogStart = 0.0;
            }
            float fg = 0.7058824f;
            event.setNearPlaneDistance((float)fogStart);
            event.setFarPlaneDistance((float)fogEnd);
            event.setFogShape(FogShape.SPHERE);
            ret = true;
        }
        return ret;
    }

    public static double fogScaleFormula(float offset, double x) {
        return (x - 1.0) * (x - 1.0) * (x - 1.0) * (x - 1.0) * (double)offset;
    }
}

