/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.render.tile;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.joml.Matrix4f;
import stepsword.mahoutsukai.render.MahoujinRenderType;
import stepsword.mahoutsukai.tile.boundary.InvisibleBarrierBlockTileEntity;

public class InvisibleBarrierBlockRenderer
implements BlockEntityRenderer<InvisibleBarrierBlockTileEntity> {
    public static Color fullyLit = new Color(25, 243, 255, 255);

    public InvisibleBarrierBlockRenderer(BlockEntityRendererProvider.Context rendererDispatcherIn) {
    }

    public void render(InvisibleBarrierBlockTileEntity te, float v, PoseStack matrixStack, MultiBufferSource MultiBufferSource2, int v1, int v2) {
        matrixStack.pushPose();
        long[] times = new long[6];
        Direction[] facings = new Direction[]{Direction.NORTH, Direction.EAST, Direction.WEST, Direction.SOUTH, Direction.UP, Direction.DOWN};
        times[0] = te.getTimeSinceCollision(Direction.NORTH);
        times[1] = te.getTimeSinceCollision(Direction.EAST);
        times[2] = te.getTimeSinceCollision(Direction.WEST);
        times[3] = te.getTimeSinceCollision(Direction.SOUTH);
        times[4] = te.getTimeSinceCollision(Direction.UP);
        times[5] = te.getTimeSinceCollision(Direction.DOWN);
        int cmp = 20;
        for (int i = 0; i < facings.length; ++i) {
            if (times[i] >= (long)cmp) continue;
            float percent = 1.0f * (float)((long)cmp - times[i]);
            percent /= (float)cmp * 1.0f;
            percent = Mth.clamp((float)percent, (float)0.0f, (float)1.0f);
            this.renderSide(matrixStack, percent, facings[i]);
        }
        matrixStack.popPose();
    }

    public void renderSide(PoseStack matrix, float percent, Direction facing) {
        float a2;
        float b2;
        float c2;
        float d2;
        float c1;
        float d1;
        float b3;
        float c3;
        float a1;
        float b1;
        float a3;
        float d3;
        Color c = new Color((int)Math.floor((float)fullyLit.getRed() * percent), (int)Math.floor((float)fullyLit.getGreen() * percent), (int)Math.floor((float)fullyLit.getBlue() * percent), (int)Math.floor((float)fullyLit.getAlpha() * percent));
        int r = c.getRed();
        int g = c.getGreen();
        int b = c.getBlue();
        int a = c.getAlpha();
        float z1 = 0.0f;
        float y1 = 0.0f;
        float x1 = 0.0f;
        float x2 = x1 + 1.0f;
        float y2 = y1 + 1.0f;
        float z2 = z1 + 1.0f;
        RenderType type = MahoujinRenderType.createMahoujinRenderType(ResourceLocation.fromNamespaceAndPath((String)"mahoutsukai", (String)"textures/block/barrier_hit.png"), 0, false);
        Matrix4f positionMatrix = matrix.last().pose();
        MultiBufferSource.BufferSource buffer = Minecraft.getInstance().renderBuffers().bufferSource();
        switch (facing) {
            case UP: {
                a3 = d3 = z1;
                a1 = b1 = x1;
                b3 = c3 = z2;
                c1 = d1 = x2;
                c2 = d2 = y2;
                b2 = d2;
                a2 = d2;
                break;
            }
            case DOWN: {
                b3 = c3 = z1;
                a1 = b1 = x1;
                a3 = d3 = z2;
                c1 = d1 = x2;
                c2 = d2 = y1;
                b2 = d2;
                a2 = d2;
                break;
            }
            case EAST: {
                d3 = c3 = z1;
                b2 = c2 = y1;
                a3 = b3 = z2;
                a2 = d2 = y2;
                c1 = d1 = x2;
                b1 = d1;
                a1 = d1;
                break;
            }
            case WEST: {
                a3 = b3 = z1;
                b2 = c2 = y1;
                d3 = c3 = z2;
                a2 = d2 = y2;
                c1 = d1 = x1;
                b1 = d1;
                a1 = d1;
                break;
            }
            case SOUTH: {
                a1 = b1 = x1;
                b2 = c2 = y1;
                c1 = d1 = x2;
                a2 = d2 = y2;
                c3 = d3 = z2;
                b3 = d3;
                a3 = d3;
                break;
            }
            case NORTH: {
                c1 = d1 = x1;
                b2 = c2 = y1;
                a1 = b1 = x2;
                a2 = d2 = y2;
                c3 = d3 = z1;
                b3 = d3;
                a3 = d3;
                break;
            }
            default: {
                throw new IllegalArgumentException(facing.toString());
            }
        }
        int lx = 240;
        int ly = 240;
        VertexConsumer buf = buffer.getBuffer(type);
        buf.addVertex(positionMatrix, a1, a2, a3).setColor(r, g, b, a).setUv(0.0f, 0.0f).setUv2(lx, ly);
        buf.addVertex(positionMatrix, b1, b2, b3).setColor(r, g, b, a).setUv(0.0f, 1.0f).setUv2(lx, ly);
        buf.addVertex(positionMatrix, c1, c2, c3).setColor(r, g, b, a).setUv(1.0f, 1.0f).setUv2(lx, ly);
        buf.addVertex(positionMatrix, d1, d2, d3).setColor(r, g, b, a).setUv(1.0f, 0.0f).setUv2(lx, ly);
        buffer.endBatch(type);
        buf = buffer.getBuffer(type);
        buf.addVertex(positionMatrix, a1, a2, a3).setColor(r, g, b, a).setUv(0.0f, 0.0f).setUv2(lx, ly);
        buf.addVertex(positionMatrix, d1, d2, d3).setColor(r, g, b, a).setUv(0.0f, 1.0f).setUv2(lx, ly);
        buf.addVertex(positionMatrix, c1, c2, c3).setColor(r, g, b, a).setUv(1.0f, 1.0f).setUv2(lx, ly);
        buf.addVertex(positionMatrix, b1, b2, b3).setColor(r, g, b, a).setUv(1.0f, 0.0f).setUv2(lx, ly);
        buffer.endBatch(type);
    }
}

