/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.tile;

import java.util.ArrayList;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import stepsword.mahoutsukai.item.FaeEssence;
import stepsword.mahoutsukai.item.catalysts.PowderedCatalyst;
import stepsword.mahoutsukai.tile.ModTileEntities;
import stepsword.mahoutsukai.tile.UpdatingTileEntity;
import stepsword.mahoutsukai.util.UnorderedList;

public class MahoujinTileEntity
extends UpdatingTileEntity {
    private UUID casterUUID;
    private boolean cloth;
    private boolean fay;
    public static final String ORDER_TAG = "catalyst_order";
    public static final String CASTER_ID = "caster_uuid";
    public static final String CLOTH_BOOLEAN = "cloth";
    public static final String FAY_TAG = "fay";
    private UnorderedList catalysts;

    public MahoujinTileEntity(BlockPos p, BlockState bs) {
        super((BlockEntityType)ModTileEntities.mahoujin.get(), p, bs);
    }

    public MahoujinTileEntity(BlockEntityType type, BlockPos p, BlockState bs) {
        super(type, p, bs);
    }

    public void saveAdditional(CompoundTag compound, HolderLookup.Provider provider) {
        CompoundTag order = new CompoundTag();
        if (this.catalysts == null) {
            this.catalysts = new UnorderedList();
        }
        ArrayList<String> orderList = this.catalysts.getOrder();
        for (int i = 0; i < orderList.size(); ++i) {
            order.putString("" + i, orderList.get(i));
        }
        compound.put(ORDER_TAG, (Tag)order);
        compound.putBoolean(FAY_TAG, this.fay);
        if (this.casterUUID != null) {
            compound.putUUID(CASTER_ID, this.casterUUID);
        }
        compound.putBoolean(CLOTH_BOOLEAN, this.cloth);
        super.saveAdditional(compound, provider);
    }

    public void loadAdditional(CompoundTag compound, HolderLookup.Provider provider) {
        ArrayList<String> order = new ArrayList<String>();
        CompoundTag orderTag = (CompoundTag)compound.get(ORDER_TAG);
        for (int i = 0; i < orderTag.getAllKeys().size(); ++i) {
            order.add(orderTag.getString("" + i));
        }
        this.catalysts = new UnorderedList(order);
        if (compound.hasUUID(CASTER_ID)) {
            this.casterUUID = compound.getUUID(CASTER_ID);
        }
        this.cloth = compound.getBoolean(CLOTH_BOOLEAN);
        this.fay = compound.getBoolean(FAY_TAG);
        super.loadAdditional(compound, provider);
    }

    public UnorderedList getCatalysts() {
        return this.catalysts;
    }

    public void setCatalysts(UnorderedList catalysts) {
        this.setCatalysts(catalysts, true);
    }

    public void setCatalysts(UnorderedList catalysts, boolean update) {
        this.catalysts = catalysts;
        if (update) {
            this.sendUpdates();
        }
    }

    public int getNumCatalysts() {
        return this.catalysts == null ? 0 : this.catalysts.size();
    }

    public boolean addCatalyst(PowderedCatalyst catalyst) {
        return this.addCatalyst(catalyst, true);
    }

    public boolean addCatalyst(PowderedCatalyst catalyst, boolean update) {
        if (this.catalysts == null) {
            this.catalysts = new UnorderedList();
        }
        if (this.catalysts.size() >= 3) {
            if (update) {
                this.sendUpdates();
            }
            return false;
        }
        this.catalysts.add(catalyst.getCatalystName(), true);
        if (update) {
            this.sendUpdates();
        }
        return true;
    }

    public Player getCaster() {
        if (this.casterUUID == null || this.casterUUID.equals(UUID.fromString("00000000-0000-0000-0000-000000000000")) || this.casterUUID.equals(FaeEssence.faeID)) {
            return null;
        }
        if (this.level instanceof ServerLevel && this.level.getServer() != null) {
            return this.level.getServer().getPlayerList().getPlayer(this.casterUUID);
        }
        if (this.level != null) {
            return this.level.getPlayerByUUID(this.casterUUID);
        }
        return null;
    }

    public UUID getCasterUUID() {
        return this.casterUUID;
    }

    public void setCasterUUID(UUID casterUUID) {
        this.casterUUID = casterUUID;
        this.sendUpdates();
    }

    public void setCaster(Player caster) {
        this.casterUUID = caster.getUUID();
        this.sendUpdates();
    }

    public boolean hasCloth() {
        return this.cloth;
    }

    public void setCloth(boolean c) {
        this.cloth = c;
    }

    public boolean isFay() {
        return this.fay;
    }

    public void setFay(boolean c) {
        this.fay = c;
    }
}

