/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.tile.displacement;

import java.util.Comparator;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.TicketType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.mana.ActiveCircleConfig;
import stepsword.mahoutsukai.mana.PlayerManaManager;
import stepsword.mahoutsukai.tile.AboveChecker;
import stepsword.mahoutsukai.tile.MahoujinTickingTileEntity;
import stepsword.mahoutsukai.tile.ModTileEntities;
import stepsword.mahoutsukai.util.EffectUtil;
import stepsword.mahoutsukai.util.MahouTsukaiTeleporter;

public class EquivalentDisplacementMahoujinTileEntity
extends MahoujinTickingTileEntity
implements AboveChecker {
    TicketType<ChunkPos> ticket = null;
    private int receivingTickCounter = 0;
    public boolean startLoadingPartner = false;
    private BlockPos targetLocation = null;
    private ResourceLocation targetDimension = null;
    public static String TELEPORTER_BOUND_TAG_X = "MAHOUTSUKAI_BOUND_TELEPORTER_TAG_X";
    public static String TELEPORTER_BOUND_TAG_Y = "MAHOUTSUKAI_BOUND_TELEPORTER_TAG_Y";
    public static String TELEPORTER_BOUND_TAG_Z = "MAHOUTSUKAI_BOUND_TELEPORTER_TAG_Z";
    public static String TELEPORTER_BOUND_TAG_D = "MAHOUTSUKAI_BOUND_TELEPORTER_TAG_D";

    public EquivalentDisplacementMahoujinTileEntity(BlockPos p, BlockState bs) {
        super((BlockEntityType)ModTileEntities.equivalentDisplacement.get(), p, bs);
    }

    @Override
    public void saveAdditional(CompoundTag compound, HolderLookup.Provider provider) {
        if (this.targetLocation != null) {
            compound.putInt(TELEPORTER_BOUND_TAG_X, this.targetLocation.getX());
            compound.putInt(TELEPORTER_BOUND_TAG_Y, this.targetLocation.getY());
            compound.putInt(TELEPORTER_BOUND_TAG_Z, this.targetLocation.getZ());
        }
        if (this.targetDimension != null) {
            compound.putString(TELEPORTER_BOUND_TAG_D, this.targetDimension.toString());
        }
        super.saveAdditional(compound, provider);
    }

    @Override
    public void loadAdditional(CompoundTag compound, HolderLookup.Provider provider) {
        if (compound.contains(TELEPORTER_BOUND_TAG_X) && compound.contains(TELEPORTER_BOUND_TAG_Y) && compound.contains(TELEPORTER_BOUND_TAG_Z)) {
            int x = compound.getInt(TELEPORTER_BOUND_TAG_X);
            int y = compound.getInt(TELEPORTER_BOUND_TAG_Y);
            int z = compound.getInt(TELEPORTER_BOUND_TAG_Z);
            this.targetLocation = new BlockPos(x, y, z);
        }
        this.targetDimension = compound.contains(TELEPORTER_BOUND_TAG_D) ? ResourceLocation.parse((String)compound.getString(TELEPORTER_BOUND_TAG_D)) : BuiltinDimensionTypes.OVERWORLD.location();
        if (this.level == null || !this.level.isClientSide) {
            // empty if block
        }
        super.loadAdditional(compound, provider);
    }

    public BlockPos getTargetLocation() {
        return this.targetLocation;
    }

    public ResourceLocation getTargetDimension() {
        return this.targetDimension;
    }

    public void setTargetLocation(BlockPos pos) {
        this.targetLocation = pos;
    }

    public void setTargetDimension(ResourceLocation d) {
        this.targetDimension = d;
    }

    public ResourceLocation getDimension() {
        if (this.level != null) {
            return EffectUtil.getDimension(this.level);
        }
        return null;
    }

    public void setReceivingTickCounter(int t) {
        this.receivingTickCounter = t;
    }

    @Override
    public void mahoujinTick(Level level, BlockPos blockPos, BlockState blockState, MahoujinTickingTileEntity blockEntity) {
        if (!level.isClientSide && this.receivingTickCounter > 0) {
            --this.receivingTickCounter;
        }
        this.loadChunks();
    }

    @Override
    public int checkTicks() {
        return MTConfig.EQUIVALENT_DISPLACEMENT_BLOCK_CYCLE;
    }

    @Override
    public void noEntityFoundAbove() {
        this.startLoadingPartner = false;
    }

    @Override
    public boolean ifEntityFoundAbove(Entity e) {
        this.startLoadingPartner = true;
        BlockPos target = this.getTargetLocation();
        ResourceLocation d = this.getDimension();
        EquivalentDisplacementMahoujinTileEntity tte = this.getTargetTE(target, this.targetDimension);
        Entity here = e;
        if (tte != null) {
            List theres = tte.checkAbove(tte, true);
            Entity there = !theres.isEmpty() ? (Entity)theres.getFirst() : null;
            boolean iTeleport = EquivalentDisplacementMahoujinTileEntity.doITeleport(this.worldPosition, target, d, this.targetDimension);
            if (iTeleport && here != null && there != null && !here.isDiscrete() && !there.isDiscrete()) {
                Player caster = this.getCaster();
                boolean nearbyBatteriesGaveMana = PlayerManaManager.getManaFromBatteriesFirst(this.worldPosition, this.level, this.getCasterUUID(), MTConfig.EQUIVALENT_DISPLACEMENT_MANA_COST);
                if (nearbyBatteriesGaveMana || caster != null && PlayerManaManager.drainMana(caster, MTConfig.EQUIVALENT_DISPLACEMENT_MANA_COST, false, false) == MTConfig.EQUIVALENT_DISPLACEMENT_MANA_COST) {
                    MahouTsukaiTeleporter.teleport(here, (double)target.getX() + 0.5, target.getY(), (double)target.getZ() + 0.5, this.targetDimension);
                    MahouTsukaiTeleporter.teleport(there, (double)this.worldPosition.getX() + 0.5, this.worldPosition.getY(), (double)this.worldPosition.getZ() + 0.5, d);
                    this.setReceivingTickCounter(MTConfig.EQUIVALENT_DISPLACEMENT_RECEIVE_COOLDOWN);
                    tte.setReceivingTickCounter(MTConfig.EQUIVALENT_DISPLACEMENT_RECEIVE_COOLDOWN);
                }
            }
        }
        return false;
    }

    @Override
    public boolean firstEntityOnly() {
        return true;
    }

    @Override
    public boolean preConditions() {
        BlockPos target = this.getTargetLocation();
        ResourceLocation d = this.getDimension();
        EquivalentDisplacementMahoujinTileEntity tte = this.getTargetTE(target, this.targetDimension);
        if (this.startLoadingPartner && tte != null) {
            tte.loadChunks();
        }
        return !this.level.isClientSide && tte != null && this.receivingTickCounter <= 0 && ActiveCircleConfig.tryToOperate(this, this.getCasterUUID()) && target != null && (!target.equals((Object)this.worldPosition) || d != this.targetDimension) && tte.getCasterUUID().equals(this.getCasterUUID());
    }

    @Override
    public Class<? extends Entity> checkForEntity() {
        return Entity.class;
    }

    public void loadChunks() {
        ChunkPos c = new ChunkPos(this.worldPosition);
        this.level.getChunk(c.x, c.z, ChunkStatus.FULL, true);
        if (this.ticket == null && !this.level.isClientSide) {
            this.ticket = TicketType.create((String)this.serializeTicket(), Comparator.comparingLong(ChunkPos::toLong));
        }
        if (this.ticket != null && !this.level.isClientSide) {
            ChunkPos pos = new ChunkPos(this.getBlockPos());
            ((ServerLevel)this.level).getChunkSource().addRegionTicket(this.ticket, pos, 1, (Object)pos);
        }
    }

    public void releaseChunks() {
        if (this.ticket != null && !this.level.isClientSide) {
            ((ServerLevel)this.level).getChunkSource().removeRegionTicket(this.ticket, new ChunkPos(this.getBlockPos()), 11, (Object)new ChunkPos(this.worldPosition));
        }
    }

    public String serializeTicket() {
        Object ret = "mahoutsukai_";
        ret = (String)ret + this.worldPosition.getX() + "_" + this.worldPosition.getY() + "_" + this.worldPosition.getZ() + "_";
        ret = this.getDimension() != null ? (String)ret + this.getDimension().toString() : (String)ret + "overworld";
        return ret;
    }

    public static boolean doITeleport(BlockPos me, BlockPos target, ResourceLocation md, ResourceLocation td) {
        if (md != td && !MTConfig.EQUIVALENT_DISPLACEMENT_DIMENSIONAL_TRAVEL) {
            return false;
        }
        double maxd = MTConfig.EQUIVALENT_DISPLACEMENT_MAX_DISTANCE;
        if (maxd > 0.0 && me.distSqr((Vec3i)target) > maxd * maxd) {
            return false;
        }
        if (me.getX() != target.getX()) {
            return me.getX() < target.getX();
        }
        if (me.getY() != target.getY()) {
            return me.getY() < target.getY();
        }
        if (me.getZ() != target.getZ()) {
            return me.getZ() < target.getZ();
        }
        return md.hashCode() < td.hashCode();
    }

    public EquivalentDisplacementMahoujinTileEntity getTargetTE(BlockPos pos, ResourceLocation dimension) {
        BlockEntity te;
        ServerLevel worldServer = EffectUtil.getNewDimensionByName((ServerLevel)this.level, dimension);
        if (worldServer != null && pos != null && (te = worldServer.getBlockEntity(pos)) instanceof EquivalentDisplacementMahoujinTileEntity) {
            EquivalentDisplacementMahoujinTileEntity edmte = (EquivalentDisplacementMahoujinTileEntity)te;
            return edmte;
        }
        return null;
    }
}

