/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.util;

import java.util.Objects;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.common.damagesource.DamageContainer;

public class FakeCreeper
extends Creeper {
    public float h = 5000000.0f;

    public FakeCreeper(Level worldIn) {
        super(EntityType.CREEPER, worldIn);
        Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 5000000.0);
    }

    public boolean hurt(DamageSource source, float amount) {
        if (this.isInvulnerable()) {
            return false;
        }
        if (this.level().isClientSide) {
            return false;
        }
        this.noActionTime = 0;
        if (this.getHealth() <= 0.0f) {
            return false;
        }
        if (source.is(DamageTypeTags.IS_FIRE) && this.hasEffect(MobEffects.FIRE_RESISTANCE)) {
            return false;
        }
        float f = amount;
        boolean flag = false;
        boolean flag1 = true;
        this.lastHurt = amount;
        Objects.requireNonNull(this);
        this.invulnerableTime = 20;
        this.actuallyHurt(source, amount);
        this.hurtTime = this.hurtDuration = 10;
        Entity entity1 = source.getEntity();
        if (entity1 != null) {
            TamableAnimal entitywolf;
            if (entity1 instanceof LivingEntity) {
                this.setLastHurtByMob((LivingEntity)entity1);
            }
            if (entity1 instanceof Player) {
                this.lastHurtByPlayerTime = 100;
                this.lastHurtByPlayer = (Player)entity1;
            } else if (entity1 instanceof TamableAnimal && (entitywolf = (TamableAnimal)entity1).isTame()) {
                this.lastHurtByPlayerTime = 100;
                this.lastHurtByPlayer = null;
            }
        }
        if (flag1) {
            if (flag) {
                this.level().broadcastEntityEvent((Entity)this, (byte)29);
            } else {
                byte b0 = source.is(DamageTypeTags.IS_DROWNING) ? (byte)36 : (source.is(DamageTypeTags.IS_FIRE) ? (byte)37 : 2);
                this.level().broadcastEntityEvent((Entity)this, b0);
            }
            if (!(source.is(DamageTypeTags.IS_DROWNING) || flag && !(amount > 0.0f))) {
                this.markHurt();
            }
            if (entity1 != null) {
                double d1 = entity1.getX() - this.getX();
                double d0 = entity1.getZ() - this.getZ();
                while (d1 * d1 + d0 * d0 < 1.0E-4) {
                    d1 = (Math.random() - Math.random()) * 0.01;
                    d0 = (Math.random() - Math.random()) * 0.01;
                }
            }
        }
        boolean flag2 = !flag || amount > 0.0f;
        return flag2;
    }

    protected void actuallyHurt(DamageSource damageSrc, float damageAmount) {
        if (!this.isInvulnerable()) {
            DamageContainer container = new DamageContainer(damageSrc, damageAmount);
            if ((damageAmount = CommonHooks.onLivingDamagePre((LivingEntity)this, (DamageContainer)container)) <= 0.0f) {
                return;
            }
            damageAmount = this.getDamageAfterArmorAbsorb(damageSrc, damageAmount);
            float f = damageAmount = this.getDamageAfterMagicAbsorb(damageSrc, damageAmount);
            damageAmount = Math.max(damageAmount - this.getAbsorptionAmount(), 0.0f);
            this.setAbsorptionAmount(this.getAbsorptionAmount() - (f - damageAmount));
            CommonHooks.onLivingDamagePost((LivingEntity)this, (DamageContainer)container);
            damageAmount = container.getNewDamage();
            if (damageAmount != 0.0f) {
                float f1 = this.h;
                this.h = f1 - damageAmount;
                this.setAbsorptionAmount(this.getAbsorptionAmount() - damageAmount);
            }
        }
    }
}

